/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.Geom;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.pdraw.action.MoveFiguresAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.util.LogoComfortStatusLine;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StandardDrawingView
extends JPanel
implements DrawingView,
MouseListener,
MouseMotionListener,
KeyListener {
    private transient DrawingEditor fEditor;
    private Drawing fDrawing;
    private transient Vector fSelection;
    private transient Vector fSelectionHandles;
    private Dimension fViewSize;
    private Point fLastClick;
    private Vector fBackgrounds = null;
    private Vector fForegrounds = null;
    private Painter fUpdateStrategy;
    private PointConstrainer fConstrainer;
    private static final long serialVersionUID = -3878153366174603336L;
    private int drawingViewSerializedDataVersion = 1;
    protected double SCALE_X = 1.0;
    protected double SCALE_Y = 1.0;

    public StandardDrawingView(DrawingEditor editor, int width, int height) {
        this.fEditor = editor;
        this.fViewSize = new Dimension(width, height);
        this.fLastClick = new Point(0, 0);
        this.fConstrainer = null;
        this.fSelection = new Vector();
        this.setDisplayUpdate(new BufferedUpdateStrategy());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public Figure add(Figure figure) {
        return this.drawing().add(figure);
    }

    public void addAll(Vector figures) {
        FigureEnumerator k = new FigureEnumerator(figures);
        while (k.hasMoreElements()) {
            this.add(k.nextFigure());
        }
    }

    public void addBackground(Painter painter) {
        if (this.fBackgrounds == null) {
            this.fBackgrounds = new Vector(3);
        }
        this.fBackgrounds.addElement(painter);
        this.repaint();
    }

    public void addForeground(Painter painter) {
        if (this.fForegrounds == null) {
            this.fForegrounds = new Vector(3);
        }
        this.fForegrounds.addElement(painter);
        this.repaint();
    }

    public void addToSelection(Figure figure) {
        if (!this.fSelection.contains(figure)) {
            this.fSelection.addElement(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.figureSelected(figure);
            this.selectionChanged();
        }
        this.setPageNumberForSelection();
    }

    protected void figureSelected(Figure figure) {
    }

    protected void figureDeselected(Figure figure) {
    }

    public void addToSelectionAll(Vector figures) {
        FigureEnumerator k = new FigureEnumerator(figures);
        while (k.hasMoreElements()) {
            this.addToSelection(k.nextFigure());
        }
    }

    public synchronized void checkDamage() {
        this.fDrawing.checkDamage();
    }

    private void checkMinimumSize() {
        FigureEnumeration k = this.drawing().figures();
        Dimension d = new Dimension(0, 0);
        while (k.hasMoreElements()) {
            Rectangle r = k.nextFigure().displayBox();
            d.width = Math.max(d.width, r.x + r.width);
            d.height = Math.max(d.height, r.y + r.height);
        }
        if (this.fViewSize.height < d.height || this.fViewSize.width < d.width) {
            this.fViewSize.height = d.height + 10;
            this.fViewSize.width = d.width + 10;
            this.setSize(this.fViewSize);
        }
    }

    public void clearSelection() {
        FigureEnumeration k = this.selectionElements();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            figure.invalidate();
            this.figureDeselected(figure);
        }
        this.fSelection = new Vector();
        this.fSelectionHandles = null;
        this.selectionChanged();
        LogoComfort logoComfort = (LogoComfort)this.fEditor;
        LogoComfortStatusLine statusLine = (LogoComfortStatusLine)logoComfort.getStatusLine();
        if (statusLine != null) {
            statusLine.setPage(0);
        }
    }

    protected Point constrainPoint(Point p) {
        Dimension size = ((LogoDrawing)this.drawing()).getViewSize100();
        p.x = Geom.range(1, size.width, p.x);
        p.y = Geom.range(1, size.height, p.y);
        return p;
    }

    public String cutString(String origin, FontMetrics metric, int leftPos, int rightPos) {
        return "";
    }

    public void drawAll(Graphics g) {
        boolean isPrinting = g instanceof PrintGraphics;
        if (!isPrinting) {
            this.drawBackground(g);
        }
        if (this.fBackgrounds != null && !isPrinting) {
            this.drawPainters(g, this.fBackgrounds);
        }
        this.drawDrawing(g);
        if (this.fForegrounds != null && !isPrinting) {
            this.drawPainters(g, this.fForegrounds);
        }
        if (!isPrinting) {
            this.drawHandles(g);
        }
    }

    public void drawBackground(Graphics g) {
        g.setColor(Global.BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
    }

    public void drawDrawing(Graphics g) {
        this.fDrawing.draw(g);
    }

    public void drawHandles(Graphics g) {
        Enumeration k = this.selectionHandles();
        while (k.hasMoreElements()) {
            ((Handle)k.nextElement()).draw(g);
        }
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    private void drawPainters(Graphics g, Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            ((Painter)v.elementAt(i)).draw(g, this);
        }
    }

    public DrawingEditor editor() {
        return this.fEditor;
    }

    public Handle findHandle(int x, int y) {
        Enumeration k = this.selectionHandles();
        while (k.hasMoreElements()) {
            Handle handle = (Handle)k.nextElement();
            if (!handle.containsPoint(x, y)) continue;
            return handle;
        }
        return null;
    }

    public void freezeView() {
        this.drawing().lock();
    }

    public Vector getBackgrounds() {
        return this.fBackgrounds;
    }

    public PointConstrainer getConstrainer() {
        return this.fConstrainer;
    }

    public FigureSelection getFigureSelection() {
        return new FigureSelection(this.selectionZOrdered());
    }

    public Dimension getMinimumSize() {
        return this.fViewSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Rectangle getSelectionBounds() {
        Rectangle r1 = null;
        Rectangle r2 = null;
        FigureEnumeration k = this.selectionElements();
        while (k.hasMoreElements()) {
            r2 = k.nextFigure().displayBox();
            if (r1 == null) {
                r1 = new Rectangle(r2);
                continue;
            }
            r1.add(r2);
        }
        return r1;
    }

    public Point getAlignSelectionBounds() {
        Rectangle r1 = null;
        Point alignmentAnchor = null;
        FigureEnumeration k = this.selectionElements();
        while (k.hasMoreElements()) {
            alignmentAnchor = k.nextFigure().getAlignmentAnchor();
            if (r1 == null) {
                r1 = new Rectangle(alignmentAnchor);
                continue;
            }
            r1.add(alignmentAnchor);
        }
        return r1.getLocation();
    }

    public boolean keyDown(Event evt, int key) {
        if (key == 27) {
            this.tool().keyDown(new KeyEvent(this, 0, 0L, 0, 27), key, this);
            return true;
        }
        return false;
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (this.tool() != null) {
            this.tool().keyDown(e, code, this);
        }
        this.checkDamage();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public Point lastClick() {
        return this.fLastClick;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        this.tool().mouseDrag(e, p.x, p.y, this);
        this.checkDamage();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.tool().mouseMove(e, p.x, p.y, this);
    }

    public void mousePressed(MouseEvent e) {
        this.fLastClick = new Point(e.getX(), e.getY());
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.requestFocus();
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.tool().mouseDown(e, p.x, p.y, this);
        this.checkDamage();
    }

    public void mouseReleased(MouseEvent e) {
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.tool().mouseUp(e, p.x, p.y, this);
        this.checkDamage();
    }

    private void moveSelection(int dx, int dy) {
        MoveFiguresAction moveFiguresAction = new MoveFiguresAction();
        moveFiguresAction.setOwner((LogoComfort)this.editor());
        moveFiguresAction.setSelectedFigures(this.selection());
        moveFiguresAction.setMoveVector(new Dimension(dx, dy));
        ((LogoComfort)this.editor()).getActionManager().invokeAction(moveFiguresAction);
    }

    public void paintComponent(Graphics g) {
        this.fUpdateStrategy.draw(g, this);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fSelection = new Vector();
        if (this.fDrawing != null) {
            this.fDrawing.addObserver(this);
        }
    }

    public Figure remove(Figure figure) {
        return this.drawing().remove(figure);
    }

    public void removeBackground(Painter painter) {
        if (this.fBackgrounds != null) {
            this.fBackgrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void removeForeground(Painter painter) {
        if (this.fForegrounds != null) {
            this.fForegrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void removeFromSelection(Figure figure) {
        if (this.fSelection.contains(figure)) {
            this.fSelection.removeElement(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.figureDeselected(figure);
            this.selectionChanged();
            this.setPageNumberForSelection();
        }
    }

    public Vector selection() {
        return (Vector)this.fSelection.clone();
    }

    protected void selectionChanged() {
        this.fEditor.selectionChanged(this);
    }

    public boolean selectionContainsFigure(Figure figure) {
        return this.fSelection.contains(figure);
    }

    public int selectionCount() {
        return this.fSelection.size();
    }

    public FigureEnumeration selectionElements() {
        return new FigureEnumerator(this.fSelection);
    }

    protected Enumeration selectionHandles() {
        if (this.fSelectionHandles == null) {
            this.fSelectionHandles = new Vector();
            FigureEnumeration k = this.selectionElements();
            while (k.hasMoreElements()) {
                Figure figure = k.nextFigure();
                Enumeration kk = figure.handles().elements();
                while (kk.hasMoreElements()) {
                    this.fSelectionHandles.addElement(kk.nextElement());
                }
            }
        }
        return this.fSelectionHandles.elements();
    }

    public Vector selectionZOrdered() {
        Vector<Figure> result = new Vector<Figure>(this.fSelection.size());
        FigureEnumeration figures = this.drawing().figures();
        while (figures.hasMoreElements()) {
            Figure f = figures.nextFigure();
            if (!this.fSelection.contains(f)) continue;
            result.addElement(f);
        }
        return result;
    }

    public void setConstrainer(PointConstrainer c) {
        this.fConstrainer = c;
    }

    public void setDisplayUpdate(Painter updateStrategy) {
        this.fUpdateStrategy = updateStrategy;
    }

    public void setDrawing(Drawing d) {
        this.clearSelection();
        if (this.fDrawing != null) {
            this.fDrawing.deleteObserver(this);
        }
        this.fDrawing = d;
        if (this.fDrawing != null) {
            this.fDrawing.addObserver(this);
        }
        this.checkMinimumSize();
        this.repaint();
    }

    public void setEditor(DrawingEditor editor) {
        this.fEditor = editor;
    }

    public void setPageNumberForSelection() {
        if (this.selectionCount() > 0) {
            FigureEnumerator fEnum = new FigureEnumerator(this.fSelection);
            if (this.selectionCount() == 1) {
                Figure f = fEnum.nextFigure();
                int pageNumber = f.getPageNumber();
                LogoComfort logoComfort = (LogoComfort)this.fEditor;
                ((LogoComfortStatusLine)logoComfort.getStatusLine()).setPage(pageNumber);
            } else {
                int minPageNumber = 999;
                int maxPageNumber = 1;
                while (fEnum.hasMoreElements()) {
                    Figure f = fEnum.nextFigure();
                    int pageNumber = f.getPageNumber();
                    minPageNumber = Math.min(minPageNumber, pageNumber);
                    maxPageNumber = Math.max(maxPageNumber, pageNumber);
                }
                LogoComfort logoComfort = (LogoComfort)this.fEditor;
                ((LogoComfortStatusLine)logoComfort.getStatusLine()).setPageRange(minPageNumber, maxPageNumber);
            }
        } else {
            LogoComfort logoComfort = (LogoComfort)this.fEditor;
            ((LogoComfortStatusLine)logoComfort.getStatusLine()).setPage(0);
        }
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.fViewSize = d;
    }

    public void toggleSelection(Figure figure) {
        if (this.fSelection.contains(figure)) {
            this.removeFromSelection(figure);
        } else {
            this.addToSelection(figure);
        }
        this.selectionChanged();
    }

    public Tool tool() {
        return this.fEditor.tool();
    }

    public void unfreezeView() {
        this.drawing().unlock();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void update(Observable sender, Object arg) {
        if (sender == this.fDrawing) {
            Rectangle r = (Rectangle)arg;
            this.repaint(r.x, r.y, r.width, r.height);
        }
    }
}

