/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.util.Clipboard;
import CH.ifa.draw.util.Command;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.util.SortedXDirectionEnumerator;
import java.util.Vector;

abstract class FigureTransferCommand
extends Command {
    protected DrawingView fView;

    protected FigureTransferCommand(String name, DrawingView view) {
        super(name);
        this.fView = view;
    }

    protected void copySelection() {
        FigureSelection selection = this.fView.getFigureSelection();
        Clipboard.getClipboard().setContents(selection);
    }

    protected void deleteSelection() {
        Vector<Figure> deletionFigures = new Vector<Figure>();
        FigureEnumeration k = this.fView.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            deletionFigures.addElement(f);
        }
        k = this.fView.selectionElements();
        while (k.hasMoreElements()) {
            this.fView.drawing().remove(k.nextFigure());
        }
        this.fView.clearSelection();
    }

    protected void insertFigures(Vector figures, int dx, int dy) {
        Vector<CommentTextFigure> dontMoveVector = new Vector<CommentTextFigure>();
        int size = figures.size();
        for (int i = 0; i < size; ++i) {
            CommentTextFigure commentFigure;
            if (!(figures.elementAt(i) instanceof BlockFigure) || (commentFigure = ((BlockFigure)figures.elementAt(i)).getCommentFigure()) == null || !figures.contains(commentFigure)) continue;
            dontMoveVector.addElement(commentFigure);
        }
        SortedXDirectionEnumerator e = new SortedXDirectionEnumerator(figures, dx > 0);
        while (e.hasMoreElements()) {
            Figure figure = e.nextFigure();
            if (!dontMoveVector.contains(figure)) {
                figure.moveBy(dx, dy);
            }
            figure = this.fView.add(figure);
            this.fView.addToSelection(figure);
        }
    }
}

