/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ConnectionTool
extends AbstractTool {
    private Connector fStartConnector;
    private Connector fEndConnector;
    private Connector fConnectorTarget = null;
    private Figure fTarget = null;
    private ConnectionFigure fConnection;
    private int fSplitPoint;
    private ConnectionFigure fEditedConnection = null;
    private ConnectionFigure fPrototype;

    public ConnectionTool(ConnectionFigure prototype) {
        this.fPrototype = prototype;
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected ConnectionFigure createdFigure() {
        return this.fConnection;
    }

    public void deactivate(DrawingView view) {
        super.deactivate(view);
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
        }
    }

    private Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = (Figure)k.nextElement();
            if ((figure = figure.findFigureInside(x, y)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected Figure findConnectionStart(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect()) {
            return target;
        }
        return null;
    }

    private Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    protected Figure findSource(int x, int y, Drawing drawing) {
        return this.findConnectableFigure(x, y, drawing);
    }

    protected Figure findTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        Figure start = this.fStartConnector.owner();
        if (target != null && this.fConnection != null && target.canConnect() && !target.includes(start) && this.fConnection.canConnect(start, target)) {
            return target;
        }
        return null;
    }

    protected Connector getEndConnector() {
        return this.fEndConnector;
    }

    protected Connector getStartConnector() {
        return this.fStartConnector;
    }

    protected Connector getTarget() {
        return this.fConnectorTarget;
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        int ex = e.getX();
        int ey = e.getY();
        this.fTarget = this.findConnectionStart(ex, ey, view.drawing());
        if (this.fTarget != null) {
            this.fStartConnector = this.findConnector(ex, ey, this.fTarget);
            if (this.fStartConnector != null) {
                Point p = new Point(ex, ey);
                this.fConnection = this.createConnection();
                this.fConnection.startPoint(p.x, p.y);
                this.fConnection.endPoint(p.x, p.y);
                view.add(this.fConnection);
            }
        } else {
            ConnectionFigure connection = this.findConnection(ex, ey, view.drawing());
            if (connection != null) {
                if (!connection.joinSegments(ex, ey)) {
                    this.fSplitPoint = connection.splitSegment(ex, ey);
                    this.fEditedConnection = connection;
                } else {
                    this.fEditedConnection = null;
                }
            }
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        Point p = new Point(e.getX(), e.getY());
        if (this.fConnection != null) {
            this.trackConnectors(e, x, y, view);
            if (this.fConnectorTarget != null) {
                p = Geom.center(this.fConnectorTarget.displayBox());
            }
            this.fConnection.endPoint(p.x, p.y);
        } else if (this.fEditedConnection != null) {
            Point pp = new Point(x, y);
            this.fEditedConnection.setPointAt(pp, this.fSplitPoint);
        }
    }

    public void mouseMove(MouseEvent e, int x, int y, DrawingView view) {
        this.trackConnectors(e, x, y, view);
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        Figure c = null;
        if (this.fStartConnector != null) {
            c = this.findTarget(e.getX(), e.getY(), view.drawing());
        }
        if (c != null) {
            this.fEndConnector = this.findConnector(e.getX(), e.getY(), c);
            if (this.fEndConnector != null) {
                this.fConnection.connectStart(this.fStartConnector);
                this.fConnection.connectEnd(this.fEndConnector);
                this.fConnection.updateConnection();
            }
        } else if (this.fConnection != null) {
            view.remove(this.fConnection);
        }
        this.fConnection = null;
        this.fEndConnector = null;
        this.fStartConnector = null;
        view.editor().toolDone();
    }

    protected void trackConnectors(MouseEvent e, int x, int y, DrawingView view) {
        Figure c = null;
        c = this.fStartConnector == null ? this.findSource(x, y, view.drawing()) : this.findTarget(x, y, view.drawing());
        if (c != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = c;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        Connector cc = null;
        if (c != null) {
            cc = this.findConnector(e.getX(), e.getY(), c);
        }
        if (cc != this.fConnectorTarget) {
            this.fConnectorTarget = cc;
        }
        view.checkDamage();
    }
}

