/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.event.MouseEvent;

public class ScribbleTool
extends AbstractTool {
    private PolyLineFigure fScribble;
    private int fLastX;
    private int fLastY;

    public void activate(DrawingView view) {
        super.activate(view);
        this.fScribble = null;
    }

    public void deactivate(DrawingView view) {
        super.deactivate(view);
        if (this.fScribble != null && (this.fScribble.size().width < 4 || this.fScribble.size().height < 4)) {
            view.drawing().remove(this.fScribble);
        }
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        if (e.getClickCount() >= 2) {
            this.fScribble = null;
            view.editor().toolDone();
        } else {
            this.point(e.getX(), e.getY(), view);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        if (this.fScribble != null) {
            this.point(e.getX(), e.getY(), view);
        }
    }

    private void point(int x, int y, DrawingView view) {
        if (this.fScribble == null) {
            this.fScribble = new PolyLineFigure(x, y);
            view.add(this.fScribble);
        } else if (this.fLastX != x || this.fLastY != y) {
            this.fScribble.addPoint(x, y);
        }
        this.fLastX = x;
        this.fLastY = y;
    }
}

