/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.tomcat.util.MutableInteger;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SecureNioChannel;

public class NioChannel
implements ByteChannel {
    protected static ByteBuffer emptyBuf = ByteBuffer.allocate(0);
    protected SocketChannel sc = null;
    protected SecureNioChannel.ApplicationBufferHandler bufHandler;
    protected NioEndpoint.Poller poller;
    protected boolean sendFile = false;

    public NioChannel(SocketChannel channel, SecureNioChannel.ApplicationBufferHandler bufHandler) throws IOException {
        this.sc = channel;
        this.bufHandler = bufHandler;
    }

    public void reset() throws IOException {
        this.bufHandler.getReadBuffer().clear();
        this.bufHandler.getWriteBuffer().clear();
        this.sendFile = false;
    }

    public int getBufferSize() {
        if (this.bufHandler == null) {
            return 0;
        }
        int size = 0;
        size += this.bufHandler.getReadBuffer() != null ? this.bufHandler.getReadBuffer().capacity() : 0;
        return size += this.bufHandler.getWriteBuffer() != null ? this.bufHandler.getWriteBuffer().capacity() : 0;
    }

    public boolean flush(boolean block, Selector s, long timeout, MutableInteger lastWrite) throws IOException {
        if (lastWrite != null) {
            lastWrite.set(1);
        }
        return true;
    }

    public void close() throws IOException {
        this.getIOChannel().socket().close();
        this.getIOChannel().close();
    }

    public void close(boolean force) throws IOException {
        if (this.isOpen() || force) {
            this.close();
        }
    }

    public boolean isOpen() {
        return this.sc.isOpen();
    }

    public int write(ByteBuffer src) throws IOException {
        return this.sc.write(src);
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.sc.read(dst);
    }

    public Object getAttachment(boolean remove) {
        Object att;
        NioEndpoint.Poller pol = this.getPoller();
        Selector sel = pol != null ? pol.getSelector() : null;
        SelectionKey key = sel != null ? this.getIOChannel().keyFor(sel) : null;
        Object object = att = key != null ? key.attachment() : null;
        if (key != null && att != null && remove) {
            key.attach(null);
        }
        return att;
    }

    public SecureNioChannel.ApplicationBufferHandler getBufHandler() {
        return this.bufHandler;
    }

    public NioEndpoint.Poller getPoller() {
        return this.poller;
    }

    public SocketChannel getIOChannel() {
        return this.sc;
    }

    public boolean isClosing() {
        return false;
    }

    public boolean isInitHandshakeComplete() {
        return true;
    }

    public int handshake(boolean read, boolean write) throws IOException {
        return 0;
    }

    public void setPoller(NioEndpoint.Poller poller) {
        this.poller = poller;
    }

    public void setIOChannel(SocketChannel IOChannel) {
        this.sc = IOChannel;
    }

    public String toString() {
        return super.toString() + ":" + this.sc.toString();
    }

    public int getOutboundRemaining() {
        return 0;
    }

    public boolean flushOutbound() throws IOException {
        return false;
    }

    public boolean isSendFile() {
        return this.sendFile;
    }

    public void setSendFile(boolean s) {
        this.sendFile = s;
    }
}

