
for (var i = 0; i <= 1; i++) {
	(function(index) {
		T.dom("#login_tab_" + i).on("click", function(e) {
			var target = T.dom(this);

			T.dom(".login_tab li").attr("class","");
			T.dom(".login_form").css("display","none");

			target.attr("class","curr");
			T.dom(".login_form").eq(index).css("display","block");
			
		});
	})(i)
	T.dom("#login_tab_" + i).on("mouseover", function() {
		if (this.className == "") {
			this.className = "hover";
		}
	});
	T.dom("#login_tab_" + i).on("mouseout", function() {
		if (this.className == "hover") {
			this.className = "";
		}
	});
}

var Log=(function(){
	if (T.browser.isWebkit){
		return function(msg){
			console.log(msg)
		}
	}else if (baidu.browser.ie){
		return function(msg){
			alert(msg)
		}
	}

}());



T.dom(".input_text").on("focus",function(e){
	var target = T.dom(e.target);
	var targetLabel = target.siblings(".label_input_text_inner");
	target.addClass("focus");
	targetLabel.hide();
});

T.dom(".input_text").on("blur",function(e){
	var target = T.dom(e.target);
	var targetLabel = target.siblings(".label_input_text_inner");
	target.removeClass("focus");
	if (target.val() == ""){
		targetLabel.show();
	}
});

T.dom(".input_text").on("keypress",function(e){
	if (e.keyCode == 13){
		toLogin(this)
	}
});

function toLogin(triggerTarget){
	var triggerTargetDom = T.dom(triggerTarget),
		formDom = T.dom(T.dom(triggerTargetDom.parent())).parent(),
		errDom = T.dom(formDom.siblings(".err_holder")),
		nameInputDom = T.dom(formDom.find(".name_wrapper input")),
		passInputDom = T.dom(formDom.find(".password_wrapper input")),
		verifyWrapperDom = T.dom(formDom.find(".verifycode_wrapper")),
		verifyInputDom = T.dom(formDom.find(".verifycode_wrapper input")),
		verifyImgDom = T.dom(formDom.find(".verifycode_wrapper img")),
		logInfo = {};

	logInfo.isPhone = nameInputDom.hasClass("input_phonenumber");
	logInfo.name =baidu.string(nameInputDom.val()).trim();
	logInfo.password = passInputDom.val();
	if (verifyWrapperDom.css("display") !== "none"){
		logInfo.vcodestr = verifyInputDom.val();
		logInfo.vcodeurl=getImgUrl(verifyImgDom.attr("src"));
	}

	logInfo.cmd = "SetUserLoginInfo";

	if (logInfo.name == ""){
		errDom.text((logInfo.isPhone?"手机号":"用户名")+"为空，请输入"+(logInfo.isPhone?"手机号！":"用户名！"));
		//triggerTargetDom.removeClass("disabled");
		triggerTargetDom.removeClass("login_btn_disabled");
		return;
	} else if (logInfo.password == ""){
		errDom.text("密码为空，请输入密码！");
		//triggerTargetDom.removeClass("disabled");
		triggerTargetDom.removeClass("login_btn_disabled");
		return;
	} else if (logInfo.vcodestr!= undefined && logInfo.vcodestr == ""){
		errDom.text("验证码为空，请输入验证码！");
		//triggerTargetDom.removeClass("disabled");
		triggerTargetDom.removeClass("login_btn_disabled");
		return;
	}
	
	window.onCMDCallBack = function(rs){
		//Log(rs)
		var rs = T.json.parse(rs);
		
		switch (rs.cmd){
			case "OnLoginVerify":{
				//Log("verify")
				//if (rs.uname == logInfo.name){
					verifyWrapperDom.show();
					verifyImgDom.attr("src",rs.vcodeUrl);
					nameInputDom.removeAttr("disabled");
					passInputDom.removeAttr("disabled");
					verifyWrapperDom.removeAttr("disabled");
					if (triggerTargetDom.hasClass('login_btn')){
						triggerTargetDom.removeClass("login_btn_disabled")
					}
				//}
			}
			break;
			case "OnLoginError":{
				//Log("login err")
				errDom.text(rs.errstr)
				nameInputDom.removeAttr("disabled");
				passInputDom.removeAttr("disabled");
				verifyWrapperDom.removeAttr("disabled");
				if (triggerTargetDom.hasClass('login_btn')){
					triggerTargetDom.removeClass("login_btn_disabled")
				}
			}
			break;
			default:{
				return;
			}
		}
		
	}

	nameInputDom.attr("disabled","disabled");
	passInputDom.attr("disabled","disabled");
	(verifyWrapperDom.css("display") !== "none")&&verifyWrapperDom.attr("disabled","disabled");
	//Log(T.json.stringify(logInfo))
	window.external.bpls_set_json_cmd(T.json.stringify(logInfo));
}

T.dom(".login_btn").on("click",function(e){
	var loginBtnDom = T.dom(e.target);

	if (loginBtnDom.hasClass("login_btn_disabled")){
		return;
	}


	loginBtnDom.addClass("login_btn_disabled");
	toLogin(this)
	
})

T.dom(".big_btn").on("mouseover",function(e){
	
	var btnDom = T.dom(e.target);
	if (btnDom.hasClass("login_btn_hover")){
		return;
	}

	if (btnDom.hasClass("login_btn")){
		btnDom.addClass("login_btn_hover");
	}else{
		btnDom.addClass("regist_btn_hover");
	}
	//Log(btnDom.attr("class"))
})

T.dom(".big_btn").on("mouseout",function(e){
	var btnDom = T.dom(e.target);

	if (btnDom.hasClass("login_btn")){
		btnDom.removeClass("login_btn_hover");
	}else{
		btnDom.removeClass("regist_btn_hover");
	}
})

T.dom(".regist_btn").on("click",function(e){
	window.external.bpls_normalCall('CMD_OPENURLINEXPLORER', "https://passport.baidu.com/v2/?reg&regType=1&tpl=player", '');
})

T.dom(".forget_password").on("click",function(){
	window.external.bpls_normalCall('CMD_OPENURLINEXPLORER', "https://passport.baidu.com/?getpass_index", '');
})

T.dom(".change_verifycode").on("click",function(){
	var imgDom = T.dom(this).siblings(".verifycode_img");
	var inputDom = T.dom(this).siblings(".input_verifycode");

	var imgSrc = getImgUrl(imgDom.attr("src"));
	
	
	//Log(imgSrc)
	setTimeout(function(){
		imgDom.attr("src",imgSrc+"&t="+(new Date()).getTime());
	},0)
	
	//Log(imgDom.attr("src"))
})

function getImgUrl(url){
	var index = url.indexOf("&");

	if (index >= 0){
		url = url.substr(0,index);
	}

	return url;
}

