/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.converter.IR2JConverter;
import com.googlecode.d2j.converter.J2IRConverter;
import com.googlecode.d2j.util.Escape;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.StmtTraveler;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.FilledArrayExpr;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.ts.AggTransformer;
import com.googlecode.dex2jar.ir.ts.CleanLabel;
import com.googlecode.dex2jar.ir.ts.DeadCodeTransformer;
import com.googlecode.dex2jar.ir.ts.ExceptionHandlerTrim;
import com.googlecode.dex2jar.ir.ts.Ir2JRegAssignTransformer;
import com.googlecode.dex2jar.ir.ts.NewTransformer;
import com.googlecode.dex2jar.ir.ts.NpeTransformer;
import com.googlecode.dex2jar.ir.ts.RemoveConstantFromSSA;
import com.googlecode.dex2jar.ir.ts.RemoveLocalFromSSA;
import com.googlecode.dex2jar.ir.ts.TypeTransformer;
import com.googlecode.dex2jar.ir.ts.UnSSATransformer;
import com.googlecode.dex2jar.ir.ts.VoidInvokeTransformer;
import com.googlecode.dex2jar.ir.ts.ZeroTransformer;
import com.googlecode.dex2jar.ir.ts.array.FillArrayTransformer;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@BaseCmd.Syntax(cmd="d2j-decrypt-string", syntax="[options] <jar>", desc="Decrypt in class file", onlineHelp="https://sourceforge.net/p/dex2jar/wiki/DecryptStrings\nhttps://bitbucket.org/pxb1988/dex2jar/wiki/DecryptStrings")
public class DecryptStringCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output of .jar files, default is $current_dir/[jar-name]-decrypted.jar", argName="out")
    private Path output;
    @BaseCmd.Opt(opt="m", longOpt="methods", description="a file contain a list of methods, each line like: La/b;->decrypt(III)Ljava/lang/String;", argName="cfg")
    private Path method;
    @BaseCmd.Opt(opt="mo", longOpt="decrypt-method-owner", description="the owner of the method which can decrypt the stings, example: java.lang.String", argName="owner")
    private String methodOwner;
    @BaseCmd.Opt(opt="mn", longOpt="decrypt-method-name", description="the owner of the method which can decrypt the stings, the method's signature must be static (parameter-type)Ljava/lang/String;. Please use -pt,--parameter-type to set the argument descrypt.", argName="name")
    private String methodName;
    @BaseCmd.Opt(opt="cp", longOpt="classpath", description="add extra lib to classpath", argName="cp")
    private String classpath;
    @BaseCmd.Opt(opt="t", longOpt="arg-types", description="comma-separated list of types:boolean,byte,short,char,int,long,float,double,string. Default is string", argName="type")
    private String parameterJTypes;
    @BaseCmd.Opt(opt="pd", longOpt="parameters-descriptor", description="the descriptor for the method which can decrypt the stings, example1: Ljava/lang/String; example2: III, default is Ljava/lang/String;", argName="type")
    private String parametersDescriptor;
    @BaseCmd.Opt(opt="d", longOpt="delete", hasArg=false, description="delete the method which can decrypt the stings")
    private boolean deleteMethod = false;
    @BaseCmd.Opt(opt="da", longOpt="deep-analyze", hasArg=false, description="use dex2jar IR to static analyze and find more values like byte[]")
    private boolean deepAnalyze = false;
    @BaseCmd.Opt(opt="v", longOpt="verbose", hasArg=false, description="show more on output")
    private boolean verbose = false;
    MethodConfig key = new MethodConfig();
    protected final CleanLabel T_cleanLabel = new CleanLabel();
    protected final Ir2JRegAssignTransformer T_ir2jRegAssign = new Ir2JRegAssignTransformer();
    protected final NewTransformer T_new = new NewTransformer();
    protected final RemoveConstantFromSSA T_removeConst = new RemoveConstantFromSSA();
    protected final RemoveLocalFromSSA T_removeLocal = new RemoveLocalFromSSA();
    protected final ExceptionHandlerTrim T_trimEx = new ExceptionHandlerTrim();
    protected final TypeTransformer T_type = new TypeTransformer();
    protected final DeadCodeTransformer T_deadCode = new DeadCodeTransformer();
    protected final FillArrayTransformer T_fillArray = new FillArrayTransformer();
    protected final AggTransformer T_agg = new AggTransformer();
    protected final UnSSATransformer T_unssa = new UnSSATransformer();
    protected final ZeroTransformer T_zero = new ZeroTransformer();
    protected final VoidInvokeTransformer T_voidInvoke = new VoidInvokeTransformer();
    protected final NpeTransformer T_npe = new NpeTransformer();

    public static void main(String ... args) {
        new DecryptStringCmd().doMain(args);
    }

    MethodConfig build(String line) {
        int idx2;
        int idx = line.indexOf("->");
        if (idx < 0) {
            throw new RuntimeException("Can't read line:" + line);
        }
        String owner = line.substring(0, idx);
        if (owner.startsWith("L") && owner.endsWith(";")) {
            owner = owner.substring(1, owner.length() - 1);
        }
        if ((idx2 = line.indexOf(40, idx)) < 0) {
            throw new RuntimeException("Can't read line:" + line);
        }
        String name = line.substring(idx + 2, idx2);
        String desc = line.substring(idx2);
        if (desc.endsWith(")")) {
            desc = desc + "Ljava/lang/String;";
        }
        MethodConfig config = new MethodConfig();
        config.owner = owner;
        config.desc = desc;
        config.name = name;
        return config;
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length == 0) {
            throw new BaseCmd.HelpException("One <jar> file is required");
        }
        if (this.remainingArgs.length > 1) {
            throw new BaseCmd.HelpException("Only one <jar> file is required, But we found " + this.remainingArgs.length);
        }
        Path jar = new File(this.remainingArgs[0]).toPath();
        if (!Files.exists(jar, new LinkOption[0])) {
            System.err.println(jar + " is not exists");
            return;
        }
        if (this.output == null) {
            this.output = Files.isDirectory(jar, new LinkOption[0]) ? new File(jar.getFileName() + "-decrypted.jar").toPath() : new File(DecryptStringCmd.getBaseName((String)jar.getFileName().toString()) + "-decrypted.jar").toPath();
        }
        if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            return;
        }
        System.err.println(jar + " -> " + this.output);
        List<MethodConfig> methodConfigs = this.collectMethodConfigs();
        if (methodConfigs == null || methodConfigs.size() == 0) {
            System.err.println("No method selected !");
            return;
        }
        final Map<MethodConfig, MethodConfig> map = this.loadMethods(jar, methodConfigs);
        try (FileSystem outputFileSystem = DecryptStringCmd.createZip((Path)this.output);){
            final Path outputBase = outputFileSystem.getPath("/", new String[0]);
            DecryptStringCmd.walkJarOrDir((Path)jar, (BaseCmd.FileVisitorX)new BaseCmd.FileVisitorX(){

                public void visitFile(Path file, String relative) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        Path dist1 = outputBase.resolve(relative);
                        BaseCmd.createParentDirectories((Path)dist1);
                        byte[] data = Files.readAllBytes(file);
                        ClassNode cn = DecryptStringCmd.this.readClassNode(data);
                        if (DecryptStringCmd.this.decrypt(cn, map)) {
                            byte[] data2 = DecryptStringCmd.this.toByteArray(cn);
                            Files.write(dist1, data2, new OpenOption[0]);
                        } else {
                            Files.write(dist1, data, new OpenOption[0]);
                        }
                    } else {
                        Path dist1 = outputBase.resolve(relative);
                        BaseCmd.createParentDirectories((Path)dist1);
                        Files.copy(file, dist1, new CopyOption[0]);
                    }
                }
            });
        }
    }

    private byte[] toByteArray(ClassNode cn) {
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private ClassNode readClassNode(byte[] data) {
        ClassReader cr = new ClassReader(data);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 12);
        return cn;
    }

    private boolean decrypt(ClassNode cn, Map<MethodConfig, MethodConfig> map) {
        if (this.deepAnalyze) {
            return this.decryptByIr(cn, map);
        }
        return this.decryptByStack(cn, map);
    }

    private boolean decryptByIr(ClassNode cn, Map<MethodConfig, MethodConfig> map) {
        MethodConfig key = this.key;
        boolean changed = false;
        Iterator it = cn.methods.iterator();
        while (it.hasNext()) {
            MethodNode m = (MethodNode)it.next();
            if (m.instructions == null) continue;
            key.owner = cn.name;
            key.name = m.name;
            key.desc = m.desc;
            if (map.containsKey(key)) {
                if (!this.deleteMethod) continue;
                it.remove();
                continue;
            }
            boolean find = false;
            for (AbstractInsnNode p = m.instructions.getFirst(); p != null; p = p.getNext()) {
                if (p.getOpcode() != 184) continue;
                MethodInsnNode mn = (MethodInsnNode)p;
                key.owner = mn.owner;
                key.name = mn.name;
                key.desc = mn.desc;
                MethodConfig config = map.get(key);
                if (config == null) continue;
                find = true;
            }
            if (!find) continue;
            try {
                MethodNode m2 = new MethodNode();
                m2.tryCatchBlocks = new ArrayList();
                m2.name = m.name;
                m2.access = m.access;
                m2.desc = m.desc;
                m.accept((MethodVisitor)m2);
                this.cleanDebug(m2);
                IrMethod irMethod = J2IRConverter.convert((String)cn.name, (MethodNode)m2);
                this.optAndDecrypt(irMethod, map);
                MethodNode m3 = new MethodNode();
                m3.tryCatchBlocks = new ArrayList();
                new IR2JConverter(true).convert(irMethod, (MethodVisitor)m3);
                m.maxLocals = -1;
                m.maxLocals = -1;
                m.instructions = m3.instructions;
                m.tryCatchBlocks = m3.tryCatchBlocks;
                m.localVariables = null;
                changed = true;
            }
            catch (Exception ex) {
                if (!this.verbose) continue;
                ex.printStackTrace();
            }
        }
        return changed;
    }

    private boolean decryptByStack(ClassNode cn, Map<MethodConfig, MethodConfig> map) {
        MethodConfig key = this.key;
        boolean changed = false;
        Iterator it = cn.methods.iterator();
        while (it.hasNext()) {
            MethodNode m = (MethodNode)it.next();
            if (m.instructions == null) continue;
            key.owner = cn.name;
            key.name = m.name;
            key.desc = m.desc;
            if (map.containsKey(key)) {
                if (!this.deleteMethod) continue;
                it.remove();
                continue;
            }
            for (AbstractInsnNode p = m.instructions.getFirst(); p != null; p = p.getNext()) {
                if (p.getOpcode() != 184) continue;
                MethodInsnNode mn = (MethodInsnNode)p;
                key.owner = mn.owner;
                key.name = mn.name;
                key.desc = mn.desc;
                MethodConfig config = map.get(key);
                if (config == null) continue;
                Method jmethod = config.jmethod;
                try {
                    int pSize = jmethod.getParameterTypes().length;
                    Object[] as = this.readArgumentValues(mn, jmethod, pSize);
                    if (this.verbose) {
                        System.out.println(" > calling " + jmethod + " with arguments " + DecryptStringCmd.v(as));
                    }
                    String newValue = (String)jmethod.invoke(null, as);
                    if (this.verbose) {
                        System.out.println("  -> " + Escape.v((String)newValue));
                    }
                    LdcInsnNode nLdc = new LdcInsnNode((Object)newValue);
                    m.instructions.insert((AbstractInsnNode)mn, (AbstractInsnNode)nLdc);
                    this.removeInsts(m, mn, pSize);
                    p = nLdc;
                    changed = true;
                    continue;
                }
                catch (InvocationTargetException ex) {
                    if (!this.verbose) continue;
                    ex.getTargetException().printStackTrace();
                    continue;
                }
                catch (Exception ex) {
                    if (!this.verbose) continue;
                    ex.printStackTrace();
                }
            }
        }
        return changed;
    }

    public void optAndDecrypt(IrMethod irMethod, final Map<MethodConfig, MethodConfig> map) {
        this.T_deadCode.transform(irMethod);
        this.T_cleanLabel.transform(irMethod);
        this.T_removeLocal.transform(irMethod);
        this.T_removeConst.transform(irMethod);
        this.T_zero.transform(irMethod);
        if (this.T_npe.transformReportChanged(irMethod)) {
            this.T_deadCode.transform(irMethod);
            this.T_removeLocal.transform(irMethod);
            this.T_removeConst.transform(irMethod);
        }
        this.T_new.transform(irMethod);
        this.T_fillArray.transform(irMethod);
        this.T_agg.transform(irMethod);
        this.T_voidInvoke.transform(irMethod);
        new StmtTraveler(){

            public Value travel(Value op) {
                op = super.travel(op);
                if (op.vt == Value.VT.INVOKE_STATIC) {
                    InvokeExpr ie = (InvokeExpr)op;
                    MethodConfig key = DecryptStringCmd.this.key;
                    key.owner = ie.owner.substring(1, ie.owner.length() - 1);
                    key.name = ie.name;
                    key.desc = DecryptStringCmd.this.buildMethodDesc(ie.args, ie.ret);
                    MethodConfig c = (MethodConfig)map.get(key);
                    if (c != null) {
                        try {
                            Method jmethod = c.jmethod;
                            if (ie.args.length != jmethod.getParameterTypes().length) {
                                throw new RuntimeException();
                            }
                            Object[] args = new Object[ie.args.length];
                            for (int i = 0; i < args.length; ++i) {
                                args[i] = DecryptStringCmd.this.convertIr2Jobj(ie.getOps()[i], ie.args[i]);
                            }
                            if (DecryptStringCmd.this.verbose) {
                                System.out.println(" > calling " + jmethod + " with arguments " + DecryptStringCmd.v(args));
                            }
                            String str = (String)jmethod.invoke(null, args);
                            if (DecryptStringCmd.this.verbose) {
                                System.out.println("  -> " + Escape.v((String)str));
                            }
                            return Exprs.nString((String)str);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                return op;
            }
        }.travel(irMethod.stmts);
        this.T_type.transform(irMethod);
        this.T_unssa.transform(irMethod);
        this.T_trimEx.transform(irMethod);
        this.T_ir2jRegAssign.transform(irMethod);
    }

    public static String v(Object[] vs) {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (Object obj : vs) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (obj instanceof String) {
                sb.append(Escape.v((Object)obj));
                continue;
            }
            sb.append(obj);
        }
        return sb.append("]").toString();
    }

    private Object convertIr2Jobj(Value value, String type) {
        if (value instanceof Constant && Constant.Null.equals(((Constant)value).value)) {
            return null;
        }
        switch (type) {
            case "Z": {
                Object obj = ((Constant)value).value;
                return obj instanceof Boolean ? obj : Boolean.valueOf(((Number)obj).intValue() != 0);
            }
            case "B": {
                Object obj = ((Constant)value).value;
                return ((Number)obj).byteValue();
            }
            case "S": {
                Object obj = ((Constant)value).value;
                return ((Number)obj).shortValue();
            }
            case "C": {
                Object obj = ((Constant)value).value;
                return obj instanceof Character ? obj : Character.valueOf((char)((Number)obj).intValue());
            }
            case "I": {
                Object obj = ((Constant)value).value;
                return ((Number)obj).intValue();
            }
            case "J": {
                Object obj = ((Constant)value).value;
                return ((Number)obj).longValue();
            }
            case "F": {
                Object obj = ((Constant)value).value;
                return obj instanceof Float ? obj : Float.valueOf(Float.intBitsToFloat(((Number)obj).intValue()));
            }
            case "D": {
                Object obj = ((Constant)value).value;
                return obj instanceof Double ? obj : Double.valueOf(Double.longBitsToDouble(((Number)obj).longValue()));
            }
            case "Ljava/lang/String;": {
                return (String)((Constant)value).value;
            }
            case "[Z": {
                if (value instanceof Constant) {
                    Object obj = ((Constant)value).value;
                    if (obj instanceof boolean[]) {
                        return obj;
                    }
                    boolean[] b = new boolean[Array.getLength(obj)];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = ((Number)Array.get(obj, i)).intValue() != 0;
                    }
                    return b;
                }
                if (value instanceof FilledArrayExpr) {
                    boolean[] b = new boolean[value.getOps().length];
                    for (int i = 0; i < b.length; ++i) {
                        Object obj = ((Constant)value.getOps()[i]).value;
                        b[i] = obj instanceof Boolean ? (Boolean)obj : ((Number)obj).intValue() != 0;
                    }
                    return b;
                }
                throw new RuntimeException();
            }
            case "[B": {
                if (value instanceof Constant) {
                    Object obj = ((Constant)value).value;
                    if (obj instanceof byte[]) {
                        return obj;
                    }
                    byte[] b = new byte[Array.getLength(obj)];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = ((Number)Array.get(obj, i)).byteValue();
                    }
                    return b;
                }
                if (value instanceof FilledArrayExpr) {
                    byte[] b = new byte[value.getOps().length];
                    for (int i = 0; i < b.length; ++i) {
                        Object obj = ((Constant)value.getOps()[i]).value;
                        b[i] = ((Number)obj).byteValue();
                    }
                    return b;
                }
                throw new RuntimeException();
            }
            case "[S": {
                if (value instanceof Constant) {
                    Object obj = ((Constant)value).value;
                    if (obj instanceof short[]) {
                        return obj;
                    }
                    short[] b = new short[Array.getLength(obj)];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = ((Number)Array.get(obj, i)).shortValue();
                    }
                    return b;
                }
                if (value instanceof FilledArrayExpr) {
                    short[] b = new short[value.getOps().length];
                    for (int i = 0; i < b.length; ++i) {
                        Object obj = ((Constant)value.getOps()[i]).value;
                        b[i] = ((Number)obj).shortValue();
                    }
                    return b;
                }
                throw new RuntimeException();
            }
            case "[C": {
                if (value instanceof Constant) {
                    Object obj = ((Constant)value).value;
                    if (obj instanceof char[]) {
                        return obj;
                    }
                    char[] b = new char[Array.getLength(obj)];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = (char)((Number)Array.get(obj, i)).intValue();
                    }
                    return b;
                }
                if (value instanceof FilledArrayExpr) {
                    char[] b = new char[value.getOps().length];
                    for (int i = 0; i < b.length; ++i) {
                        Object obj = ((Constant)value.getOps()[i]).value;
                        b[i] = obj instanceof Character ? ((Character)obj).charValue() : (char)((Number)obj).intValue();
                    }
                    return b;
                }
                throw new RuntimeException();
            }
            case "[I": {
                if (value instanceof Constant) {
                    Object obj = ((Constant)value).value;
                    if (obj instanceof int[]) {
                        return obj;
                    }
                    int[] b = new int[Array.getLength(obj)];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = ((Number)Array.get(obj, i)).intValue();
                    }
                    return b;
                }
                if (value instanceof FilledArrayExpr) {
                    int[] b = new int[value.getOps().length];
                    for (int i = 0; i < b.length; ++i) {
                        Object obj = ((Constant)value.getOps()[i]).value;
                        b[i] = ((Number)obj).intValue();
                    }
                    return b;
                }
                throw new RuntimeException();
            }
            case "[J": {
                if (value instanceof Constant) {
                    Object obj = ((Constant)value).value;
                    if (obj instanceof long[]) {
                        return obj;
                    }
                    long[] b = new long[Array.getLength(obj)];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = ((Number)Array.get(obj, i)).longValue();
                    }
                    return b;
                }
                if (value instanceof FilledArrayExpr) {
                    long[] b = new long[value.getOps().length];
                    for (int i = 0; i < b.length; ++i) {
                        Object obj = ((Constant)value.getOps()[i]).value;
                        b[i] = ((Number)obj).longValue();
                    }
                    return b;
                }
                throw new RuntimeException();
            }
            case "[F": {
                if (value instanceof Constant) {
                    Object obj = ((Constant)value).value;
                    if (obj instanceof float[]) {
                        return obj;
                    }
                    float[] b = new float[Array.getLength(obj)];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = (char)((Number)Array.get(obj, i)).intValue();
                    }
                    return b;
                }
                if (value instanceof FilledArrayExpr) {
                    float[] b = new float[value.getOps().length];
                    for (int i = 0; i < b.length; ++i) {
                        Object obj = ((Constant)value.getOps()[i]).value;
                        b[i] = obj instanceof Float ? ((Float)obj).floatValue() : Float.intBitsToFloat(((Number)obj).intValue());
                    }
                    return b;
                }
                throw new RuntimeException();
            }
            case "[D": {
                if (value instanceof Constant) {
                    Object obj = ((Constant)value).value;
                    if (obj instanceof double[]) {
                        return obj;
                    }
                    double[] b = new double[Array.getLength(obj)];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = (char)((Number)Array.get(obj, i)).intValue();
                    }
                    return b;
                }
                if (value instanceof FilledArrayExpr) {
                    double[] b = new double[value.getOps().length];
                    for (int i = 0; i < b.length; ++i) {
                        Object obj = ((Constant)value.getOps()[i]).value;
                        b[i] = obj instanceof Double ? (Double)obj : Double.longBitsToDouble(((Number)obj).longValue());
                    }
                    return b;
                }
                throw new RuntimeException();
            }
            case "[Ljava/lang/String;": {
                if (value instanceof Constant) {
                    Object obj = ((Constant)value).value;
                    if (obj instanceof String[]) {
                        return obj;
                    }
                } else if (value instanceof FilledArrayExpr) {
                    String[] b = new String[value.getOps().length];
                    for (int i = 0; i < b.length; ++i) {
                        Object obj = ((Constant)value.getOps()[i]).value;
                        if (obj instanceof String) {
                            b[i] = (String)obj;
                            continue;
                        }
                        if (Constant.Null.equals(obj)) {
                            b[i] = null;
                            continue;
                        }
                        throw new RuntimeException();
                    }
                    return b;
                }
                throw new RuntimeException();
            }
        }
        throw new RuntimeException();
    }

    private String buildMethodDesc(String[] args, String ret) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (String s : args) {
            sb.append(s);
        }
        return sb.append(')').append(ret).toString();
    }

    private void cleanDebug(MethodNode mn) {
        AbstractInsnNode p = mn.instructions.getFirst();
        while (p != null) {
            if (p.getType() == 15) {
                AbstractInsnNode q = p.getNext();
                mn.instructions.remove(p);
                p = q;
                continue;
            }
            p = p.getNext();
        }
        mn.localVariables = null;
    }

    void removeInsts(MethodNode m, MethodInsnNode mn, int pSize) {
        for (int i = 0; i < pSize; ++i) {
            m.instructions.remove(mn.getPrevious());
        }
        m.instructions.remove((AbstractInsnNode)mn);
    }

    Object[] readArgumentValues(MethodInsnNode mn, Method jmethod, int pSize) {
        MethodInsnNode q = mn;
        Object[] as = new Object[pSize];
        for (int i = pSize - 1; i >= 0; --i) {
            q = q.getPrevious();
            Object object = this.readCst((AbstractInsnNode)q);
            as[i] = this.convert(object, jmethod.getParameterTypes()[i]);
        }
        return as;
    }

    Object convert(Object object, Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return ((Number)object).intValue();
        }
        if (Byte.TYPE.equals(type)) {
            return ((Number)object).byteValue();
        }
        if (Short.TYPE.equals(type)) {
            return ((Number)object).shortValue();
        }
        if (Character.TYPE.equals(type)) {
            return Character.valueOf((char)((Number)object).intValue());
        }
        if (Boolean.TYPE.equals(type)) {
            return (char)((Number)object).intValue() != '\u0000';
        }
        if (Long.TYPE.equals(type)) {
            return Character.valueOf((char)((Number)object).longValue());
        }
        if (Float.TYPE.equals(type)) {
            return Character.valueOf((char)((Number)object).floatValue());
        }
        if (Double.TYPE.equals(type)) {
            return Character.valueOf((char)((Number)object).doubleValue());
        }
        return object;
    }

    private Map<MethodConfig, MethodConfig> loadMethods(Path jar, List<MethodConfig> methodConfigs) throws Exception {
        HashMap<MethodConfig, MethodConfig> map = new HashMap<MethodConfig, MethodConfig>();
        ArrayList<String> list = new ArrayList<String>();
        if (this.classpath != null) {
            list.addAll(Arrays.asList(this.classpath.split(";|:")));
        }
        list.add(jar.toAbsolutePath().toString());
        URL[] urls = new URL[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            urls[i] = new File((String)list.get(i)).toURI().toURL();
        }
        URLClassLoader cl = new URLClassLoader(urls);
        for (MethodConfig config : methodConfigs) {
            Method jmethod;
            try {
                Class<?> clz = cl.loadClass(config.owner.replace('/', '.'));
                if (clz == null) {
                    System.err.println("clz is null:" + config.owner);
                }
                jmethod = this.findAnyMethodMatch(clz, config.name, this.toJavaType(Type.getArgumentTypes((String)config.desc)));
            }
            catch (Exception ex) {
                System.err.println("can't load method: L" + config.owner + ";->" + config.name + config.desc);
                throw ex;
            }
            if (jmethod != null) {
                jmethod.setAccessible(true);
                config.jmethod = jmethod;
                map.put(config, config);
                continue;
            }
            throw new NoSuchMethodException("can't find method " + config.name + config.desc + " on class " + config.owner + " or its parent");
        }
        return map;
    }

    private List<MethodConfig> collectMethodConfigs() throws IOException {
        ArrayList<MethodConfig> methodConfigs = new ArrayList<MethodConfig>();
        if (this.method != null) {
            for (String line : Files.readAllLines(this.method, StandardCharsets.UTF_8)) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                methodConfigs.add(this.build(line));
            }
        }
        if (this.methodOwner != null && this.methodName != null) {
            if (this.parametersDescriptor != null) {
                methodConfigs.add(this.build("L" + this.methodOwner.replace('.', '/') + ";->" + this.methodName + "(" + this.parametersDescriptor + ")Ljava/lang/String;"));
            } else if (this.parameterJTypes != null) {
                String[] type_list = this.parameterJTypes.split(",|;|:");
                StringBuilder sb = new StringBuilder();
                block23: for (int i = 0; i < type_list.length; ++i) {
                    switch (type_list[i]) {
                        case "boolean": {
                            sb.append("Z");
                            continue block23;
                        }
                        case "byte": {
                            sb.append("B");
                            continue block23;
                        }
                        case "short": {
                            sb.append("S");
                            continue block23;
                        }
                        case "char": {
                            sb.append("C");
                            continue block23;
                        }
                        case "int": {
                            sb.append("I");
                            continue block23;
                        }
                        case "long": {
                            sb.append("J");
                            continue block23;
                        }
                        case "float": {
                            sb.append("F");
                            continue block23;
                        }
                        case "double": {
                            sb.append("D");
                            continue block23;
                        }
                        case "string": {
                            sb.append("Ljava/lang/String;");
                            continue block23;
                        }
                        default: {
                            throw new RuntimeException("not support type " + type_list[i] + " on -t/--arg-types");
                        }
                    }
                }
                methodConfigs.add(this.build("L" + this.methodOwner.replace('.', '/') + ";->" + this.methodName + "(" + sb + ")Ljava/lang/String;"));
            } else {
                methodConfigs.add(this.build("L" + this.methodOwner.replace('.', '/') + ";->" + this.methodName + "(Ljava/lang/String;)Ljava/lang/String;"));
            }
        }
        return methodConfigs;
    }

    private Method findAnyMethodMatch(Class<?> clz, String name, Class<?>[] classes) {
        Method m;
        try {
            Method m2 = clz.getDeclaredMethod(name, classes);
            if (m2 != null) {
                return m2;
            }
        }
        catch (NoSuchMethodException m2) {
            // empty catch block
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != null && (m = this.findAnyMethodMatch(sup, name, classes)) != null) {
            return m;
        }
        Class<?>[] itfs = clz.getInterfaces();
        if (itfs != null && itfs.length > 0) {
            for (Class<?> itf : itfs) {
                Method m3 = this.findAnyMethodMatch(itf, name, classes);
                if (m3 == null) continue;
                return m3;
            }
        }
        return null;
    }

    Object readCst(AbstractInsnNode q) {
        switch (q.getOpcode()) {
            case 18: {
                LdcInsnNode ldc = (LdcInsnNode)q;
                if (ldc.cst instanceof Type) {
                    throw new RuntimeException("not support .class value yet!");
                }
                return ldc.cst;
            }
            case 16: 
            case 17: {
                IntInsnNode in = (IntInsnNode)q;
                return in.operand;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return q.getOpcode() - 3;
            }
            case 9: 
            case 10: {
                return (long)(q.getOpcode() - 9);
            }
            case 11: 
            case 12: 
            case 13: {
                return Float.valueOf(q.getOpcode() - 11);
            }
            case 14: 
            case 15: {
                return (double)(q.getOpcode() - 14);
            }
            case 1: {
                return null;
            }
        }
        throw new RuntimeException();
    }

    Class<?>[] toJavaType(Type[] pt) throws ClassNotFoundException {
        Class[] jt = new Class[pt.length];
        for (int i = 0; i < pt.length; ++i) {
            jt[i] = this.toJavaType(pt[i]);
        }
        return jt;
    }

    Class<?> toJavaType(Type t) throws ClassNotFoundException {
        switch (t.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 10: {
                return Class.forName(t.getClassName());
            }
            case 9: {
                return Class.forName(t.getDescriptor());
            }
            case 0: {
                return Void.TYPE;
            }
        }
        throw new RuntimeException();
    }

    static class MethodConfig {
        Method jmethod;
        String owner;
        String name;
        String desc;

        MethodConfig() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodConfig other = (MethodConfig)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
        }
    }
}

