/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.api.JavaClass;
import jadx.core.codegen.CodeWriter;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.BackgroundJob;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.CodeLinesInfo;
import jadx.gui.utils.CodeUsageInfo;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.Utils;
import jadx.gui.utils.search.StringRef;
import jadx.gui.utils.search.TextSearchIndex;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexJob
extends BackgroundJob {
    private static final Logger LOG = LoggerFactory.getLogger(IndexJob.class);
    private final CacheObject cache;
    private final boolean useFastSearch;

    public IndexJob(JadxWrapper wrapper, CacheObject cache, int threadsCount, boolean useFastSearch) {
        super(wrapper, threadsCount);
        this.useFastSearch = useFastSearch;
        this.cache = cache;
    }

    @Override
    protected void runJob() {
        JNodeCache nodeCache = this.cache.getNodeCache();
        final TextSearchIndex index = new TextSearchIndex(nodeCache, this.useFastSearch);
        final CodeUsageInfo usageInfo = new CodeUsageInfo(nodeCache);
        this.cache.setTextIndex(index);
        this.cache.setUsageInfo(usageInfo);
        for (final JavaClass cls : this.wrapper.getClasses()) {
            this.addTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        index.indexNames(cls);
                        CodeLinesInfo linesInfo = new CodeLinesInfo(cls);
                        List<StringRef> lines = IndexJob.this.splitLines(cls);
                        usageInfo.processClass(cls, linesInfo, lines);
                        if (Utils.isFreeMemoryAvailable()) {
                            index.indexCode(cls, linesInfo, lines);
                        } else {
                            index.classCodeIndexSkipped(cls);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Index error in class: {}", (Object)cls.getFullName(), (Object)e);
                    }
                }
            });
        }
    }

    @NotNull
    protected List<StringRef> splitLines(JavaClass cls) {
        List<StringRef> lines = StringRef.split(cls.getCode(), CodeWriter.NL);
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            lines.set(i, lines.get(i).trim());
        }
        return lines;
    }

    @Override
    public String getInfoString() {
        return "Indexing: ";
    }

    public boolean isUseFastSearch() {
        return this.useFastSearch;
    }
}

