/*
 * Decompiled with CFR 0.152.
 */
package pxb.java.nio.file.spi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import pxb.java.nio.file.FileSystem;
import pxb.java.nio.file.FileVisitor;
import pxb.java.nio.file.Path;

public abstract class FileSystemProvider {
    public static FileSystemProvider ZIP = new ZipFSP();
    public static FileSystemProvider DEF = new DirFSP();

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] xml = new byte[10240];
        int c = is.read(xml);
        while (c > 0) {
            os.write(xml, 0, c);
            c = is.read(xml);
        }
    }

    public static byte[] readFile(File in) throws IOException {
        FileInputStream is = new FileInputStream(in);
        byte[] xml = new byte[((InputStream)is).available()];
        ((InputStream)is).read(xml);
        ((InputStream)is).close();
        return xml;
    }

    public static byte[] readIs(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        FileSystemProvider.copy(is, os);
        return os.toByteArray();
    }

    public static void writeFile(byte[] data, File out) throws IOException {
        FileOutputStream fos = new FileOutputStream(out);
        fos.write(data);
        fos.close();
    }

    public static List<FileSystemProvider> installedProviders() {
        return Arrays.asList(ZIP, DEF);
    }

    public abstract String getScheme();

    public abstract FileSystem newFileSystem(Path var1, Map<String, ?> var2) throws IOException;

    static class DirFSP
    extends FileSystemProvider {
        DirFSP() {
        }

        @Override
        public String getScheme() {
            return "default";
        }

        @Override
        public FileSystem newFileSystem(Path path, Map<String, ?> env) {
            throw new RuntimeException();
        }
    }

    public static class DefPath
    implements Path {
        File file;
        String displayName;

        public DefPath(File file) {
            this.file = file;
        }

        public DefPath(File file, String name) {
            this.file = file;
            this.displayName = name;
        }

        @Override
        public String toString() {
            return this.displayName != null ? this.displayName : this.file.toString();
        }

        @Override
        public Path resolve(String other) {
            return new DefPath(new File(this.file, other));
        }

        @Override
        public Path getFileName() {
            return new DefPath(this.file, this.file.getName());
        }

        @Override
        public Path getParent() {
            return new DefPath(this.file.getParentFile());
        }

        @Override
        public File toFile() {
            return this.file;
        }

        @Override
        public byte[] _readAllBytes() throws IOException {
            return FileSystemProvider.readFile(this.file);
        }

        @Override
        public OutputStream _newOutputStream() throws FileNotFoundException {
            return new BufferedOutputStream(new FileOutputStream(this.file));
        }

        @Override
        public boolean _isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public Path _createDirectories() {
            this.file.mkdirs();
            return this;
        }

        @Override
        public boolean _deleteIfExists() {
            return this.file.exists() && this.file.delete();
        }

        @Override
        public boolean _exists() {
            return this.file.exists();
        }

        @Override
        public void _write(byte[] b) throws IOException {
            OutputStream os = this._newOutputStream();
            os.write(b);
            os.close();
        }

        @Override
        public void _walkFileTree(FileVisitor<? super Path> visitor) throws IOException {
            DefPath.walk0(this, visitor);
        }

        public static void walk0(DefPath dir, FileVisitor<? super Path> visitor) throws IOException {
            visitor.preVisitDirectory(dir, null);
            File[] fs = dir.file.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    if (f.isDirectory()) {
                        DefPath.walk0(new DefPath(f, null), visitor);
                        continue;
                    }
                    visitor.visitFile(new DefPath(f, null), null);
                }
            }
            visitor.postVisitDirectory(dir, null);
        }

        @Override
        public Path relativize(Path other) {
            DefPath p0 = (DefPath)other;
            String display = this.file.getAbsolutePath().substring(p0.file.getAbsolutePath().length());
            return new DefPath(p0.file, display);
        }

        @Override
        public InputStream _newInputStream() throws FileNotFoundException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
    }

    static class ZipFSP
    extends FileSystemProvider {
        ZipFSP() {
        }

        @Override
        public String getScheme() {
            return "zip";
        }

        @Override
        public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
            if (env != null && "true".equals(env.get("create"))) {
                return new CreatZipFS(new ZipOutputStream(path._newOutputStream()));
            }
            return new ReadZipFS(new ZipFile(((DefPath)path).file));
        }
    }

    static class ReadZipFS
    extends FileSystem {
        ZipFile zipFile;

        public ReadZipFS(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }

        @Override
        public Path getPath(String first, String ... more) {
            return new ReadZipPath(this.zipFile, first);
        }
    }

    static class ReadZipPath
    implements Path {
        ZipFile zipFile;
        String path;
        String displayName;

        public ReadZipPath(ZipFile zipFile, String path) {
            this(zipFile, path, null);
        }

        public ReadZipPath(ZipFile zipFile, String path, String substring) {
            this.zipFile = zipFile;
            this.path = path;
            this.displayName = substring;
        }

        @Override
        public Path resolve(String other) {
            if (this.path.endsWith("/")) {
                return new ReadZipPath(this.zipFile, this.path + other);
            }
            return new ReadZipPath(this.zipFile, this.path + "/" + other);
        }

        @Override
        public Path getFileName() {
            int i;
            int t = this.path.length() - 1;
            if (this.path.endsWith("/")) {
                --t;
            }
            if ((i = this.path.lastIndexOf(47, t)) > 0) {
                return new ReadZipPath(this.zipFile, this.path, this.path.substring(i + 1, t + 1));
            }
            return this;
        }

        @Override
        public Path getParent() {
            int i;
            int t = this.path.length() - 1;
            if (this.path.endsWith("/")) {
                --t;
            }
            return (i = this.path.lastIndexOf(47, t)) > 0 ? new ReadZipPath(this.zipFile, this.path.substring(0, i + 1), null) : null;
        }

        @Override
        public File toFile() {
            return null;
        }

        @Override
        public String toString() {
            return this.displayName != null ? this.displayName : this.path;
        }

        @Override
        public byte[] _readAllBytes() throws IOException {
            ZipEntry e = this.zipFile.getEntry(this.path);
            return e != null ? FileSystemProvider.readIs(this.zipFile.getInputStream(e)) : null;
        }

        @Override
        public OutputStream _newOutputStream() throws FileNotFoundException {
            throw new RuntimeException();
        }

        @Override
        public boolean _isDirectory() {
            ZipEntry e = this.zipFile.getEntry(this.path);
            return e != null && e.isDirectory();
        }

        @Override
        public Path _createDirectories() {
            throw new RuntimeException();
        }

        @Override
        public boolean _deleteIfExists() {
            throw new RuntimeException();
        }

        @Override
        public boolean _exists() {
            ZipEntry e = this.zipFile.getEntry(this.path);
            return e != null;
        }

        @Override
        public void _write(byte[] b) throws IOException {
            throw new RuntimeException();
        }

        @Override
        public void _walkFileTree(FileVisitor<? super Path> visitor) throws IOException {
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                ReadZipPath readZipPath = new ReadZipPath(this.zipFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    visitor.preVisitDirectory(readZipPath, null);
                    visitor.postVisitDirectory(readZipPath, null);
                    continue;
                }
                visitor.visitFile(readZipPath, null);
            }
        }

        @Override
        public Path relativize(Path other) {
            ReadZipPath p0 = (ReadZipPath)other;
            String display = this.path.substring(p0.path.length());
            return new ReadZipPath(this.zipFile, p0.path, display);
        }

        @Override
        public InputStream _newInputStream() throws IOException {
            ZipEntry e = this.zipFile.getEntry(this.path);
            return e != null ? this.zipFile.getInputStream(e) : null;
        }
    }

    static class CreatZipFS
    extends FileSystem {
        ZipOutputStream zos;
        private Set<String> files = new HashSet<String>();

        private boolean createDir0(String path) throws IOException {
            int x = path.lastIndexOf(47, path.length() - 2);
            if (x > 0) {
                String n = path.substring(0, x + 1);
                this.createDir0(n);
            }
            if (!path.contains(path)) {
                this.files.add(path);
                ZipEntry zipEntry = new ZipEntry(path);
                this.zos.putNextEntry(zipEntry);
                this.zos.closeEntry();
                return true;
            }
            return false;
        }

        private boolean exists(String path) {
            return this.files.contains(path);
        }

        public CreatZipFS(ZipOutputStream zipFile) {
            this.zos = zipFile;
        }

        @Override
        public void close() throws IOException {
            this.zos.close();
        }

        @Override
        public Path getPath(String first, String ... more) {
            return new CreateZipPath(first, null);
        }

        class CreateZipPath
        implements Path {
            String path;
            String displayName;

            public CreateZipPath(String s, String displayName) {
                this.path = s;
                this.displayName = displayName;
            }

            @Override
            public Path resolve(String other) {
                if (this.path.endsWith("/")) {
                    return new CreateZipPath(this.path + other, null);
                }
                return new CreateZipPath(this.path + "/" + other, null);
            }

            @Override
            public Path getFileName() {
                int i;
                int t = this.path.length() - 1;
                if (this.path.endsWith("/")) {
                    --t;
                }
                if ((i = this.path.lastIndexOf(47, t)) > 0) {
                    return new CreateZipPath(this.path, this.path.substring(i + 1, t + 1));
                }
                return this;
            }

            @Override
            public String toString() {
                return this.displayName != null ? this.displayName : this.path;
            }

            @Override
            public Path getParent() {
                int i = this.path.lastIndexOf(47, this.path.length() - 2);
                if (i > 0) {
                    return new CreateZipPath(this.path.substring(0, i), null);
                }
                return null;
            }

            @Override
            public File toFile() {
                return null;
            }

            @Override
            public byte[] _readAllBytes() {
                throw new RuntimeException();
            }

            @Override
            public OutputStream _newOutputStream() throws IOException {
                ZipEntry e = new ZipEntry(this.path.substring(1));
                CreatZipFS.this.zos.putNextEntry(e);
                return new FilterOutputStream(CreatZipFS.this.zos){

                    @Override
                    public void close() throws IOException {
                        CreatZipFS.this.zos.closeEntry();
                    }
                };
            }

            @Override
            public boolean _isDirectory() {
                return this.path.endsWith("/");
            }

            @Override
            public Path _createDirectories() throws IOException {
                CreatZipFS.this.createDir0(this.path);
                return this;
            }

            @Override
            public boolean _deleteIfExists() {
                throw new RuntimeException();
            }

            @Override
            public boolean _exists() {
                return CreatZipFS.this.exists(this.path);
            }

            @Override
            public void _write(byte[] b) throws IOException {
                OutputStream os = this._newOutputStream();
                os.write(b);
                os.close();
            }

            @Override
            public void _walkFileTree(FileVisitor<? super Path> visitor) {
                throw new RuntimeException();
            }

            @Override
            public Path relativize(Path other) {
                CreateZipPath p0 = (CreateZipPath)other;
                String display = this.path.substring(p0.path.length());
                return new CreateZipPath(p0.path, display);
            }

            @Override
            public InputStream _newInputStream() throws IOException {
                throw new RuntimeException();
            }
        }
    }
}

