/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.traceview.editors;

import com.android.ide.eclipse.ddms.JavaSourceRevealer;
import com.android.ide.eclipse.traceview.TraceviewPlugin;
import com.android.traceview.ColorController;
import com.android.traceview.DmTraceReader;
import com.android.traceview.MethodData;
import com.android.traceview.ProfileView;
import com.android.traceview.SelectionController;
import com.android.traceview.TimeLineView;
import com.android.traceview.TraceReader;
import com.android.traceview.TraceUnits;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TraceviewEditor
extends EditorPart
implements ProfileView.MethodHandler {
    private Composite mParent;
    private String mFilename;
    private Composite mContents;

    public void doSave(IProgressMonitor monitor) {
    }

    private IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(fileStore.toURI());
        if (files != null && files.length == 1) {
            return files[0];
        }
        return null;
    }

    public void doSaveAs() {
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile original = fileEditorInput.getFile();
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            if (original != null && !original.isAccessible()) {
                String message = String.format("The original file ''%s'' has been deleted or is not accessible.", original.getName());
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
            }
            if (dialog.open() == 1) {
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(filePath);
            if (this.copy(shell, fileEditorInput.getURI(), file.getLocationURI()) == null) {
                return;
            }
            try {
                file.refreshLocal(0, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            FileEditorInput newInput = new FileEditorInput(file);
            this.setInput((IEditorInput)newInput);
            this.setPartName(newInput.getName());
        } else if (input instanceof FileStoreEditorInput) {
            MessageDialog overwriteDialog;
            String path;
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)input;
            FileDialog dialog = new FileDialog(shell, 8192);
            IPath oldPath = URIUtil.toPath((URI)fileStoreEditorInput.getURI());
            if (oldPath != null) {
                dialog.setFileName(oldPath.lastSegment());
                dialog.setFilterPath(oldPath.toOSString());
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            File localFile = new File(path);
            if (localFile.exists() && (overwriteDialog = new MessageDialog(shell, "Save As", null, String.format("%s already exists.\nDo you want to replace it?", path), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) {
                return;
            }
            IFileStore destFileStore = this.copy(shell, fileStoreEditorInput.getURI(), localFile.toURI());
            if (destFileStore != null) {
                IFile file = this.getWorkspaceFile(destFileStore);
                Object newInput = file != null ? new FileEditorInput(file) : new FileStoreEditorInput(destFileStore);
                this.setInput((IEditorInput)newInput);
                this.setPartName(newInput.getName());
            }
        }
    }

    private IFileStore copy(Shell shell, URI source, URI dest) {
        IFileStore destFileStore = null;
        IFileStore sourceFileStore = null;
        try {
            destFileStore = EFS.getStore((URI)dest);
            sourceFileStore = EFS.getStore((URI)source);
            sourceFileStore.copy(destFileStore, 2, null);
        }
        catch (CoreException ex) {
            String title = "Problems During Save As...";
            String msg = String.format("Save could not be completed. %s", ex.getMessage());
            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            return null;
        }
        return destFileStore;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            this.mFilename = fileEditorInput.getPath().toOSString();
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            this.setPartName(input.getName());
        } else if (input instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)input;
            this.mFilename = fileStoreEditorInput.getURI().getPath();
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            this.setPartName(input.getName());
        } else {
            throw new PartInitException("Input is not of type FileEditorInput nor FileStoreEditorInput: " + input == null ? "null" : input.toString());
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        this.mParent = parent;
        try {
            DmTraceReader reader = new DmTraceReader(this.mFilename, false);
            reader.getTraceUnits().setTimeScale(TraceUnits.TimeScale.MilliSeconds);
            this.mContents = new Composite(this.mParent, 0);
            Display display = this.mContents.getDisplay();
            ColorController.assignMethodColors((Display)display, (MethodData[])reader.getMethods());
            SelectionController selectionController = new SelectionController();
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            this.mContents.setLayout((Layout)gridLayout);
            Color darkGray = display.getSystemColor(16);
            SashForm sashForm1 = new SashForm(this.mContents, 512);
            sashForm1.setBackground(darkGray);
            sashForm1.SASH_WIDTH = 3;
            GridData data = new GridData(1808);
            sashForm1.setLayoutData((Object)data);
            new TimeLineView((Composite)sashForm1, (TraceReader)reader, selectionController);
            new ProfileView((Composite)sashForm1, (TraceReader)reader, selectionController).setMethodHandler((ProfileView.MethodHandler)this);
        }
        catch (IOException e) {
            Label l = new Label(parent, 0);
            l.setText("Failed to read the stack trace.");
            Status status = new Status(4, "com.android.ide.eclipse.traceview", "Failed to read the stack trace.", (Throwable)e);
            TraceviewPlugin.getDefault().getLog().log((IStatus)status);
        }
        this.mParent.layout();
    }

    public void setFocus() {
        this.mParent.setFocus();
    }

    public void handleMethod(MethodData method) {
        String methodName = method.getMethodName();
        String className = method.getClassName().replaceAll("/", ".");
        String fqmn = String.valueOf(className) + "." + methodName;
        JavaSourceRevealer.revealMethod((String)fqmn, null, (int)-1, null);
    }
}

