/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.model;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.ProtoBufUtils;
import com.android.ide.eclipse.gltrace.TraceFileInfo;
import com.android.ide.eclipse.gltrace.TraceFileReader;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLFrame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GLTrace {
    private static final TraceFileReader sTraceFileReader = new TraceFileReader();
    private final TraceFileInfo mTraceFileInfo;
    private final List<GLFrame> mGLFrames;
    private final List<GLCall> mGLCalls;
    private List<Integer> mContextIds;

    public GLTrace(TraceFileInfo traceFileInfo, List<GLFrame> glFrames, List<GLCall> glCalls, List<Integer> contextIds) {
        this.mTraceFileInfo = traceFileInfo;
        this.mGLFrames = glFrames;
        this.mGLCalls = glCalls;
        this.mContextIds = contextIds;
    }

    public List<GLFrame> getFrames() {
        return this.mGLFrames;
    }

    public GLFrame getFrame(int i) {
        return this.mGLFrames.get(i);
    }

    public List<GLCall> getGLCalls() {
        return this.mGLCalls;
    }

    public List<GLCall> getGLCallsForFrame(int frameIndex) {
        if (frameIndex >= this.mGLFrames.size()) {
            return Collections.emptyList();
        }
        GLFrame frame = this.mGLFrames.get(frameIndex);
        return this.mGLCalls.subList(frame.getStartIndex(), frame.getEndIndex());
    }

    public Image getImage(GLCall c) {
        RandomAccessFile file;
        if (!c.hasFb()) {
            return null;
        }
        if (this.isTraceFileModified()) {
            return null;
        }
        try {
            file = new RandomAccessFile(this.mTraceFileInfo.getPath(), "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        GLProtoBuf.GLMessage m = null;
        try {
            try {
                m = sTraceFileReader.getMessageAtOffset(file, c.getOffsetInTraceFile());
            }
            catch (Exception exception) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                file.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            file.close();
        }
        catch (IOException iOException) {}
        return ProtoBufUtils.getImage(Display.getCurrent(), m);
    }

    private boolean isTraceFileModified() {
        File f = new File(this.mTraceFileInfo.getPath());
        return f.length() != this.mTraceFileInfo.getSize() || f.lastModified() != this.mTraceFileInfo.getLastModificationTime();
    }

    public List<Integer> getContexts() {
        return this.mContextIds;
    }
}

