/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.editors;

import com.android.ide.eclipse.gltrace.state.GLListProperty;
import com.android.ide.eclipse.gltrace.state.GLSparseArrayProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class StateLabelProvider
extends ColumnLabelProvider {
    private Set<IGLProperty> mChangedProperties;
    private Color mHighlightForegroundColor = Display.getDefault().getSystemColor(9);
    private Color mNormalForegroundColor = Display.getDefault().getSystemColor(2);

    public String getColumnText(IGLProperty property, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getName(property);
            }
            case 1: {
                return this.getValue(property);
            }
        }
        return "";
    }

    private String getValue(IGLProperty element) {
        return element.getStringValue();
    }

    private String getName(IGLProperty element) {
        IGLProperty parent = element.getParent();
        if (parent instanceof GLListProperty) {
            int index = ((GLListProperty)parent).indexOf(element);
            if (element.getType() == GLStateType.GL_STATE_ES1) {
                return String.format("Context %d (ES1)", index);
            }
            if (element.getType() == GLStateType.GL_STATE_ES2) {
                return String.format("Context %d (ES2)", index);
            }
            return Integer.toString(index);
        }
        if (parent instanceof GLSparseArrayProperty) {
            int index = ((GLSparseArrayProperty)parent).keyFor(element);
            return Integer.toString(index);
        }
        return element.getType().getDescription();
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (!(element instanceof IGLProperty)) {
            return;
        }
        IGLProperty prop = (IGLProperty)element;
        String text = this.getColumnText(prop, cell.getColumnIndex());
        cell.setText(text);
        if (this.mChangedProperties != null && this.mChangedProperties.contains(prop)) {
            cell.setForeground(this.mHighlightForegroundColor);
        } else {
            cell.setForeground(this.mNormalForegroundColor);
        }
    }

    public void setChangedProperties(Set<IGLProperty> changedProperties) {
        this.mChangedProperties = changedProperties;
    }
}

