/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ndk.internal.launch;

import com.android.ide.eclipse.ndk.internal.NdkHelper;
import com.android.ide.eclipse.ndk.internal.NdkManager;
import com.android.ide.eclipse.ndk.internal.launch.NdkLaunchConstants;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NdkDebuggerTab
extends AbstractLaunchConfigurationTab {
    private static String sLastGdbPath;
    private static String sLastSolibPath;
    private Text mGdbPathText;
    private Text mGdbInitPathText;
    private Text mGdbRemotePortText;
    private org.eclipse.swt.widgets.List mSoliblist;
    private Button mAddSolibButton;
    private Button mDeleteSolibButton;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, false));
        Group grpGdb = new Group(comp, 0);
        grpGdb.setText("Launch Options");
        grpGdb.setLayout((Layout)new GridLayout(3, false));
        grpGdb.setLayoutData((Object)new GridData(768));
        Label lblDebugger = new Label((Composite)grpGdb, 0);
        lblDebugger.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDebugger.setText("Debugger:");
        this.mGdbPathText = new Text((Composite)grpGdb, 2048);
        this.mGdbPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        final Button btnBrowseGdb = new Button((Composite)grpGdb, 0);
        btnBrowseGdb.setText("Browse...");
        Label lblNewLabel = new Label((Composite)grpGdb, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText("GDB Command File:");
        this.mGdbInitPathText = new Text((Composite)grpGdb, 2048);
        this.mGdbInitPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowseGdbInit = new Button((Composite)grpGdb, 0);
        btnBrowseGdbInit.setText("Browse...");
        SelectionAdapter browseListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = ((Control)e.getSource()).getShell();
                if (e.getSource() == btnBrowseGdb) {
                    NdkDebuggerTab.this.browseForGdb(shell);
                } else {
                    NdkDebuggerTab.this.browseForGdbInit(shell);
                }
                NdkDebuggerTab.this.checkParameters();
                NdkDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        };
        btnBrowseGdb.addSelectionListener((SelectionListener)browseListener);
        btnBrowseGdbInit.addSelectionListener((SelectionListener)browseListener);
        Label lblPort = new Label((Composite)grpGdb, 0);
        lblPort.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPort.setText("Port:");
        this.mGdbRemotePortText = new Text((Composite)grpGdb, 2048);
        GridData gd_text_2 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_text_2.widthHint = 100;
        this.mGdbRemotePortText.setLayoutData((Object)gd_text_2);
        ModifyListener m = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NdkDebuggerTab.this.checkParameters();
                NdkDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.mGdbPathText.addModifyListener(m);
        this.mGdbInitPathText.addModifyListener(m);
        this.mGdbRemotePortText.addModifyListener(m);
        Group grpSharedLibraries = new Group(comp, 0);
        grpSharedLibraries.setText("Shared Libraries");
        grpSharedLibraries.setLayout((Layout)new GridLayout(2, false));
        GridData gd_grpSharedLibraries = new GridData(1808);
        gd_grpSharedLibraries.verticalAlignment = 128;
        gd_grpSharedLibraries.grabExcessVerticalSpace = true;
        grpSharedLibraries.setLayoutData((Object)gd_grpSharedLibraries);
        this.mSoliblist = new org.eclipse.swt.widgets.List((Composite)grpSharedLibraries, 2564);
        GridData gd_list = new GridData(1808);
        gd_list.heightHint = 133;
        gd_list.grabExcessVerticalSpace = false;
        gd_list.verticalSpan = 1;
        this.mSoliblist.setLayoutData((Object)gd_list);
        Composite composite = new Composite((Composite)grpSharedLibraries, 0);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        composite.setLayout((Layout)new RowLayout(512));
        this.mAddSolibButton = new Button(composite, 0);
        this.mAddSolibButton.setText("Add...");
        this.mDeleteSolibButton = new Button(composite, 0);
        this.mDeleteSolibButton.setText("Remove");
        this.mDeleteSolibButton.setEnabled(false);
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control c = (Control)e.getSource();
                if (c == NdkDebuggerTab.this.mSoliblist) {
                    NdkDebuggerTab.this.mDeleteSolibButton.setEnabled(NdkDebuggerTab.this.mSoliblist.getSelectionCount() > 0);
                } else if (c == NdkDebuggerTab.this.mAddSolibButton) {
                    NdkDebuggerTab.this.addSolib(c.getShell());
                } else {
                    int index = NdkDebuggerTab.this.mSoliblist.getSelectionIndex();
                    if (index >= 0) {
                        NdkDebuggerTab.this.mSoliblist.remove(index);
                    }
                }
                NdkDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.mSoliblist.addSelectionListener((SelectionListener)l);
        this.mAddSolibButton.addSelectionListener((SelectionListener)l);
        this.mDeleteSolibButton.addSelectionListener((SelectionListener)l);
    }

    private void addSolib(Shell shell) {
        String solibPath;
        DirectoryDialog dd = new DirectoryDialog(shell);
        if (sLastSolibPath != null) {
            dd.setFilterPath(sLastSolibPath);
        }
        if ((solibPath = dd.open()) != null) {
            this.mSoliblist.add(solibPath);
            sLastSolibPath = new File(solibPath).getParent();
        }
    }

    private void browseForGdb(Shell shell) {
        if (sLastGdbPath == null) {
            sLastGdbPath = NdkManager.getNdkLocation();
        }
        FileDialog fd = new FileDialog(shell);
        fd.setFilterPath(sLastGdbPath);
        String gdbPath = fd.open();
        if (gdbPath != null) {
            this.mGdbPathText.setText(gdbPath);
            sLastGdbPath = new File(gdbPath).getParent();
        }
    }

    private void browseForGdbInit(Shell shell) {
        FileDialog fd = new FileDialog(shell);
        String gdbInit = fd.open();
        if (gdbInit != null) {
            this.mGdbInitPathText.setText(gdbInit);
        }
    }

    private void checkParameters() {
        File f;
        File f2;
        String gdb = this.mGdbPathText.getText().trim();
        if (!(gdb.equals(NdkLaunchConstants.DEFAULT_GDB) || (f2 = new File(gdb)).exists() && f2.canExecute())) {
            this.setErrorMessage("Invalid gdb location.");
            return;
        }
        String gdbInit = this.mGdbInitPathText.getText().trim();
        if (!(gdbInit.isEmpty() || (f = new File(gdbInit)).exists() && f.isFile())) {
            this.setErrorMessage("Invalid gdbinit location.");
            return;
        }
        String port = this.mGdbRemotePortText.getText().trim();
        try {
            Integer.parseInt(port, 10);
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Port should be a valid integer");
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        NdkHelper.setLaunchConfigDefaults(config);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.mGdbPathText.setText(this.getAttribute(config, "com.android.ide.eclipse.ndk.ndklaunch.gdb", NdkLaunchConstants.DEFAULT_GDB));
        this.mGdbInitPathText.setText(this.getAttribute(config, "org.eclipse.cdt.dsf.gdb.GDB_INIT", ""));
        this.mGdbRemotePortText.setText(this.getAttribute(config, "org.eclipse.cdt.dsf.gdb.PORT", "5039"));
        List<String> solibs = this.getAttribute(config, "com.android.ide.eclipse.ndk.ndklaunch.solib", Collections.EMPTY_LIST);
        this.mSoliblist.removeAll();
        for (String s : solibs) {
            this.mSoliblist.add(s);
        }
    }

    private String getAttribute(ILaunchConfiguration config, String key, String defaultValue) {
        try {
            return config.getAttribute(key, defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    private List<String> getAttribute(ILaunchConfiguration config, String key, List<String> defaultValue) {
        try {
            return config.getAttribute(key, defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("com.android.ide.eclipse.ndk.ndklaunch.gdb", this.mGdbPathText.getText().trim());
        config.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", this.mGdbInitPathText.getText().trim());
        config.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", this.mGdbRemotePortText.getText().trim());
        config.setAttribute("com.android.ide.eclipse.ndk.ndklaunch.solib", Arrays.asList(this.mSoliblist.getItems()));
    }

    public String getName() {
        return "Debugger";
    }
}

