/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ndk.internal.launch;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class GdbServerTask
implements Runnable {
    private IDevice mDevice;
    private String mRunAs;
    private String mSocket;
    private int mPid;
    private CountDownLatch mAttachLatch;
    private GdbServerOutputReceiver mOutputReceiver;
    private Exception mLaunchException;
    private AtomicBoolean mCancelled = new AtomicBoolean(false);
    private AtomicBoolean mHasCompleted = new AtomicBoolean(false);

    public GdbServerTask(IDevice device, String runAsPackage, String socketName, int pid, CountDownLatch attachLatch) {
        this.mDevice = device;
        this.mRunAs = runAsPackage;
        this.mSocket = socketName;
        this.mPid = pid;
        this.mAttachLatch = attachLatch;
        this.mOutputReceiver = new GdbServerOutputReceiver();
    }

    @Override
    public void run() {
        String command = String.format("run-as %s lib/gdbserver +%s --attach %d", this.mRunAs, this.mSocket, this.mPid);
        try {
            this.mDevice.executeShellCommand(command, (IShellOutputReceiver)this.mOutputReceiver, 0);
        }
        catch (Exception e) {
            this.mLaunchException = e;
        }
    }

    public Exception getLaunchException() {
        return this.mLaunchException;
    }

    public void setCancelled() {
        this.mCancelled.set(true);
    }

    public String getShellOutput() {
        return this.mOutputReceiver.getOutput();
    }

    private class GdbServerOutputReceiver
    implements IShellOutputReceiver {
        private StringBuffer mOutput = new StringBuffer(100);

        private GdbServerOutputReceiver() {
        }

        public synchronized void addOutput(byte[] data, int offset, int length) {
            this.mOutput.append(new String(data, offset, length));
            if (this.mOutput.toString().contains("Attached")) {
                GdbServerTask.this.mAttachLatch.countDown();
            }
        }

        public void flush() {
            GdbServerTask.this.mHasCompleted.set(true);
        }

        public boolean isCancelled() {
            return GdbServerTask.this.mCancelled.get();
        }

        public synchronized String getOutput() {
            return this.mOutput.toString();
        }
    }
}

