/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import com.android.ide.eclipse.adt.internal.wizards.newproject.WorkingSetGroup;
import com.android.ide.eclipse.adt.internal.wizards.newproject.WorkingSetHelper;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewProjectWizardState;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;

public class ProjectContentsPage
extends WizardPage
implements ModifyListener,
SelectionListener,
FocusListener {
    private final NewProjectWizardState mValues;
    private boolean mIgnore;
    private Button mCustomIconToggle;
    private Button mLibraryToggle;
    private Button mUseDefaultLocationToggle;
    private Label mLocationLabel;
    private Text mLocationText;
    private Button mChooseLocationButton;
    private static String sLastProjectLocation = System.getProperty("user.home");
    private Button mCreateActivityToggle;
    private WorkingSetGroup mWorkingSetGroup;

    ProjectContentsPage(NewProjectWizardState values) {
        super("newAndroidApp");
        this.mValues = values;
        this.setTitle("New Android Application");
        this.setDescription("Configure Project");
        this.mWorkingSetGroup = new WorkingSetGroup();
        this.setWorkingSets(new IWorkingSet[0]);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(4, false);
        gl_container.horizontalSpacing = 10;
        container.setLayout((Layout)gl_container);
        this.mCustomIconToggle = new Button(container, 32);
        this.mCustomIconToggle.setSelection(true);
        this.mCustomIconToggle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mCustomIconToggle.setText("Create custom launcher icon");
        this.mCustomIconToggle.setSelection(this.mValues.createIcon);
        this.mCustomIconToggle.addSelectionListener((SelectionListener)this);
        this.mCreateActivityToggle = new Button(container, 32);
        this.mCreateActivityToggle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mCreateActivityToggle.setText("Create activity");
        this.mCreateActivityToggle.setSelection(this.mValues.createActivity);
        this.mCreateActivityToggle.addSelectionListener((SelectionListener)this);
        new Label(container, 0).setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mLibraryToggle = new Button(container, 32);
        this.mLibraryToggle.setSelection(true);
        this.mLibraryToggle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mLibraryToggle.setText("Mark this project as a library");
        this.mLibraryToggle.setSelection(this.mValues.isLibrary);
        this.mLibraryToggle.addSelectionListener((SelectionListener)this);
        new Label(container, 0).setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mUseDefaultLocationToggle = new Button(container, 32);
        this.mUseDefaultLocationToggle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mUseDefaultLocationToggle.setText("Create Project in Workspace");
        this.mUseDefaultLocationToggle.addSelectionListener((SelectionListener)this);
        this.mLocationLabel = new Label(container, 0);
        this.mLocationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mLocationLabel.setText("Location:");
        this.mLocationText = new Text(container, 2048);
        this.mLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mLocationText.addModifyListener((ModifyListener)this);
        this.mChooseLocationButton = new Button(container, 0);
        this.mChooseLocationButton.setText("Browse...");
        this.mChooseLocationButton.addSelectionListener((SelectionListener)this);
        this.mChooseLocationButton.setEnabled(false);
        this.setUseCustomLocation(!this.mValues.useDefaultLocation);
        new Label(container, 0).setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        Composite group = this.mWorkingSetGroup.createControl(container);
        group.setLayoutData((Object)new GridData(4, 4, false, false, 4, 1));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.mIgnore = true;
                this.mUseDefaultLocationToggle.setSelection(this.mValues.useDefaultLocation);
                this.mLocationText.setText(this.mValues.projectLocation);
            }
            finally {
                this.mIgnore = false;
            }
        }
        this.validatePage();
    }

    private void setUseCustomLocation(boolean en) {
        this.mValues.useDefaultLocation = !en;
        this.mUseDefaultLocationToggle.setSelection(!en);
        if (!en) {
            this.updateProjectLocation(this.mValues.projectName);
        }
        this.mLocationLabel.setEnabled(en);
        this.mLocationText.setEnabled(en);
        this.mChooseLocationButton.setEnabled(en);
    }

    void init(IStructuredSelection selection, IWorkbenchPart activePart) {
        this.setWorkingSets(WorkingSetHelper.getSelectedWorkingSet(selection, activePart));
    }

    private IWorkingSet[] getWorkingSets() {
        return this.mWorkingSetGroup.getSelectedWorkingSets();
    }

    private void setWorkingSets(IWorkingSet[] workingSets) {
        assert (workingSets != null);
        this.mWorkingSetGroup.setWorkingSets(workingSets);
    }

    public IWizardPage getNextPage() {
        this.mValues.workingSets = this.getWorkingSets();
        return super.getNextPage();
    }

    public void modifyText(ModifyEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mLocationText) {
            this.mValues.projectLocation = this.mLocationText.getText().trim();
        }
        this.validatePage();
    }

    private void updateProjectLocation(String projectName) {
        boolean useDefaultLocation;
        if (projectName == null) {
            projectName = "";
        }
        if (useDefaultLocation = this.mUseDefaultLocationToggle.getSelection()) {
            IPath workspace = Platform.getLocation();
            String projectLocation = workspace.append(projectName).toOSString();
            this.mLocationText.setText(projectLocation);
            this.mValues.projectLocation = projectLocation;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        String dir;
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mCustomIconToggle) {
            this.mValues.createIcon = this.mCustomIconToggle.getSelection();
        } else if (source == this.mLibraryToggle) {
            this.mValues.isLibrary = this.mLibraryToggle.getSelection();
        } else if (source == this.mCreateActivityToggle) {
            this.mValues.createActivity = this.mCreateActivityToggle.getSelection();
        } else if (source == this.mUseDefaultLocationToggle) {
            boolean useDefault = this.mUseDefaultLocationToggle.getSelection();
            this.setUseCustomLocation(!useDefault);
        } else if (source == this.mChooseLocationButton && (dir = this.promptUserForLocation(this.getShell())) != null) {
            this.mLocationText.setText(dir);
            this.mValues.projectLocation = dir;
        }
        this.validatePage();
    }

    private String promptUserForLocation(Shell shell) {
        DirectoryDialog dd = new DirectoryDialog(this.getShell());
        dd.setMessage("Select folder where project should be created");
        String curLocation = this.mLocationText.getText().trim();
        if (!curLocation.isEmpty()) {
            dd.setFilterPath(curLocation);
        } else if (sLastProjectLocation != null) {
            dd.setFilterPath(sLastProjectLocation);
        }
        String dir = dd.open();
        if (dir != null) {
            sLastProjectLocation = dir;
        }
        return dir;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    void validatePage() {
        IStatus status = this.validateProjectLocation();
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    static IStatus validateLocationInWorkspace(NewProjectWizardState values) {
        File dest;
        if (values.useDefaultLocation) {
            return null;
        }
        if (values.projectName != null && (dest = Platform.getLocation().append(values.projectName).toFile()).exists()) {
            return new Status(4, "com.android.ide.eclipse.adt", String.format("There is already a file or directory named \"%1$s\" in the selected location.", values.projectName));
        }
        return null;
    }

    private IStatus validateProjectLocation() {
        File parent;
        if (this.mValues.useDefaultLocation) {
            return ProjectContentsPage.validateLocationInWorkspace(this.mValues);
        }
        String location = this.mLocationText.getText();
        if (location.trim().isEmpty()) {
            return new Status(4, "com.android.ide.eclipse.adt", "Provide a valid file system location where the project should be created.");
        }
        File f = new File(location);
        if (f.exists()) {
            if (!f.isDirectory()) {
                return new Status(4, "com.android.ide.eclipse.adt", String.format("'%s' is not a valid folder.", location));
            }
            File[] children = f.listFiles();
            if (children != null && children.length > 0) {
                return new Status(4, "com.android.ide.eclipse.adt", String.format("Folder '%s' is not empty.", location));
            }
        }
        if (!(parent = f.getParentFile()).exists()) {
            return new Status(4, "com.android.ide.eclipse.adt", String.format("Folder '%s' does not exist.", parent.getName()));
        }
        if (!parent.isDirectory()) {
            return new Status(4, "com.android.ide.eclipse.adt", String.format("'%s' is not a folder.", parent.getName()));
        }
        if (!parent.canWrite()) {
            return new Status(4, "com.android.ide.eclipse.adt", String.format("'%s' is not writeable.", parent.getName()));
        }
        return null;
    }
}

