/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.internal.assetstudio.ConfigureAssetSetPage;
import com.android.ide.eclipse.adt.internal.assetstudio.CreateAssetSetWizardState;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.templates.StringEvaluator;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateHandler;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateManager;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateMetadata;
import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;

public class NewTemplateWizardState {
    private TemplateHandler mTemplateHandler;
    public final Map<String, Object> parameters = new HashMap<String, Object>();
    public final Map<String, String> defaults = new HashMap<String, String>();
    public final Set<String> hidden = new HashSet<String>();
    public IProject project;
    public int minSdkLevel;
    private File mTemplateLocation;
    private CreateAssetSetWizardState mIconState;

    public NewTemplateWizardState() {
        this.parameters.put("isNewProject", false);
    }

    @NonNull
    TemplateHandler getTemplateHandler() {
        if (this.mTemplateHandler == null) {
            File inputPath = this.mTemplateLocation != null ? this.mTemplateLocation : TemplateManager.getTemplateLocation("activities/BlankActivity");
            this.mTemplateHandler = TemplateHandler.createFromPath(inputPath);
        }
        return this.mTemplateHandler;
    }

    void setTemplateLocation(File file) {
        if (!file.equals(this.mTemplateLocation)) {
            this.mTemplateLocation = file;
            this.mTemplateHandler = null;
        }
    }

    File getTemplateLocation() {
        return this.mTemplateLocation;
    }

    int getMinSdk() {
        if (this.project == null) {
            return -1;
        }
        ManifestInfo manifest = ManifestInfo.get(this.project);
        return manifest.getMinSdkVersion();
    }

    int getBuildApi() {
        if (this.project == null) {
            return -1;
        }
        IAndroidTarget target = Sdk.getCurrent().getTarget(this.project);
        if (target != null) {
            return target.getVersion().getApiLevel();
        }
        return this.getMinSdk();
    }

    @NonNull
    List<Change> computeChanges() {
        if (this.project == null) {
            return Collections.emptyList();
        }
        ManifestInfo manifest = ManifestInfo.get(this.project);
        this.parameters.put("packageName", manifest.getPackage());
        this.parameters.put("minApi", manifest.getMinSdkName());
        this.parameters.put("minApiLevel", manifest.getMinSdkVersion());
        this.parameters.put("targetApi", manifest.getTargetSdkVersion());
        this.parameters.put("buildApi", this.getBuildApi());
        this.parameters.put("copyIcons", this.mIconState == null);
        ProjectState projectState = Sdk.getProjectState(this.project);
        this.parameters.put("isLibraryProject", projectState != null ? projectState.isLibrary() : false);
        List<Change> changes = this.getTemplateHandler().render(this.project, this.parameters);
        if (this.mIconState != null) {
            String title = String.format("Generate icons (res/drawable-<density>/%1$s.png)", this.mIconState.outputName);
            changes.add((Change)new NullChange(title){

                public Change perform(IProgressMonitor pm) throws CoreException {
                    ConfigureAssetSetPage.generateIcons(((NewTemplateWizardState)NewTemplateWizardState.this).mIconState.project, NewTemplateWizardState.this.mIconState, false, null);
                    return null;
                }
            });
        }
        return changes;
    }

    @NonNull
    CreateAssetSetWizardState getIconState() {
        TemplateMetadata template;
        TemplateHandler handler;
        if (this.mIconState == null && (handler = this.getTemplateHandler()) != null && (template = handler.getTemplate()) != null) {
            this.mIconState = template.getIconState(this.project);
        }
        return this.mIconState;
    }

    public void updateIconState(@Nullable StringEvaluator evaluator) {
        TemplateMetadata template = this.getTemplateHandler().getTemplate();
        if (template != null) {
            if (evaluator == null) {
                evaluator = new StringEvaluator();
            }
            template.updateIconName(template.getParameters(), evaluator);
        }
    }
}

