/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.templates;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ImageControl;
import com.android.ide.eclipse.adt.internal.wizards.templates.NewProjectWizardState;
import com.android.ide.eclipse.adt.internal.wizards.templates.Parameter;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateHandler;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateManager;
import com.android.ide.eclipse.adt.internal.wizards.templates.TemplateMetadata;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class ActivityPage
extends WizardPage
implements SelectionListener {
    private final NewProjectWizardState mValues;
    private org.eclipse.swt.widgets.List mList;
    private Button mCreateToggle;
    private List<File> mTemplates;
    private boolean mIgnore;
    private boolean mShown;
    private ImageControl mPreview;
    private Image mPreviewImage;
    private boolean mDisposePreviewImage;
    private Label mHeading;
    private Label mDescription;
    private boolean mOnlyActivities;
    private boolean mAskCreate;
    private boolean mLauncherActivitiesOnly;

    ActivityPage(NewProjectWizardState values, boolean onlyActivities, boolean askCreate) {
        super("activityPage");
        this.mValues = values;
        this.mOnlyActivities = onlyActivities;
        this.mAskCreate = askCreate;
        if (onlyActivities) {
            this.setTitle("Create Activity");
        } else {
            this.setTitle("Create Android Object");
        }
        if (onlyActivities && askCreate) {
            this.setDescription("Select whether to create an activity, and if so, what kind of activity.");
        } else {
            this.setDescription("Select which template to use");
        }
    }

    void setLauncherActivitiesOnly(boolean launcherActivitiesOnly) {
        this.mLauncherActivitiesOnly = launcherActivitiesOnly;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
    }

    private void onEnter() {
        Composite container = (Composite)this.getControl();
        container.setLayout((Layout)new GridLayout(3, false));
        if (this.mAskCreate) {
            this.mCreateToggle = new Button(container, 32);
            this.mCreateToggle.setSelection(true);
            this.mCreateToggle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
            this.mCreateToggle.setText("Create Activity");
            this.mCreateToggle.addSelectionListener((SelectionListener)this);
        }
        this.mList = new org.eclipse.swt.widgets.List(container, 2560);
        this.mList.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TemplateManager manager = this.mValues.template.getManager();
        List<File> templates = manager.getTemplates("activities");
        if (!this.mOnlyActivities) {
            templates.addAll(manager.getTemplates("other"));
        }
        ArrayList<String> names = new ArrayList<String>(templates.size());
        File current = this.mValues.activityValues.getTemplateLocation();
        this.mTemplates = Lists.newArrayListWithExpectedSize((int)templates.size());
        int index = -1;
        int i = 0;
        int n = templates.size();
        while (i < n) {
            Parameter parameter;
            File template = templates.get(i);
            TemplateMetadata metadata = manager.getTemplate(template);
            if (!(metadata == null || this.mLauncherActivitiesOnly && (parameter = metadata.getParameter("isLauncher")) == null)) {
                this.mTemplates.add(template);
                names.add(metadata.getTitle());
                if (template.equals(current)) {
                    index = names.size();
                }
            }
            ++i;
        }
        String[] items = names.toArray(new String[names.size()]);
        this.mList.setItems(items);
        if (index == -1 && !this.mTemplates.isEmpty()) {
            this.mValues.activityValues.setTemplateLocation(this.mTemplates.get(0));
            index = 0;
        }
        if (index >= 0) {
            this.mList.setSelection(index);
            this.mList.addSelectionListener((SelectionListener)this);
        }
        this.mPreview = new ImageControl(container, 0, null);
        this.mPreview.setDisposeImage(false);
        GridData gd_mImage = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_mImage.widthHint = 220;
        this.mPreview.setLayoutData(gd_mImage);
        new Label(container, 0);
        this.mHeading = new Label(container, 0);
        this.mHeading.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        new Label(container, 0);
        this.mDescription = new Label(container, 64);
        this.mDescription.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        Font font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.bannerfont");
        if (font != null) {
            this.mHeading.setFont(font);
        }
        this.updatePreview();
    }

    private void updatePreview() {
        Image oldImage = this.mPreviewImage;
        boolean dispose = this.mDisposePreviewImage;
        this.mPreviewImage = null;
        String title = "";
        String description = "";
        TemplateHandler handler = this.mValues.activityValues.getTemplateHandler();
        TemplateMetadata template = handler.getTemplate();
        if (template != null) {
            String thumb = template.getThumbnailPath();
            if (thumb != null && !thumb.isEmpty()) {
                File file = new File(this.mValues.activityValues.getTemplateLocation(), thumb.replace('/', File.separatorChar));
                try {
                    byte[] bytes = Files.toByteArray((File)file);
                    ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                    this.mPreviewImage = new Image((Device)this.getControl().getDisplay(), (InputStream)input);
                    this.mDisposePreviewImage = true;
                    input.close();
                }
                catch (IOException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                }
            } else {
                this.mDisposePreviewImage = false;
                this.mPreviewImage = TemplateMetadata.getDefaultTemplateIcon();
            }
            title = template.getTitle();
            description = template.getDescription();
        }
        this.mHeading.setText(title);
        this.mDescription.setText(description);
        this.mPreview.setImage(this.mPreviewImage);
        this.mPreview.fitToWidth(200);
        if (oldImage != null && dispose) {
            oldImage.dispose();
        }
        Composite parent = (Composite)this.getControl();
        parent.layout(true, true);
        parent.redraw();
    }

    public void dispose() {
        super.dispose();
        if (this.mPreviewImage != null && this.mDisposePreviewImage) {
            this.mDisposePreviewImage = false;
            this.mPreviewImage.dispose();
            this.mPreviewImage = null;
        }
    }

    public void setVisible(boolean visible) {
        if (visible && !this.mShown) {
            this.onEnter();
        }
        super.setVisible(visible);
        if (visible) {
            this.mShown = true;
            if (this.mAskCreate) {
                try {
                    this.mIgnore = true;
                    this.mCreateToggle.setSelection(this.mValues.createActivity);
                }
                finally {
                    this.mIgnore = false;
                }
            }
        }
        this.validatePage();
    }

    private void validatePage() {
        Status status = null;
        if (this.mValues.createActivity) {
            if (this.mList.getSelectionCount() < 1) {
                status = new Status(4, "com.android.ide.eclipse.adt", "Select an activity type");
            } else {
                TemplateHandler templateHandler = this.mValues.activityValues.getTemplateHandler();
                status = templateHandler.validateTemplate(this.mValues.minSdkLevel, this.mValues.getBuildApi());
            }
        }
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    public boolean isPageComplete() {
        if (!this.mShown && this.mValues.createActivity) {
            return false;
        }
        return super.isPageComplete();
    }

    public void widgetSelected(SelectionEvent e) {
        int index;
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mCreateToggle) {
            this.mValues.createActivity = this.mCreateToggle.getSelection();
            this.mList.setEnabled(this.mValues.createActivity);
        } else if (source == this.mList && (index = this.mList.getSelectionIndex()) >= 0 && index < this.mTemplates.size()) {
            File template = this.mTemplates.get(index);
            this.mValues.activityValues.setTemplateLocation(template);
            this.updatePreview();
        }
        this.validatePage();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

