/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newproject;

import com.android.annotations.Nullable;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.newproject.ImportedProject;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.utils.Pair;
import com.android.xml.AndroidManifest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkingSet;

public class NewProjectWizardState {
    public Mode mode;
    public boolean useExisting;
    public boolean useDefaultLocation = true;
    public IAndroidTarget target;
    public boolean targetModifiedByUser;
    public File projectLocation = new File(Platform.getLocation().toOSString());
    public boolean projectLocationModifiedByUser;
    public String projectName = "";
    public boolean projectNameModifiedByUser;
    public String applicationName;
    public boolean applicationNameModifiedByUser;
    public String packageName;
    public boolean packageNameModifiedByUser;
    public boolean createActivity;
    public String activityName;
    public boolean activityNameModifiedByUser;
    public String minSdk;
    public boolean minSdkModifiedByUser;
    public List<Pair<String, File>> samples = new ArrayList<Pair<String, File>>();
    public File chosenSample;
    public String sourceFolder = "src";
    public IWorkingSet[] workingSets = new IWorkingSet[0];
    public IProject testedProject;
    public boolean testingSelf;
    public boolean createPairProject;
    public String testApplicationName;
    public boolean testApplicationNameModified;
    public String testPackageName;
    public boolean testPackageModified;
    public String testProjectName;
    public boolean testProjectModified;
    public String testTargetPackageName;
    public boolean copyIntoWorkspace;
    @Nullable
    public List<ImportedProject> importProjects;

    public NewProjectWizardState(Mode mode) {
        this.mode = mode;
        if (mode == Mode.SAMPLE) {
            this.useExisting = true;
        } else if (mode == Mode.TEST) {
            this.createActivity = false;
        }
    }

    public void extractFromAndroidManifest(Path path) {
        String osPath = path.append("AndroidManifest.xml").toOSString();
        if (!new File(osPath).exists()) {
            return;
        }
        ManifestData manifestData = AndroidManifestHelper.parseForData(osPath);
        if (manifestData == null) {
            return;
        }
        String newPackageName = null;
        ManifestData.Activity activity = null;
        String newActivityName = null;
        String minSdkVersion = null;
        try {
            ManifestData.Activity[] activities;
            newPackageName = manifestData.getPackage();
            minSdkVersion = manifestData.getMinSdkVersionString();
            activity = manifestData.getLauncherActivity();
            if (activity == null && (activities = manifestData.getActivities()) != null && activities.length > 0) {
                activity = activities[0];
            }
        }
        catch (Exception exception) {}
        if (newPackageName != null && newPackageName.length() > 0) {
            this.packageName = newPackageName;
        }
        if (activity != null) {
            newActivityName = AndroidManifest.extractActivityName((String)activity.getName(), (String)newPackageName);
        }
        if (newActivityName != null && newActivityName.length() > 0) {
            this.activityName = newActivityName;
            this.createActivity = false;
            if (newActivityName.indexOf(46) != -1) {
                String[] ids = newActivityName.split("\\.");
                newActivityName = ids[ids.length - 1];
            }
            if (this.projectName == null || this.projectName.length() == 0 || !this.projectNameModifiedByUser) {
                this.projectName = newActivityName;
                this.projectNameModifiedByUser = false;
            }
            if (this.applicationName == null || this.applicationName.length() == 0 || !this.applicationNameModifiedByUser) {
                this.applicationNameModifiedByUser = false;
                this.applicationName = newActivityName;
            }
        } else {
            this.activityName = "";
            if (newPackageName != null && newPackageName.length() > 0) {
                if (this.applicationName == null || this.applicationName.length() == 0 || !this.applicationNameModifiedByUser) {
                    this.applicationName = newPackageName;
                }
                newPackageName = newPackageName.replace('.', '_');
                if (this.projectName == null || this.projectName.length() == 0 || !this.projectNameModifiedByUser) {
                    this.projectName = newPackageName;
                }
            }
        }
        if (this.mode == Mode.ANY && this.useExisting) {
            this.updateSdkTargetToMatchProject(path.toFile());
        }
        this.minSdk = minSdkVersion;
        this.minSdkModifiedByUser = false;
    }

    public void updateSdkTargetToMatchMinSdkVersion() {
        IAndroidTarget currentTarget = this.target;
        if (currentTarget != null && currentTarget.getVersion().equals((Object)this.minSdk)) {
            return;
        }
        Sdk sdk = Sdk.getCurrent();
        if (sdk != null) {
            IAndroidTarget[] targets;
            IAndroidTarget[] iAndroidTargetArray = targets = sdk.getTargets();
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IAndroidTarget t = iAndroidTargetArray[n2];
                if (t.getVersion().equals((Object)this.minSdk)) {
                    this.target = t;
                    return;
                }
                ++n2;
            }
        }
    }

    public void updateSdkTargetToMatchProject(File location) {
        IAndroidTarget foundTarget = null;
        IAndroidTarget currentTarget = this.target;
        String projectPath = location.getPath();
        if (!this.targetModifiedByUser) {
            IAndroidTarget existingTarget;
            int n;
            int n2;
            IAndroidTarget[] iAndroidTargetArray;
            ProjectProperties p = ProjectProperties.load((String)projectPath, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
            if (p != null) {
                String v = p.getProperty("target");
                IAndroidTarget desiredTarget = Sdk.getCurrent().getTargetFromHashString(v);
                if (!(desiredTarget == null || currentTarget != null && desiredTarget.canRunOn(currentTarget))) {
                    foundTarget = desiredTarget;
                }
            }
            Sdk sdk = Sdk.getCurrent();
            IAndroidTarget[] targets = null;
            if (sdk != null) {
                targets = sdk.getTargets();
            }
            if (targets == null) {
                targets = new IAndroidTarget[]{};
            }
            if (foundTarget == null && this.minSdk != null) {
                iAndroidTargetArray = targets;
                n2 = targets.length;
                n = 0;
                while (n < n2) {
                    existingTarget = iAndroidTargetArray[n];
                    if (existingTarget != null && existingTarget.getVersion().equals((Object)this.minSdk)) {
                        foundTarget = existingTarget;
                        break;
                    }
                    ++n;
                }
            }
            if (foundTarget == null) {
                iAndroidTargetArray = targets;
                n2 = targets.length;
                n = 0;
                while (n < n2) {
                    existingTarget = iAndroidTargetArray[n];
                    if (existingTarget != null && projectPath.startsWith(existingTarget.getLocation())) {
                        foundTarget = existingTarget;
                        break;
                    }
                    ++n;
                }
            }
        }
        if (foundTarget != null) {
            this.target = foundTarget;
        }
    }

    public static enum Mode {
        SAMPLE,
        TEST,
        ANY;

    }
}

