/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.exportgradle;

import com.android.annotations.NonNull;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ExportMessages;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ExportStatus;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.GradleModule;
import com.android.ide.eclipse.adt.internal.wizards.exportgradle.ProjectSetupBuilder;
import com.android.ide.eclipse.adt.io.IFolderWrapper;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.sdklib.io.FileOp;
import com.android.xml.AndroidManifest;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class BuildFileCreator {
    static final String BUILD_FILE = "build.gradle";
    static final String SETTINGS_FILE = "settings.gradle";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String GRADLE_WRAPPER_LOCATION = "tools/templates/gradle/wrapper";
    static final String PLUGIN_CLASSPATH = "classpath 'com.android.tools.build:gradle:0.5.+'";
    static final String MAVEN_REPOSITORY = "mavenCentral()";
    private static final String[] GRADLE_WRAPPER_FILES = new String[]{"gradlew", "gradlew.bat", "gradle/wrapper/gradle-wrapper.jar", "gradle/wrapper/gradle-wrapper.properties"};
    private static final Comparator<IFile> FILE_COMPARATOR = new Comparator<IFile>(){

        @Override
        public int compare(IFile o1, IFile o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private final GradleModule mModule;
    private final StringBuilder mBuildFile = new StringBuilder();

    public static void createBuildFiles(@NonNull ProjectSetupBuilder builder, @NonNull Shell shell, @NonNull IProgressMonitor pm) {
        File gradleLocation = new File(Sdk.getCurrent().getSdkLocation(), GRADLE_WRAPPER_LOCATION);
        SubMonitor localmonitor = null;
        try {
            IPath settingsGradle;
            IFile iFile;
            IWorkspaceRoot workspaceRoot;
            IPath workspaceLocation;
            boolean hasGradleWrapper = true;
            for (File wrapperFile : BuildFileCreator.getGradleWrapperFiles(gradleLocation)) {
                if (wrapperFile.exists()) continue;
                hasGradleWrapper = false;
            }
            Collection<GradleModule> modules = builder.getModules();
            boolean multiModules = modules.size() > 1;
            ArrayList<IFile> files = new ArrayList<IFile>();
            for (GradleModule module : modules) {
                IFile file = module.getProject().getFile(BUILD_FILE);
                files.add(file);
            }
            IPath commonRoot = builder.getCommonRoot();
            IPath relativePath = commonRoot.makeRelativeTo(workspaceLocation = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getLocation());
            boolean rootInWorkspace = !relativePath.equals((Object)commonRoot);
            rootInWorkspace = rootInWorkspace && relativePath.segmentCount() > 0;
            File settingsFile = new File(commonRoot.toFile(), SETTINGS_FILE);
            if (multiModules && rootInWorkspace && (iFile = workspaceRoot.getFile(settingsGradle = Path.fromOSString((String)settingsFile.getAbsolutePath()))) != null) {
                files.add(iFile);
            }
            if (hasGradleWrapper && rootInWorkspace) {
                for (File wrapperFile : BuildFileCreator.getGradleWrapperFiles(commonRoot.toFile())) {
                    if (wrapperFile.exists()) continue;
                    IPath path = Path.fromOSString((String)wrapperFile.getAbsolutePath());
                    IFile file = workspaceRoot.getFile(path);
                    files.add(file);
                }
            }
            ExportStatus status = new ExportStatus();
            builder.setStatus(status);
            Set<IFile> confirmedFiles = BuildFileCreator.validateEdit(files, status, shell);
            if (status.hasError()) {
                return;
            }
            localmonitor = SubMonitor.convert((IProgressMonitor)pm, (String)ExportMessages.PageTitle, (int)confirmedFiles.size());
            ArrayList projectSettingsPath = Lists.newArrayList();
            for (GradleModule currentModule : modules) {
                IProject moduleProject = currentModule.getProject();
                IFile file = moduleProject.getFile(BUILD_FILE);
                if (!confirmedFiles.contains(file)) continue;
                localmonitor.setTaskName(NLS.bind((String)ExportMessages.FileStatusMessage, (Object)moduleProject.getName()));
                ProjectState projectState = Sdk.getProjectState(moduleProject);
                BuildFileCreator instance = new BuildFileCreator(currentModule, shell);
                if (projectState != null) {
                    if (!multiModules) {
                        instance.appendBuildScript();
                    }
                    instance.appendHeader(projectState.isLibrary());
                    instance.appendDependencies();
                    instance.startAndroidTask(projectState);
                    instance.createAndroidSourceSets();
                    instance.finishAndroidTask();
                } else {
                    instance.appendJavaHeader();
                    instance.createJavaSourceSets();
                }
                try {
                    String buildfile = instance.mBuildFile.toString();
                    ByteArrayInputStream is = new ByteArrayInputStream(buildfile.getBytes("UTF-8"));
                    if (file.exists()) {
                        file.setContents((InputStream)is, true, true, null);
                    } else {
                        file.create((InputStream)is, true, null);
                    }
                }
                catch (Exception e) {
                    status.addFileStatus(ExportStatus.FileStatus.IO_FAILURE, file.getLocation().toFile());
                    status.setErrorMessage(e.getMessage());
                    if (localmonitor != null && !localmonitor.isCanceled()) {
                        localmonitor.done();
                    }
                    if (pm != null) {
                        pm.done();
                    }
                    return;
                }
                if (localmonitor.isCanceled()) {
                    return;
                }
                localmonitor.worked(1);
                projectSettingsPath.add(currentModule.getPath());
            }
            if (multiModules) {
                try {
                    BuildFileCreator.writeGradleSettingsFile(settingsFile, projectSettingsPath);
                }
                catch (IOException e) {
                    status.addFileStatus(ExportStatus.FileStatus.IO_FAILURE, settingsFile);
                    status.setErrorMessage(e.getMessage());
                    if (localmonitor != null && !localmonitor.isCanceled()) {
                        localmonitor.done();
                    }
                    if (pm != null) {
                        pm.done();
                    }
                    return;
                }
                File mainBuildFile = new File(commonRoot.toFile(), BUILD_FILE);
                try {
                    BuildFileCreator.writeRootBuildGradle(mainBuildFile);
                }
                catch (IOException e) {
                    status.addFileStatus(ExportStatus.FileStatus.IO_FAILURE, mainBuildFile);
                    status.setErrorMessage(e.getMessage());
                    if (localmonitor != null && !localmonitor.isCanceled()) {
                        localmonitor.done();
                    }
                    if (pm != null) {
                        pm.done();
                    }
                    return;
                }
            }
            if (hasGradleWrapper) {
                BuildFileCreator.copyGradleWrapper(gradleLocation, commonRoot.toFile(), status);
                if (status.hasError()) {
                    return;
                }
            }
        }
        finally {
            if (localmonitor != null && !localmonitor.isCanceled()) {
                localmonitor.done();
            }
            if (pm != null) {
                pm.done();
            }
        }
    }

    private BuildFileCreator(GradleModule module, Shell shell) {
        this.mModule = module;
    }

    private static List<File> getGradleWrapperFiles(File root) {
        ArrayList<File> files = new ArrayList<File>(GRADLE_WRAPPER_FILES.length);
        String[] stringArray = GRADLE_WRAPPER_FILES;
        int n = GRADLE_WRAPPER_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            files.add(new File(root, file));
            ++n2;
        }
        return files;
    }

    private static void copyGradleWrapper(File from, File to, ExportStatus status) {
        String[] stringArray = GRADLE_WRAPPER_FILES;
        int n = GRADLE_WRAPPER_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File dest = new File(to, file);
            try {
                File src = new File(from, file);
                dest.getParentFile().mkdirs();
                new FileOp().copyFile(src, dest);
                dest.setExecutable(src.canExecute());
                status.addFileStatus(ExportStatus.FileStatus.OK, dest);
            }
            catch (IOException iOException) {
                status.addFileStatus(ExportStatus.FileStatus.IO_FAILURE, dest);
                return;
            }
            ++n2;
        }
    }

    private void appendBuildScript() {
        BuildFileCreator.appendBuildScript(this.mBuildFile);
    }

    private static void appendBuildScript(StringBuilder builder) {
        builder.append("buildscript {\n");
        builder.append("    repositories {\n");
        builder.append("        mavenCentral()\n");
        builder.append("    }\n");
        builder.append("    dependencies {\n");
        builder.append("        classpath 'com.android.tools.build:gradle:0.5.+'\n");
        builder.append("    }\n");
        builder.append("}\n");
    }

    private void appendHeader(boolean isLibrary) {
        if (isLibrary) {
            this.mBuildFile.append("apply plugin: 'android-library'\n");
        } else {
            this.mBuildFile.append("apply plugin: 'android'\n");
        }
        this.mBuildFile.append("\n");
    }

    private void appendDependencies() {
        this.mBuildFile.append("dependencies {\n");
        this.mBuildFile.append("    compile fileTree(dir: 'libs', include: '*.jar')\n");
        for (GradleModule dep : this.mModule.getDependencies()) {
            this.mBuildFile.append("    compile project('" + dep.getPath() + "')\n");
        }
        this.mBuildFile.append("}\n");
        this.mBuildFile.append("\n");
    }

    private void startAndroidTask(ProjectState projectState) {
        int buildApi = projectState.getTarget().getVersion().getApiLevel();
        String toolsVersion = projectState.getTarget().getBuildToolInfo().getRevision().toString();
        this.mBuildFile.append("android {\n");
        this.mBuildFile.append("    compileSdkVersion " + buildApi + "\n");
        this.mBuildFile.append("    buildToolsVersion \"" + toolsVersion + "\"\n");
        this.mBuildFile.append("\n");
    }

    private void createAndroidSourceSets() {
        IFolderWrapper projectFolder = new IFolderWrapper((IContainer)this.mModule.getProject());
        IAbstractFile mManifestFile = AndroidManifest.getManifest((IAbstractFolder)projectFolder);
        if (mManifestFile == null) {
            return;
        }
        ArrayList<String> srcDirs = new ArrayList<String>();
        IClasspathEntry[] iClasspathEntryArray = this.mModule.getJavaProject().readRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && !"gen".equals(entry.getPath().lastSegment())) {
                IPath path = entry.getPath().removeFirstSegments(1);
                srcDirs.add("'" + path.toOSString() + "'");
            }
            ++n2;
        }
        String srcPaths = Joiner.on((String)",").join(srcDirs);
        this.mBuildFile.append("    sourceSets {\n");
        this.mBuildFile.append("        main {\n");
        this.mBuildFile.append("            manifest.srcFile 'AndroidManifest.xml'\n");
        this.mBuildFile.append("            java.srcDirs = [" + srcPaths + "]\n");
        this.mBuildFile.append("            resources.srcDirs = [" + srcPaths + "]\n");
        this.mBuildFile.append("            aidl.srcDirs = [" + srcPaths + "]\n");
        this.mBuildFile.append("            renderscript.srcDirs = [" + srcPaths + "]\n");
        this.mBuildFile.append("            res.srcDirs = ['res']\n");
        this.mBuildFile.append("            assets.srcDirs = ['assets']\n");
        this.mBuildFile.append("        }\n");
        this.mBuildFile.append("\n");
        this.mBuildFile.append("        // Move the tests to tests/java, tests/res, etc...\n");
        this.mBuildFile.append("        instrumentTest.setRoot('tests')\n");
        if (srcDirs.contains("'src'")) {
            this.mBuildFile.append("\n");
            this.mBuildFile.append("        // Move the build types to build-types/<type>\n");
            this.mBuildFile.append("        // For instance, build-types/debug/java, build-types/debug/AndroidManifest.xml, ...\n");
            this.mBuildFile.append("        // This moves them out of them default location under src/<type>/... which would\n");
            this.mBuildFile.append("        // conflict with src/ being used by the main source set.\n");
            this.mBuildFile.append("        // Adding new build types or product flavors should be accompanied\n");
            this.mBuildFile.append("        // by a similar customization.\n");
            this.mBuildFile.append("        debug.setRoot('build-types/debug')\n");
            this.mBuildFile.append("        release.setRoot('build-types/release')\n");
        }
        this.mBuildFile.append("    }\n");
    }

    private void finishAndroidTask() {
        this.mBuildFile.append("}\n");
    }

    private void appendJavaHeader() {
        this.mBuildFile.append("apply plugin: 'java'\n");
    }

    private void createJavaSourceSets() {
        ArrayList<String> dirs = new ArrayList<String>();
        IClasspathEntry[] iClasspathEntryArray = this.mModule.getJavaProject().readRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                IPath path = entry.getPath().removeFirstSegments(1);
                dirs.add("'" + path.toOSString() + "'");
            }
            ++n2;
        }
        String srcPaths = Joiner.on((String)",").join(dirs);
        this.mBuildFile.append("sourceSets {\n");
        this.mBuildFile.append("    main.java.srcDirs = [" + srcPaths + "]\n");
        this.mBuildFile.append("    main.resources.srcDirs = [" + srcPaths + "]\n");
        this.mBuildFile.append("    test.java.srcDirs = ['tests/java']\n");
        this.mBuildFile.append("    test.resources.srcDirs = ['tests/resources']\n");
        this.mBuildFile.append("}\n");
    }

    private static void writeGradleSettingsFile(File settingsFile, List<String> projectPaths) throws IOException {
        StringBuilder contents = new StringBuilder();
        for (String path : projectPaths) {
            contents.append("include '").append(path).append("'\n");
        }
        Files.write((CharSequence)contents.toString(), (File)settingsFile, (Charset)Charsets.UTF_8);
    }

    private static void writeRootBuildGradle(File buildFile) throws IOException {
        StringBuilder sb = new StringBuilder("// Top-level build file where you can add configuration options common to all sub-projects/modules.\n");
        BuildFileCreator.appendBuildScript(sb);
        Files.write((CharSequence)sb.toString(), (File)buildFile, (Charset)Charsets.UTF_8);
    }

    static Set<IFile> validateEdit(@NonNull List<IFile> files, @NonNull ExportStatus exportStatus, @NonNull Shell shell) {
        TreeSet<IFile> confirmedFiles = new TreeSet<IFile>(FILE_COMPARATOR);
        if (files.size() == 0) {
            return confirmedFiles;
        }
        IStatus status = files.get(0).getWorkspace().validateEdit(files.toArray(new IFile[files.size()]), (Object)shell);
        if (status.isMultiStatus() && status.getChildren().length > 0) {
            int i = 0;
            while (i < status.getChildren().length) {
                IStatus statusChild = status.getChildren()[i];
                if (statusChild.isOK()) {
                    confirmedFiles.add(files.get(i));
                } else {
                    exportStatus.addFileStatus(ExportStatus.FileStatus.VCS_FAILURE, files.get(i).getLocation().toFile());
                }
                ++i;
            }
        } else if (status.isOK()) {
            confirmedFiles.addAll(files);
        }
        if (status.getSeverity() == 4) {
            StringBuffer message = new StringBuffer(String.valueOf(status.getPlugin()) + ": " + status.getMessage() + NEWLINE);
            if (status.isMultiStatus()) {
                int i = 0;
                while (i < status.getChildren().length) {
                    IStatus statusChild = status.getChildren()[i];
                    message.append(String.valueOf(statusChild.getMessage()) + NEWLINE);
                    ++i;
                }
            }
            String s = message.toString();
            exportStatus.setErrorMessage(s);
        }
        return confirmedFiles;
    }
}

