/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.ui;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.assetstudio.OpenCreateAssetSetWizardAction;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.PropertyFactory;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringWizard;
import com.android.ide.eclipse.adt.internal.resources.ResourceHelper;
import com.android.ide.eclipse.adt.internal.resources.ResourceNameValidator;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.ui.ResourceLabelProvider;
import com.android.ide.eclipse.adt.internal.ui.ResourcePreviewHelper;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ResourceChooser
extends AbstractElementListSelectionDialog
implements ModifyListener {
    public static final int CLEAR_RETURN_CODE = -5;
    private static final int CLEAR_BUTTON_ID = -5;
    private Pattern mProjectResourcePattern;
    private ResourceType mResourceType;
    private final List<ResourceRepository> mProjectResources;
    private final ResourceRepository mFrameworkResources;
    private Pattern mSystemResourcePattern;
    private Button mProjectButton;
    private Button mSystemButton;
    private Button mNewButton;
    private String mCurrentResource;
    private final IProject mProject;
    private IInputValidator mInputValidator;
    private ResourcePreviewHelper mPreviewHelper;
    private Text mEditValueText;
    private boolean mShowValueText;
    private boolean mFirstSelect = true;
    private Label mResolvedLabel;
    private ResourceResolver mResourceResolver;

    private ResourceChooser(@NonNull IProject project, @NonNull ResourceType type, @NonNull List<ResourceRepository> projectResources, @Nullable ResourceRepository frameworkResources, @NonNull Shell parent) {
        super(parent, (ILabelProvider)new ResourceLabelProvider());
        this.mProject = project;
        this.mResourceType = type;
        this.mProjectResources = projectResources;
        this.mFrameworkResources = frameworkResources;
        this.mProjectResourcePattern = Pattern.compile("@" + this.mResourceType.getName() + "/(.+)");
        this.mSystemResourcePattern = Pattern.compile("@android:" + this.mResourceType.getName() + "/(.+)");
        this.setTitle("Resource Chooser");
        this.setMessage(String.format("Choose a %1$s resource", this.mResourceType.getDisplayName().toLowerCase(Locale.US)));
    }

    @NonNull
    public static ResourceChooser create(@NonNull GraphicalEditorPart editor, @NonNull ResourceType type) {
        IProject project = editor.getProject();
        Shell parent = editor.getCanvasControl().getShell();
        AndroidTargetData targetData = editor.getEditorDelegate().getEditor().getTargetData();
        ResourceChooser chooser = ResourceChooser.create(project, type, targetData, parent);
        if (type == ResourceType.STRING) {
            chooser.setResourceResolver(editor.getResourceResolver());
            chooser.setShowValueText(true);
        } else if (type == ResourceType.DIMEN || type == ResourceType.INTEGER) {
            chooser.setResourceResolver(editor.getResourceResolver());
        }
        chooser.setPreviewHelper(new ResourcePreviewHelper((TrayDialog)chooser, editor));
        return chooser;
    }

    @NonNull
    public static ResourceChooser create(@NonNull IProject project, @NonNull ResourceType type, @Nullable AndroidTargetData targetData, @NonNull Shell parent) {
        List<IProject> libraries;
        ResourceManager manager = ResourceManager.getInstance();
        ArrayList<ResourceRepository> projectResources = new ArrayList<ResourceRepository>();
        ProjectResources resources = manager.getProjectResources(project);
        projectResources.add(resources);
        ProjectState projectState = Sdk.getProjectState(project);
        if (projectState != null && (libraries = projectState.getFullLibraryProjects()) != null && !libraries.isEmpty()) {
            for (IProject library : libraries) {
                projectResources.add(manager.getProjectResources(library));
            }
        }
        ResourceRepository frameworkResources = targetData != null ? targetData.getFrameworkResources() : null;
        return new ResourceChooser(project, type, projectResources, frameworkResources, parent);
    }

    public ResourceChooser setShowValueText(boolean showValueText) {
        this.mShowValueText = showValueText;
        return this;
    }

    public ResourceChooser setResourceResolver(ResourceResolver resourceResolver) {
        this.mResourceResolver = resourceResolver;
        return this;
    }

    public ResourceChooser setPreviewHelper(ResourcePreviewHelper previewHelper) {
        this.mPreviewHelper = previewHelper;
        return this;
    }

    public ResourceChooser setInitialSize(int width, int height) {
        this.setSize(width, height);
        return this;
    }

    public void create() {
        super.create();
        if (this.mShowValueText) {
            this.mEditValueText.selectAll();
            this.mEditValueText.setFocus();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, -5, "Clear", false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == -5) {
            this.setReturnCode(-5);
            this.close();
        }
    }

    public ResourceChooser setCurrentResource(@Nullable String resource) {
        this.mCurrentResource = resource;
        if (this.mShowValueText && this.mEditValueText != null) {
            this.mEditValueText.setText(resource);
        }
        return this;
    }

    @Nullable
    public String getCurrentResource() {
        return this.mCurrentResource;
    }

    public ResourceChooser setInputValidator(@Nullable IInputValidator inputValidator) {
        this.mInputValidator = inputValidator;
        return this;
    }

    protected void computeResult() {
        if (this.mShowValueText) {
            this.mCurrentResource = this.mEditValueText.getText();
            if (this.mCurrentResource.length() == 0) {
                this.mCurrentResource = null;
            }
            return;
        }
        this.computeResultFromSelection();
    }

    private void computeResultFromSelection() {
        if (this.getSelectionIndex() == -1) {
            this.mCurrentResource = null;
            return;
        }
        Object[] elements = this.getSelectedElements();
        if (elements.length == 1 && elements[0] instanceof ResourceItem) {
            ResourceItem item = (ResourceItem)elements[0];
            this.mCurrentResource = item.getXmlString(this.mResourceType, this.mSystemButton.getSelection());
            if (this.mInputValidator != null && this.mInputValidator.isValid(this.mCurrentResource) != null) {
                this.mCurrentResource = null;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        this.createMessageArea(top);
        this.createButtons(top);
        this.createFilterText(top);
        this.createFilteredList(top);
        this.createNewResButtons(top);
        this.createValueField(top);
        this.setupResourceList();
        this.selectResourceString(this.mCurrentResource);
        return top;
    }

    private void createButtons(Composite top) {
        this.mProjectButton = new Button(top, 16);
        this.mProjectButton.setText("Project Resources");
        this.mProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (ResourceChooser.this.mProjectButton.getSelection()) {
                    ResourceChooser.this.fFilteredList.setSelection(new int[0]);
                    ResourceChooser.this.setupResourceList();
                    ResourceChooser.this.updateNewButton(false);
                    ResourceChooser.this.updateValue();
                }
            }
        });
        this.mSystemButton = new Button(top, 16);
        this.mSystemButton.setText("System Resources");
        this.mSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (ResourceChooser.this.mSystemButton.getSelection()) {
                    ResourceChooser.this.fFilteredList.setSelection(new int[0]);
                    ResourceChooser.this.setupResourceList();
                    ResourceChooser.this.updateNewButton(true);
                    ResourceChooser.this.updateValue();
                }
            }
        });
        if (this.mFrameworkResources == null) {
            this.mSystemButton.setVisible(false);
        }
    }

    private void createNewResButtons(Composite top) {
        this.mNewButton = new Button(top, 0);
        String title = String.format("New %1$s...", this.mResourceType.getDisplayName());
        if (this.mResourceType == ResourceType.DRAWABLE) {
            title = "Create New Icon...";
        }
        this.mNewButton.setText(title);
        this.mNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (ResourceChooser.this.mResourceType == ResourceType.STRING) {
                    String newName = ResourceChooser.this.createNewString();
                    this.selectAddedItem(newName);
                } else if (ResourceChooser.this.mResourceType == ResourceType.DRAWABLE) {
                    OpenCreateAssetSetWizardAction action = new OpenCreateAssetSetWizardAction(ResourceChooser.this.mProject);
                    action.run();
                    List<IResource> files = action.getCreatedFiles();
                    if (files != null && files.size() > 0) {
                        String newName = AdtUtils.stripAllExtensions(files.get(0).getName());
                        ResourceItem[] items = ResourceChooser.this.setupResourceList();
                        ResourceChooser.this.selectItemName(newName, items);
                    }
                } else if (ResourceHelper.isValueBasedResourceType(ResourceChooser.this.mResourceType)) {
                    String newName = ResourceChooser.this.createNewValue(ResourceChooser.this.mResourceType);
                    if (newName != null) {
                        this.selectAddedItem(newName);
                    }
                } else {
                    String newName = ResourceChooser.this.createNewFile(ResourceChooser.this.mResourceType);
                    if (newName != null) {
                        this.selectAddedItem(newName);
                    }
                }
            }

            private void selectAddedItem(@NonNull String newName) {
                Object[] items = ResourceChooser.this.setupResourceList();
                boolean found = false;
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceItem item = objectArray[n2];
                    if (newName.equals(item.getName())) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    ResourceItem[] newItems = new ResourceItem[items.length + 1];
                    System.arraycopy(items, 0, newItems, 0, items.length);
                    newItems[items.length] = new ResourceItem(newName);
                    items = newItems;
                    Arrays.sort(items);
                    ResourceChooser.this.setListElements(items);
                    ResourceChooser.this.fFilteredList.setEnabled(newItems.length > 0);
                }
                ResourceChooser.this.selectItemName(newName, (ResourceItem[])items);
            }
        });
    }

    private void createValueField(Composite top) {
        Composite workaround;
        GridData data;
        if (this.mShowValueText) {
            this.mEditValueText = new Text(top, 2048);
            if (this.mCurrentResource != null) {
                this.mEditValueText.setText(this.mCurrentResource);
            }
            this.mEditValueText.addModifyListener((ModifyListener)this);
            data = new GridData();
            data.grabExcessVerticalSpace = false;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            this.mEditValueText.setLayoutData((Object)data);
            this.mEditValueText.setFont(top.getFont());
        }
        if (this.mResourceResolver != null) {
            this.mResolvedLabel = new Label(top, 0);
            data = new GridData();
            data.grabExcessVerticalSpace = false;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            this.mResolvedLabel.setLayoutData((Object)data);
        }
        if ((workaround = PropertyFactory.addWorkaround(top)) != null) {
            workaround.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        }
    }

    private void updateResolvedLabel() {
        if (this.mResourceResolver == null) {
            return;
        }
        String v = null;
        if (this.mCurrentResource != null) {
            ResourceValue value;
            v = this.mCurrentResource;
            if (this.mCurrentResource.startsWith("@") && (value = this.mResourceResolver.findResValue(this.mCurrentResource, false)) != null) {
                v = value.getValue();
            }
        }
        if (v == null) {
            v = "";
        }
        this.mResolvedLabel.setText(String.format("Resolved Value: %1$s", v));
    }

    protected void handleSelectionChanged() {
        Object[] elements;
        super.handleSelectionChanged();
        if (this.mInputValidator != null && (elements = this.getSelectedElements()).length == 1 && elements[0] instanceof ResourceItem) {
            ResourceItem item = (ResourceItem)elements[0];
            String current = item.getXmlString(this.mResourceType, this.mSystemButton.getSelection());
            String error = this.mInputValidator.isValid(current);
            Status status = error != null ? new Status(4, "com.android.ide.eclipse.adt", error) : new Status(0, "com.android.ide.eclipse.adt", null);
            this.updateStatus((IStatus)status);
        }
        this.updateValue();
    }

    private void updateValue() {
        if (this.mPreviewHelper != null) {
            this.computeResult();
            this.mPreviewHelper.updatePreview(this.mResourceType, this.mCurrentResource);
        }
        if (this.mShowValueText) {
            if (this.mFirstSelect) {
                this.mFirstSelect = false;
                this.mEditValueText.selectAll();
            } else {
                this.computeResultFromSelection();
                this.mEditValueText.setText(this.mCurrentResource != null ? this.mCurrentResource : "");
            }
        }
        if (this.mResourceResolver != null) {
            if (!this.mShowValueText) {
                this.computeResultFromSelection();
            }
            this.updateResolvedLabel();
        }
    }

    @Nullable
    private String createNewFile(ResourceType type) {
        Shell shell = AdtPlugin.getShell();
        if (shell == null) {
            return null;
        }
        ResourceNameValidator validator = ResourceNameValidator.create(true, this.mProject, this.mResourceType);
        InputDialog d = new InputDialog(AdtPlugin.getShell(), "Enter name", "Enter name", "", (IInputValidator)validator);
        if (d.open() == 0) {
            String name = d.getValue().trim();
            if (name.length() == 0) {
                return null;
            }
            Pair<IFile, IRegion> resource = ResourceHelper.createResource(this.mProject, type, name, null);
            if (resource != null) {
                return name;
            }
        }
        return null;
    }

    @Nullable
    private String createNewValue(ResourceType type) {
        Shell shell = AdtPlugin.getShell();
        if (shell == null) {
            return null;
        }
        NameValueDialog dialog = new NameValueDialog(shell, this.getFilter());
        if (dialog.open() != 0) {
            return null;
        }
        String name = dialog.getName();
        String value = dialog.getValue();
        if (name.length() == 0 || value.length() == 0) {
            return null;
        }
        Pair<IFile, IRegion> resource = ResourceHelper.createResource(this.mProject, type, name, value);
        if (resource != null) {
            return name;
        }
        return null;
    }

    private String createNewString() {
        ExtractStringRefactoring ref = new ExtractStringRefactoring(this.mProject, true);
        ExtractStringWizard wizard = new ExtractStringWizard(ref, this.mProject);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            IWorkbench w = PlatformUI.getWorkbench();
            if (op.run(w.getDisplay().getActiveShell(), wizard.getDefaultPageTitle()) == 0) {
                return ref.getXmlStringId();
            }
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private ResourceItem[] setupResourceList() {
        Collection<Object> items = null;
        if (this.mProjectButton.getSelection()) {
            if (this.mProjectResources.size() == 1) {
                items = this.mProjectResources.get(0).getResourceItemsOfType(this.mResourceType);
            } else {
                HashMap merged = Maps.newHashMapWithExpectedSize((int)200);
                for (ResourceRepository repository : this.mProjectResources) {
                    for (ResourceItem item : repository.getResourceItemsOfType(this.mResourceType)) {
                        if (merged.containsKey(item.getName())) continue;
                        merged.put(item.getName(), item);
                    }
                }
                items = merged.values();
            }
        } else if (this.mSystemButton.getSelection()) {
            items = this.mFrameworkResources.getResourceItemsOfType(this.mResourceType);
        }
        if (items == null) {
            items = Collections.emptyList();
        }
        Object[] arrayItems = items.toArray(new ResourceItem[items.size()]);
        Arrays.sort(arrayItems);
        this.setListElements(arrayItems);
        this.fFilteredList.setEnabled(arrayItems.length > 0);
        return arrayItems;
    }

    private void selectItemName(String itemName, ResourceItem[] items) {
        if (itemName == null || items == null) {
            return;
        }
        ResourceItem[] resourceItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceItem item = resourceItemArray[n2];
            if (itemName.equals(item.getName())) {
                this.setSelection(new Object[]{item});
                break;
            }
            ++n2;
        }
    }

    private void selectResourceString(String resourceString) {
        boolean isSystem = false;
        String itemName = null;
        if (resourceString != null) {
            Matcher m = this.mSystemResourcePattern.matcher(resourceString);
            if (m.matches()) {
                itemName = m.group(1);
                isSystem = true;
            }
            if (!isSystem && itemName == null && (m = this.mProjectResourcePattern.matcher(resourceString)).matches()) {
                itemName = m.group(1);
            }
        }
        this.mProjectButton.setSelection(!isSystem);
        this.mSystemButton.setSelection(isSystem);
        this.updateNewButton(isSystem);
        ResourceItem[] items = this.setupResourceList();
        if (itemName != null) {
            this.selectItemName(itemName, items);
        }
    }

    private void updateNewButton(boolean isSystem) {
        this.mNewButton.setEnabled(!isSystem && ResourceHelper.canCreateResourceType(this.mResourceType));
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.mEditValueText && this.mResourceResolver != null) {
            this.mCurrentResource = this.mEditValueText.getText();
            if (this.mCurrentResource.startsWith("@")) {
                if (this.mProjectResourcePattern.matcher(this.mCurrentResource).matches() || this.mSystemResourcePattern.matcher(this.mCurrentResource).matches()) {
                    this.updateResolvedLabel();
                }
            } else {
                this.updateResolvedLabel();
            }
        }
    }

    public static String chooseResource(@NonNull GraphicalEditorPart graphicalEditor, @NonNull ResourceType type, String currentValue, IInputValidator validator) {
        int result;
        ResourceChooser chooser = ResourceChooser.create(graphicalEditor, type).setCurrentResource(currentValue);
        if (validator != null) {
            chooser.setSize(85, 10);
            chooser.setInputValidator(validator);
        }
        if ((result = chooser.open()) == -5) {
            return "";
        }
        if (result == 0) {
            return chooser.getCurrentResource();
        }
        return null;
    }

    private class NameValueDialog
    extends SelectionStatusDialog
    implements Listener {
        private Text mNameText;
        private Text mValueText;
        private String mInitialName;
        private String mName;
        private String mValue;
        private ResourceNameValidator mValidator;

        public NameValueDialog(Shell parent, String initialName) {
            super(parent);
            this.mInitialName = initialName;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            GridData gridData = new GridData(4, 4, true, true, 1, 1);
            gridData.widthHint = 500;
            container.setLayoutData((Object)gridData);
            Label nameLabel = new Label(container, 0);
            nameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            nameLabel.setText("Name:");
            this.mNameText = new Text(container, 2048);
            this.mNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            if (this.mInitialName != null) {
                this.mNameText.setText(this.mInitialName);
                this.mNameText.selectAll();
            }
            Label valueLabel = new Label(container, 0);
            valueLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            valueLabel.setText("Value:");
            this.mValueText = new Text(container, 2048);
            this.mValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.mNameText.addListener(24, (Listener)this);
            this.mValueText.addListener(24, (Listener)this);
            this.validate();
            return container;
        }

        protected void computeResult() {
            this.mName = this.mNameText.getText().trim();
            this.mValue = this.mValueText.getText().trim();
        }

        private String getName() {
            return this.mName;
        }

        private String getValue() {
            return this.mValue;
        }

        public void handleEvent(Event event) {
            this.validate();
        }

        private void validate() {
            Status status;
            this.computeResult();
            if (this.mName.length() == 0) {
                status = new Status(4, "com.android.ide.eclipse.adt", "Enter a name");
            } else if (this.mValue.length() == 0) {
                status = new Status(4, "com.android.ide.eclipse.adt", "Enter a value");
            } else {
                String error;
                if (this.mValidator == null) {
                    this.mValidator = ResourceNameValidator.create(false, ResourceChooser.this.mProject, ResourceChooser.this.mResourceType);
                }
                status = (error = this.mValidator.isValid(this.mName)) != null ? new Status(4, "com.android.ide.eclipse.adt", error) : new Status(0, "com.android.ide.eclipse.adt", null);
            }
            this.updateStatus((IStatus)status);
        }
    }
}

