/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.ui;

import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.ui.ResourceChooser;
import com.android.resources.ResourceType;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class MarginChooser
extends SelectionStatusDialog
implements Listener {
    private GraphicalEditorPart mEditor;
    private AndroidTargetData mTargetData;
    private Text mLeftField;
    private Text mRightField;
    private Text mTopField;
    private Text mBottomField;
    private Text mAllField;
    private String mInitialAll;
    private String mInitialLeft;
    private String mInitialRight;
    private String mInitialTop;
    private String mInitialBottom;
    private Label mErrorLabel;
    private String[] mMargins;
    private static final String PROP_TEXTFIELD = "textField";

    public MarginChooser(Shell parent, GraphicalEditorPart editor, AndroidTargetData targetData, String all, String left, String right, String top, String bottom) {
        super(parent);
        this.setTitle("Edit Margins");
        this.mEditor = editor;
        this.mTargetData = targetData;
        this.mInitialAll = all;
        this.mInitialLeft = left;
        this.mInitialRight = right;
        this.mInitialTop = top;
        this.mInitialBottom = bottom;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(3, false));
        Label allLabel = new Label(container, 0);
        allLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        allLabel.setText("All:");
        this.mAllField = new Text(container, 18432);
        this.mAllField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mAllField.setText(this.mInitialAll != null ? this.mInitialAll : "");
        Button allButton = new Button(container, 0);
        allButton.setText("Resource...");
        allButton.setData(PROP_TEXTFIELD, (Object)this.mAllField);
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Label leftLabel = new Label(container, 0);
        leftLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        leftLabel.setText("Left:");
        this.mLeftField = new Text(container, 18432);
        this.mLeftField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mLeftField.setText(this.mInitialLeft != null ? this.mInitialLeft : "");
        Button leftButton = new Button(container, 0);
        leftButton.setText("Resource...");
        leftButton.setData(PROP_TEXTFIELD, (Object)this.mLeftField);
        Label rightLabel = new Label(container, 0);
        rightLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        rightLabel.setText("Right:");
        this.mRightField = new Text(container, 18432);
        this.mRightField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mRightField.setText(this.mInitialRight != null ? this.mInitialRight : "");
        Button rightButton = new Button(container, 0);
        rightButton.setText("Resource...");
        rightButton.setData(PROP_TEXTFIELD, (Object)this.mRightField);
        Label topLabel = new Label(container, 0);
        topLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        topLabel.setText("Top:");
        this.mTopField = new Text(container, 18432);
        this.mTopField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mTopField.setText(this.mInitialTop != null ? this.mInitialTop : "");
        Button topButton = new Button(container, 0);
        topButton.setText("Resource...");
        topButton.setData(PROP_TEXTFIELD, (Object)this.mTopField);
        Label bottomLabel = new Label(container, 0);
        bottomLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        bottomLabel.setText("Bottom:");
        this.mBottomField = new Text(container, 18432);
        this.mBottomField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mBottomField.setText(this.mInitialBottom != null ? this.mInitialBottom : "");
        Button bottomButton = new Button(container, 0);
        bottomButton.setText("Resource...");
        bottomButton.setData(PROP_TEXTFIELD, (Object)this.mBottomField);
        allButton.addListener(13, (Listener)this);
        leftButton.addListener(13, (Listener)this);
        rightButton.addListener(13, (Listener)this);
        topButton.addListener(13, (Listener)this);
        bottomButton.addListener(13, (Listener)this);
        this.mAllField.addListener(24, (Listener)this);
        this.mLeftField.addListener(24, (Listener)this);
        this.mRightField.addListener(24, (Listener)this);
        this.mTopField.addListener(24, (Listener)this);
        this.mBottomField.addListener(24, (Listener)this);
        new Label(container, 0);
        this.mErrorLabel = new Label(container, 64);
        this.mErrorLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.mErrorLabel.setForeground(parent.getDisplay().getSystemColor(3));
        return container;
    }

    protected void computeResult() {
        this.mMargins = new String[]{this.mAllField.getText().trim(), this.mLeftField.getText().trim(), this.mRightField.getText().trim(), this.mTopField.getText().trim(), this.mBottomField.getText().trim()};
    }

    public String[] getMargins() {
        return this.mMargins;
    }

    public void handleEvent(Event event) {
        if (event.type == 24) {
            if (event.widget instanceof Text) {
                Text text = (Text)event.widget;
                String input = text.getText().trim();
                boolean isNumber = false;
                try {
                    if (Integer.parseInt(input) > 0) {
                        isNumber = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                if (isNumber) {
                    String message = String.format("Hint: Use \"%1$sdp\" instead", input);
                    this.mErrorLabel.setText(message);
                } else {
                    this.mErrorLabel.setText("");
                }
            }
        } else if (event.type == 13 && event.widget instanceof Button) {
            Button button = (Button)event.widget;
            Text text = (Text)button.getData(PROP_TEXTFIELD);
            ResourceChooser chooser = ResourceChooser.create(this.mEditor, ResourceType.DIMEN).setCurrentResource(text.getText().trim());
            if (chooser.open() == 0) {
                text.setText(chooser.getCurrentResource());
            }
        }
    }
}

