/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.renamepackage;

import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.refactorings.renamepackage.ApplicationPackageNameRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.renamepackage.ApplicationPackageNameRefactoringWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class RenamePackageAction
implements IObjectActionDelegate {
    private ISelection mSelection;
    private IWorkbenchPart mTargetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.mTargetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mSelection = selection;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.mSelection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.mSelection) {
                RefactoringSaveHelper save_helper;
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null || !(save_helper = new RefactoringSaveHelper(1)).saveEditors(AdtPlugin.getShell())) continue;
                this.promptNewName(project);
            }
        }
    }

    private void promptNewName(IProject project) {
        ManifestData manifestData = AndroidManifestHelper.parseForData(project);
        if (manifestData == null) {
            return;
        }
        final String oldPackageNameString = manifestData.getPackage();
        final AST astValidator = AST.newAST((int)3);
        Name oldPackageName = astValidator.newName(oldPackageNameString);
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                try {
                    astValidator.newName(newText);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return "Illegal package name.";
                }
                if (newText.equals(oldPackageNameString)) {
                    return "No change.";
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(AdtPlugin.getShell(), "Rename Application Package", "Enter new package name:", oldPackageNameString, validator);
        if (dialog.open() == 0) {
            Name newPackageName = astValidator.newName(dialog.getValue());
            this.initiateAndroidPackageRefactoring(project, oldPackageName, newPackageName);
        }
    }

    private void initiateAndroidPackageRefactoring(IProject project, Name oldPackageName, Name newPackageName) {
        ApplicationPackageNameRefactoring package_name_refactoring = new ApplicationPackageNameRefactoring(project, oldPackageName, newPackageName);
        ApplicationPackageNameRefactoringWizard wizard = new ApplicationPackageNameRefactoringWizard(package_name_refactoring);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            op.run(AdtPlugin.getShell(), package_name_refactoring.getName());
        }
        catch (InterruptedException e) {
            Status s = new Status(4, "com.android.ide.eclipse.adt", e.getMessage(), (Throwable)e);
            AdtPlugin.getDefault().getLog().log((IStatus)s);
        }
    }
}

