/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.extractstring;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.XmlStringFileHelper;
import com.android.ide.eclipse.adt.internal.ui.ConfigurationSelector;
import com.android.resources.ResourceFolderType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class ExtractStringInputPage
extends UserInputWizardPage {
    private static HashMap<String, String> sLastResFilePath = new HashMap();
    private final IProject mProject;
    private Combo mStringIdCombo;
    private Text mStringValueField;
    private ConfigurationSelector mConfigSelector;
    private Combo mResFileCombo;
    private Button mReplaceAllJava;
    private Button mReplaceAllXml;
    private static final Pattern RES_XML_FILE_REGEX = Pattern.compile("/res/[a-z][a-zA-Z0-9_-]+/[^.]+\\.xml");
    private static final String RES_FOLDER_ABS = "/res/";
    private static final String RES_FOLDER_REL = "res/";
    private static final String DEFAULT_RES_FILE_PATH = "/res/values/strings.xml";
    private XmlStringFileHelper mXmlHelper = new XmlStringFileHelper();
    private final OnConfigSelectorUpdated mOnConfigSelectorUpdated = new OnConfigSelectorUpdated();
    private ModifyListener mValidateOnModify = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ExtractStringInputPage.this.validatePage();
        }
    };
    private SelectionListener mValidateOnSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ExtractStringInputPage.this.validatePage();
        }
    };

    public ExtractStringInputPage(IProject project) {
        super("ExtractStringInputPage");
        this.mProject = project;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        this.createStringGroup(content);
        this.createResFileGroup(content);
        this.createOptionGroup(content);
        this.initUi();
        this.setControl((Control)content);
    }

    public void createStringGroup(Composite content) {
        ExtractStringRefactoring ref = this.getOurRefactoring();
        Group group = new Group(content, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText("New String");
        if (ref.getMode() == ExtractStringRefactoring.Mode.EDIT_SOURCE) {
            group.setText("String Replacement");
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("&String");
        String selectedString = ref.getTokenString();
        this.mStringValueField = new Text((Composite)group, 18436);
        this.mStringValueField.setLayoutData((Object)new GridData(768));
        this.mStringValueField.setText(selectedString != null ? selectedString : "");
        ref.setNewStringValue(this.mStringValueField.getText());
        this.mStringValueField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractStringInputPage.this.validatePage();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("ID &R.string.");
        if (ref.getMode() == ExtractStringRefactoring.Mode.EDIT_SOURCE) {
            label.setText("&Replace by R.string.");
        } else if (ref.getMode() == ExtractStringRefactoring.Mode.SELECT_NEW_ID) {
            label.setText("New &R.string.");
        }
        this.mStringIdCombo = new Combo((Composite)group, 18436);
        this.mStringIdCombo.setLayoutData((Object)new GridData(768));
        this.mStringIdCombo.setText(ExtractStringInputPage.guessId(selectedString));
        this.mStringIdCombo.forceFocus();
        ref.setNewStringId(this.mStringIdCombo.getText().trim());
        this.mStringIdCombo.addModifyListener(this.mValidateOnModify);
        this.mStringIdCombo.addSelectionListener(this.mValidateOnSelection);
    }

    private void createResFileGroup(Composite content) {
        Group group = new Group(content, 0);
        GridData gd = new GridData(768);
        gd.grabExcessVerticalSpace = true;
        group.setLayoutData((Object)gd);
        group.setText("XML resource to edit");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("&Configuration:");
        this.mConfigSelector = new ConfigurationSelector((Composite)group, ConfigurationSelector.SelectorMode.DEFAULT);
        gd = new GridData(1536);
        gd.horizontalSpan = 2;
        gd.widthHint = 600;
        gd.heightHint = 250;
        this.mConfigSelector.setLayoutData(gd);
        this.mConfigSelector.setOnChangeListener(this.mOnConfigSelectorUpdated);
        label = new Label((Composite)group, 0);
        label.setText("Resource &file:");
        this.mResFileCombo = new Combo((Composite)group, 4);
        this.mResFileCombo.select(0);
        this.mResFileCombo.setLayoutData((Object)new GridData(768));
        this.mResFileCombo.addModifyListener((ModifyListener)this.mOnConfigSelectorUpdated);
    }

    private void createOptionGroup(Composite content) {
        Group options = new Group(content, 0);
        options.setText("Options");
        GridData gd_Options = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_Options.widthHint = 77;
        options.setLayoutData((Object)gd_Options);
        options.setLayout((Layout)new GridLayout(1, false));
        this.mReplaceAllJava = new Button((Composite)options, 32);
        this.mReplaceAllJava.setToolTipText("When checked, the exact same string literal will be replaced in all Java files.");
        this.mReplaceAllJava.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mReplaceAllJava.setText("Replace in all &Java files");
        this.mReplaceAllJava.addSelectionListener(this.mValidateOnSelection);
        this.mReplaceAllXml = new Button((Composite)options, 32);
        this.mReplaceAllXml.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mReplaceAllXml.setToolTipText("When checked, string literals will be replaced in other XML resource files having the same name but located in different resource configuration folders.");
        this.mReplaceAllXml.setText("Replace in all &XML files for different configuration");
        this.mReplaceAllXml.addSelectionListener(this.mValidateOnSelection);
    }

    private void initUi() {
        String projPath = this.mProject.getFullPath().toPortableString();
        String filePath = sLastResFilePath.get(projPath);
        this.mResFileCombo.setText(filePath != null ? filePath : DEFAULT_RES_FILE_PATH);
        this.mOnConfigSelectorUpdated.run();
        this.validatePage();
    }

    public static String guessId(String text) {
        if (text == null) {
            return "";
        }
        text = text.toLowerCase(Locale.US);
        if ((text = text.replaceAll("[^a-zA-Z0-9]+", "_")).length() > 0 && !Character.isJavaIdentifierStart(text.charAt(0))) {
            text = "_" + text;
        }
        return text;
    }

    private ExtractStringRefactoring getOurRefactoring() {
        return (ExtractStringRefactoring)this.getRefactoring();
    }

    private boolean validatePage() {
        boolean success = true;
        ExtractStringRefactoring ref = this.getOurRefactoring();
        ref.setReplaceAllJava(this.mReplaceAllJava.getSelection());
        ref.setReplaceAllXml(this.mReplaceAllXml.isEnabled() && this.mReplaceAllXml.getSelection());
        String text = this.mStringIdCombo.getText().trim();
        if (text == null || text.length() < 1) {
            this.setErrorMessage("Please provide a resource ID.");
            success = false;
        } else {
            int i = 0;
            while (i < text.length()) {
                boolean ok;
                char c = text.charAt(i);
                boolean bl = ok = i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
                if (!ok) {
                    this.setErrorMessage(String.format("The resource ID must be a valid Java identifier. The character %1$c at position %2$d is not acceptable.", Character.valueOf(c), i + 1));
                    success = false;
                    break;
                }
                ++i;
            }
            if (success) {
                ref.setNewStringId(text);
            }
        }
        String resFile = this.mResFileCombo.getText();
        if (success) {
            if (resFile == null || resFile.length() == 0) {
                this.setErrorMessage("A resource file name is required.");
                success = false;
            } else if (!RES_XML_FILE_REGEX.matcher(resFile).matches()) {
                this.setErrorMessage("The XML file name is not valid.");
                success = false;
            }
        }
        if (success) {
            this.setErrorMessage(null);
            ref.setTargetFile(resFile);
            sLastResFilePath.put(this.mProject.getFullPath().toPortableString(), resFile);
            String idValue = this.mXmlHelper.valueOfStringId(this.mProject, resFile, text);
            if (idValue != null) {
                String msg = String.format("%1$s already contains a string ID '%2$s' with value '%3$s'.", resFile, text, idValue);
                if (ref.getMode() == ExtractStringRefactoring.Mode.SELECT_NEW_ID) {
                    this.setErrorMessage(msg);
                    success = false;
                } else {
                    this.setMessage(msg, 2);
                }
            } else if (this.mProject.findMember(resFile) == null) {
                this.setMessage(String.format("File %2$s does not exist and will be created.", text, resFile), 1);
            } else {
                this.setMessage(null);
            }
        }
        if (success) {
            ref.setNewStringValue(this.mStringValueField.getText());
        }
        this.setPageComplete(success);
        return success;
    }

    private void updateStringValueCombo() {
        String resFile = this.mResFileCombo.getText();
        Map<String, String> ids = this.mXmlHelper.getResIdsForFile(this.mProject, resFile);
        String currText = this.mStringIdCombo.getText();
        this.mStringIdCombo.removeAll();
        this.mStringIdCombo.setItems(ids.keySet().toArray(new String[ids.size()]));
        if (!currText.equals(this.mStringIdCombo.getText())) {
            this.mStringIdCombo.setText(currText);
        }
    }

    private class OnConfigSelectorUpdated
    implements Runnable,
    ModifyListener {
        private final Pattern mPathRegex = Pattern.compile("(/res/[a-z][a-zA-Z0-9_-]+/)(.+)");
        private FolderConfiguration mTempConfig = new FolderConfiguration();
        private HashMap<String, TreeSet<String>> mFolderCache = new HashMap();
        private String mLastFolderUsedInCombo = null;
        private boolean mInternalConfigChange;
        private boolean mInternalFileComboChange;

        private OnConfigSelectorUpdated() {
        }

        @Override
        public void run() {
            if (this.mInternalConfigChange) {
                return;
            }
            String leafName = "";
            String currPath = ExtractStringInputPage.this.mResFileCombo.getText();
            Matcher m = this.mPathRegex.matcher(currPath);
            if (m.matches()) {
                leafName = m.group(2);
                currPath = m.group(1);
            } else {
                currPath = "";
            }
            ExtractStringInputPage.this.mConfigSelector.getConfiguration(this.mTempConfig);
            StringBuffer sb = new StringBuffer(ExtractStringInputPage.RES_FOLDER_ABS);
            sb.append(this.mTempConfig.getFolderName(ResourceFolderType.VALUES));
            sb.append("/");
            String newPath = sb.toString();
            if (newPath.equals(currPath) && newPath.equals(this.mLastFolderUsedInCombo)) {
                return;
            }
            TreeSet<String> filePaths = this.mFolderCache.get(newPath);
            if (filePaths == null) {
                filePaths = new TreeSet();
                IFolder folder = ExtractStringInputPage.this.mProject.getFolder(newPath);
                if (folder != null && folder.exists()) {
                    try {
                        IResource[] iResourceArray = folder.members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource res = iResourceArray[n2];
                            String name = res.getName();
                            if (res.getType() == 1 && name.endsWith(".xml")) {
                                filePaths.add(String.valueOf(newPath) + name);
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                this.mFolderCache.put(newPath, filePaths);
            }
            currPath = String.valueOf(newPath) + leafName;
            if (leafName.length() > 0 && !filePaths.contains(currPath)) {
                filePaths.add(currPath);
            }
            try {
                this.mInternalFileComboChange = true;
                ExtractStringInputPage.this.mResFileCombo.removeAll();
                for (String filePath : filePaths) {
                    ExtractStringInputPage.this.mResFileCombo.add(filePath);
                }
                int index = -1;
                if (leafName.length() > 0 && (index = ExtractStringInputPage.this.mResFileCombo.indexOf(currPath)) >= 0) {
                    ExtractStringInputPage.this.mResFileCombo.select(index);
                }
                if (index == -1) {
                    ExtractStringInputPage.this.mResFileCombo.setText(currPath);
                }
                this.mLastFolderUsedInCombo = newPath;
            }
            finally {
                this.mInternalFileComboChange = false;
            }
            ExtractStringInputPage.this.updateStringValueCombo();
            ExtractStringInputPage.this.validatePage();
        }

        public void modifyText(ModifyEvent e) {
            if (this.mInternalFileComboChange) {
                return;
            }
            String wsFolderPath = ExtractStringInputPage.this.mResFileCombo.getText();
            wsFolderPath = wsFolderPath.replaceAll("/+\\.\\./+|/+\\./+|//+|\\\\+|^/+", "/");
            wsFolderPath = wsFolderPath.replaceAll("^\\.\\./+|^\\./+", "");
            if ((wsFolderPath = wsFolderPath.replaceAll("/+\\.\\.$|/+\\.$|/+$", "")).startsWith(ExtractStringInputPage.RES_FOLDER_REL)) {
                wsFolderPath = ExtractStringInputPage.RES_FOLDER_ABS + wsFolderPath.substring(ExtractStringInputPage.RES_FOLDER_REL.length());
                this.mInternalFileComboChange = true;
                ExtractStringInputPage.this.mResFileCombo.setText(wsFolderPath);
                this.mInternalFileComboChange = false;
            }
            if (wsFolderPath.startsWith(ExtractStringInputPage.RES_FOLDER_ABS)) {
                String folderName;
                String[] folderSegments;
                int pos = (wsFolderPath = wsFolderPath.substring(ExtractStringInputPage.RES_FOLDER_ABS.length())).indexOf(47);
                if (pos >= 0) {
                    wsFolderPath = wsFolderPath.substring(0, pos);
                }
                if ((folderSegments = wsFolderPath.split("-")).length > 0 && (folderName = folderSegments[0]) != null && !folderName.equals(wsFolderPath)) {
                    this.mInternalConfigChange = true;
                    ExtractStringInputPage.this.mConfigSelector.setConfiguration(folderSegments);
                    this.mInternalConfigChange = false;
                }
            }
            ExtractStringInputPage.this.updateStringValueCombo();
            ExtractStringInputPage.this.validatePage();
        }
    }
}

