/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.refactorings.core.RenameResourceWizard;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameTypeWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RenameResourceXmlTextAction
extends Action {
    private final ITextEditor mEditor;

    public RenameResourceXmlTextAction(@NonNull ITextEditor editor) {
        super("Rename");
        this.mEditor = editor;
    }

    public void run() {
        if (!this.validateEditorInputState()) {
            return;
        }
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        ITextSelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        Pair<ResourceType, String> resource = RenameResourceXmlTextAction.findResource(document, selection.getOffset());
        if (resource == null) {
            resource = this.findItemDefinition(document, selection.getOffset());
        }
        if (resource != null) {
            ResourceType type = (ResourceType)resource.getFirst();
            String name = (String)resource.getSecond();
            Shell shell = this.mEditor.getSite().getShell();
            boolean canClear = false;
            RenameResourceWizard.renameResource(shell, project, type, name, null, canClear);
            return;
        }
        String className = RenameResourceXmlTextAction.findClassName(document, file, selection.getOffset());
        if (className != null) {
            assert (className.equals(className.trim()));
            IType type = this.findType(className, project);
            if (type != null) {
                RenameTypeProcessor processor = new RenameTypeProcessor(type);
                processor.setUpdateQualifiedNames(true);
                processor.setUpdateSimilarDeclarations(false);
                processor.setUpdateReferences(true);
                RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
                RenameTypeWizard wizard = new RenameTypeWizard((Refactoring)refactoring);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                try {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    op.run(window.getShell(), wizard.getDefaultPageTitle());
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
        MessageDialog.openInformation((Shell)this.mEditor.getSite().getShell(), (String)"Rename", (String)"Operation unavailable on the current selection.\nSelect an Android resource name or class.");
    }

    private boolean validateEditorInputState() {
        if (this.mEditor instanceof ITextEditorExtension2) {
            return ((ITextEditorExtension2)this.mEditor).validateEditorInputState();
        }
        if (this.mEditor instanceof ITextEditorExtension) {
            return !((ITextEditorExtension)this.mEditor).isEditorInputReadOnly();
        }
        if (this.mEditor != null) {
            return this.mEditor.isEditable();
        }
        return false;
    }

    @Nullable
    public static Pair<ResourceType, String> findResource(@NonNull IDocument document, int offset) {
        block11: {
            String url;
            block12: {
                char c;
                int max = document.getLength();
                if (offset >= max) {
                    offset = max - 1;
                } else if (offset < 0) {
                    offset = 0;
                } else if (offset > 0 && !RenameResourceXmlTextAction.isValidResourceNameChar(c = document.getChar(offset))) {
                    --offset;
                }
                int start = offset;
                boolean valid = true;
                while (start >= 0) {
                    char c2 = document.getChar(start);
                    if (c2 == '@' || c2 == '?') break;
                    if (!RenameResourceXmlTextAction.isValidResourceNameChar(c2)) {
                        valid = false;
                        break;
                    }
                    --start;
                }
                if (!valid) break block11;
                int end = start + 1;
                while (end < max) {
                    char c3 = document.getChar(end);
                    if (!RenameResourceXmlTextAction.isValidResourceNameChar(c3)) break;
                    ++end;
                }
                if (end <= start + 1) break block11;
                url = document.get(start, end - start);
                if (!url.startsWith("@android:") && !url.startsWith("?android:")) break block12;
                return null;
            }
            try {
                return ResourceRepository.parseResource((String)url);
            }
            catch (BadLocationException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
        }
        return null;
    }

    private static boolean isValidResourceNameChar(char c) {
        return c == '@' || c == '?' || c == '/' || c == '+' || Character.isJavaIdentifierPart(c);
    }

    private Pair<ResourceType, String> findItemDefinition(IDocument document, int offset) {
        Node node = DomUtilities.getNode(document, offset);
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 3) {
            node = node.getParentNode();
        }
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        Element element = (Element)node;
        String name = element.getAttribute("name");
        if (name == null || name.isEmpty()) {
            return null;
        }
        String typeString = element.getTagName();
        if ("item".equals(typeString) && ((typeString = element.getAttribute("type")) == null || typeString.isEmpty())) {
            return null;
        }
        ResourceType type = ResourceType.getEnum((String)typeString);
        if (type != null) {
            return Pair.of((Object)type, (Object)name);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String findClassName(@NonNull IDocument document, @Nullable IFile file, int offset) {
        try {
            char c;
            int max = document.getLength();
            if (offset >= max) {
                offset = max - 1;
            } else if (offset < 0) {
                offset = 0;
            } else if (offset > 0 && Character.isJavaIdentifierPart(c = document.getChar(offset))) {
                --offset;
            }
            int start = offset;
            while (start >= 0) {
                char c2 = document.getChar(start);
                if (c2 == '\"' || c2 == '<' || c2 == '/') {
                    ++start;
                    break;
                }
                if (c2 != '.' && !Character.isJavaIdentifierPart(c2)) {
                    return null;
                }
                --start;
            }
            int end = start + 1;
            while (end < max) {
                char c3 = document.getChar(end);
                if (c3 != '.' && !Character.isJavaIdentifierPart(c3)) {
                    if (c3 == '\"' || c3 == '>' || Character.isWhitespace(c3)) break;
                    return null;
                }
                ++end;
            }
            if (end <= start + 1) return null;
            String fqcn = document.get(start, end - start);
            int dot = fqcn.indexOf(46);
            if (dot == -1) {
                return null;
            }
            if (dot != 0) return fqcn;
            if (file == null) return null;
            if (!file.getName().equals("AndroidManifest.xml")) return null;
            ManifestInfo info = ManifestInfo.get(file.getProject());
            return String.valueOf(info.getPackage()) + fqcn;
        }
        catch (BadLocationException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return null;
    }

    @Nullable
    private IType findType(@NonNull String className, @NonNull IProject project) {
        IJavaProject javaProject;
        IType type;
        block6: {
            type = null;
            javaProject = BaseProjectHelper.getJavaProject(project);
            type = javaProject.findType(className);
            if (type != null && type.exists()) break block6;
            return null;
        }
        try {
            if (!type.isBinary()) {
                return type;
            }
            ProjectState projectState = Sdk.getProjectState(project);
            if (projectState != null) {
                List<IProject> libraries = projectState.getFullLibraryProjects();
                for (IProject library : libraries) {
                    javaProject = BaseProjectHelper.getJavaProject(library);
                    type = javaProject.findType(className);
                    if (type == null || !type.exists() || type.isBinary()) continue;
                    return type;
                }
            }
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return null;
    }

    private ITextSelection getSelection() {
        ISelectionProvider selectionProvider = this.mEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    private IDocument getDocument() {
        IDocumentProvider documentProvider = this.mEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)this.mEditor.getEditorInput());
        if (document == null) {
            return null;
        }
        return document;
    }

    @Nullable
    private IFile getFile() {
        IEditorInput input = this.mEditor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return fileInput.getFile();
        }
        return null;
    }
}

