/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.internal.resources.ResourceNameValidator;
import com.android.resources.ResourceType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class RenameResourceProcessor
extends RenameProcessor {
    private IProject mProject;
    private ResourceType mType;
    private String mCurrentName;
    private String mNewName;
    private boolean mUpdateReferences = true;
    private ResourceNameValidator mValidator;
    private RenameArguments mRenameArguments;

    public RenameResourceProcessor(@NonNull IProject project, @NonNull ResourceType type, @NonNull String currentName, @Nullable String newName) {
        this.mProject = project;
        this.mType = type;
        this.mCurrentName = currentName;
        this.mNewName = newName != null ? newName : currentName;
        this.mUpdateReferences = true;
        this.mValidator = ResourceNameValidator.create(false, this.mProject, this.mType);
    }

    @NonNull
    public IProject getProject() {
        return this.mProject;
    }

    @NonNull
    public String getNewName() {
        return this.mNewName;
    }

    public String getCurrentName() {
        return this.mCurrentName;
    }

    @NonNull
    public ResourceType getType() {
        return this.mType;
    }

    public void setNewName(@NonNull String newName) {
        this.mNewName = newName;
    }

    public boolean isUpdateReferences() {
        return this.mUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.mUpdateReferences = updateReferences;
    }

    public RefactoringStatus checkNewName(String name) {
        String error = this.mValidator.isValid(name);
        if (error != null) {
            return RefactoringStatus.createFatalErrorStatus((String)error);
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            this.mRenameArguments = new RenameArguments(this.getNewName(), this.isUpdateReferences());
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        pm.done();
        return null;
    }

    public Object[] getElements() {
        return new Object[0];
    }

    public String getIdentifier() {
        return "com.android.ide.renameResourceProcessor";
    }

    public String getProcessorName() {
        return "Rename Android Resource";
    }

    public boolean isApplicable() {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        String[] affectedNatures = new String[]{"com.android.ide.eclipse.adt.AndroidNature"};
        String url = "@" + this.mType.getName() + '/' + this.mCurrentName;
        return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)url, (RenameArguments)this.mRenameArguments, null, (String[])affectedNatures, (SharableParticipants)shared);
    }
}

