/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestInfo;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.refactorings.core.RefactoringUtil;
import com.android.ide.eclipse.adt.internal.refactorings.core.RenameResourceProcessor;
import com.android.ide.eclipse.adt.internal.resources.ResourceNameValidator;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenameResourceParticipant
extends RenameParticipant {
    @NonNull
    private IProject mProject;
    @NonNull
    private ResourceType mType;
    @NonNull
    private ResourceFolderType mFolderType;
    @NonNull
    private String mOldName;
    @NonNull
    private String mNewName;
    private boolean mUpdateReferences;
    @NonNull
    private String mXmlMatch1;
    @Nullable
    private String mXmlMatch2;
    @Nullable
    private String mXmlMatch3;
    @NonNull
    private String mXmlNewValue1;
    @Nullable
    private String mXmlNewValue2;
    @Nullable
    private String mXmlNewValue3;
    private IFile mRenamedFile;
    private RenameRefactoring mFieldRefactoring;
    private static boolean sIgnore;

    public String getName() {
        return "Android Rename Field Participant";
    }

    protected boolean initialize(Object element) {
        String uri;
        if (sIgnore) {
            return false;
        }
        if (element instanceof IField) {
            IField field = (IField)element;
            IType declaringType = field.getDeclaringType();
            if (declaringType != null && "R".equals(declaringType.getParent().getElementName())) {
                String typeName = declaringType.getElementName();
                this.mType = ResourceType.getEnum((String)typeName);
                if (this.mType != null) {
                    this.mUpdateReferences = this.getArguments().getUpdateReferences();
                    this.mFolderType = AdtUtils.getFolderTypeFor(this.mType);
                    IJavaProject javaProject = (IJavaProject)field.getAncestor(2);
                    this.mProject = javaProject.getProject();
                    this.mOldName = field.getElementName();
                    this.mNewName = this.getArguments().getNewName();
                    this.mFieldRefactoring = null;
                    this.mRenamedFile = null;
                    this.createXmlSearchPatterns();
                    return true;
                }
            }
            return false;
        }
        if (element instanceof IFile) {
            IPath path;
            int segments;
            IFile file = (IFile)element;
            this.mProject = file.getProject();
            if (BaseProjectHelper.isAndroidProject(this.mProject) && (segments = (path = file.getFullPath()).segmentCount()) == 4 && path.segment(1).equals("res")) {
                String parentName = file.getParent().getName();
                this.mFolderType = ResourceFolderType.getFolderType((String)parentName);
                if (this.mFolderType != null && this.mFolderType != ResourceFolderType.VALUES) {
                    this.mType = AdtUtils.getResourceTypeFor(this.mFolderType);
                    if (this.mType != null) {
                        this.mUpdateReferences = this.getArguments().getUpdateReferences();
                        this.mProject = file.getProject();
                        this.mOldName = AdtUtils.stripAllExtensions(file.getName());
                        this.mNewName = AdtUtils.stripAllExtensions(this.getArguments().getNewName());
                        this.mRenamedFile = file;
                        this.createXmlSearchPatterns();
                        this.mFieldRefactoring = null;
                        IField field = RenameResourceParticipant.getResourceField(this.mProject, this.mType, this.mOldName);
                        this.mFieldRefactoring = field != null ? this.createFieldRefactoring(field) : null;
                        return true;
                    }
                }
            }
        } else if (element instanceof String && (uri = (String)element).startsWith("@") && !uri.startsWith("@android:")) {
            IField field;
            RenameResourceProcessor processor = (RenameResourceProcessor)this.getProcessor();
            this.mProject = processor.getProject();
            this.mType = processor.getType();
            this.mFolderType = AdtUtils.getFolderTypeFor(this.mType);
            this.mOldName = processor.getCurrentName();
            this.mNewName = processor.getNewName();
            assert (uri.endsWith(this.mOldName) && uri.contains(this.mType.getName())) : uri;
            this.mUpdateReferences = this.getArguments().getUpdateReferences();
            if (this.mNewName.isEmpty()) {
                this.mUpdateReferences = false;
            }
            this.mRenamedFile = null;
            this.createXmlSearchPatterns();
            this.mFieldRefactoring = null;
            if (!this.mNewName.isEmpty() && (field = RenameResourceParticipant.getResourceField(this.mProject, this.mType, this.mOldName)) != null) {
                this.mFieldRefactoring = this.createFieldRefactoring(field);
            }
            return true;
        }
        return false;
    }

    private RenameRefactoring createFieldRefactoring(IField field) {
        return RenameResourceParticipant.createFieldRefactoring(field, this.mNewName, this.mUpdateReferences);
    }

    public static RenameRefactoring createFieldRefactoring(@NonNull IField field, @NonNull String newName, boolean updateReferences) {
        RenameFieldProcessor processor = new RenameFieldProcessor(field);
        processor.setRenameGetter(false);
        processor.setRenameSetter(false);
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        processor.setUpdateReferences(updateReferences);
        processor.setUpdateTextualMatches(false);
        processor.setNewElementName(newName);
        try {
            if (refactoring.isApplicable()) {
                return refactoring;
            }
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return null;
    }

    private void createXmlSearchPatterns() {
        this.mXmlMatch2 = null;
        this.mXmlNewValue2 = null;
        this.mXmlMatch3 = null;
        this.mXmlNewValue3 = null;
        String typeName = this.mType.getName();
        if (this.mUpdateReferences) {
            this.mXmlMatch1 = "@" + typeName + '/' + this.mOldName;
            this.mXmlNewValue1 = "@" + typeName + '/' + this.mNewName;
            if (this.mType == ResourceType.ID) {
                this.mXmlMatch2 = "@+id/" + this.mOldName;
                this.mXmlNewValue2 = "@+id/" + this.mNewName;
            } else if (this.mType == ResourceType.ATTR) {
                this.mXmlMatch2 = "?" + typeName + '/' + this.mOldName;
                this.mXmlNewValue2 = "?" + typeName + '/' + this.mNewName;
                this.mXmlMatch3 = "?" + this.mOldName;
                this.mXmlNewValue3 = "?" + this.mNewName;
            }
        } else if (this.mType == ResourceType.ID) {
            this.mXmlMatch1 = "@+id/" + this.mOldName;
            this.mXmlNewValue1 = "@+id/" + this.mNewName;
        }
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        ResourceNameValidator validator;
        String error;
        if (this.mRenamedFile != null && this.getArguments().getNewName().indexOf(46) == -1 && this.mRenamedFile.getName().indexOf(46) != -1) {
            return RefactoringStatus.createErrorStatus((String)String.format("You must include the file extension (%1$s?)", this.mRenamedFile.getName().substring(this.mRenamedFile.getName().indexOf(46))));
        }
        if (this.mNewName != null && !this.mNewName.isEmpty() && (error = (validator = ResourceNameValidator.create(false, this.mProject, this.mType)).isValid(this.mNewName)) != null) {
            return RefactoringStatus.createErrorStatus((String)error);
        }
        if (this.mFieldRefactoring != null) {
            try {
                sIgnore = true;
                RefactoringStatus refactoringStatus = this.mFieldRefactoring.checkAllConditions(pm);
                return refactoringStatus;
            }
            catch (CoreException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
            finally {
                sIgnore = false;
            }
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        ProjectState projectState;
        if (monitor.isCanceled()) {
            return null;
        }
        CompositeChange result = new CompositeChange("Update resource references");
        result.markAsSynthetic();
        this.addResourceFileChanges(result, this.mProject, monitor);
        if (this.mUpdateReferences && (projectState = Sdk.getProjectState(this.mProject)) != null && projectState.isLibrary()) {
            List<ProjectState> parentProjects = projectState.getParentProjects();
            for (ProjectState state : parentProjects) {
                IProject project = state.getProject();
                CompositeChange nested = new CompositeChange(String.format("Update references in %1$s", project.getName()));
                this.addResourceFileChanges(nested, project, monitor);
                if (nested.getChildren().length <= 0) continue;
                result.add((Change)nested);
            }
        }
        if (this.mFieldRefactoring != null) {
            try {
                sIgnore = true;
                this.addJavaChanges(result, monitor);
            }
            finally {
                sIgnore = false;
            }
        } else {
            this.disableExistingResourceFileChange();
        }
        return result.getChildren().length == 0 ? null : result;
    }

    private void addResourceFileChanges(CompositeChange change, IProject project, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            IResource[] folders;
            IFile manifest = project.getFile("AndroidManifest.xml");
            if (manifest != null) {
                this.addResourceXmlChanges(manifest, change, null);
            }
            IFolder resFolder = project.getFolder("res");
            IResource[] iResourceArray = folders = resFolder.members();
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                IResource folder = iResourceArray[n2];
                if (folder instanceof IFolder) {
                    String folderName = folder.getName();
                    ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
                    IResource[] files = ((IFolder)folder).members();
                    int i = 0;
                    while (i < files.length) {
                        IResource member = files[i];
                        if (member instanceof IFile && member.exists()) {
                            IFile file = (IFile)member;
                            String fileName = member.getName();
                            if (SdkUtils.endsWith((CharSequence)fileName, (CharSequence)".xml")) {
                                this.addResourceXmlChanges(file, change, folderType);
                            }
                            if ((this.mRenamedFile == null || !this.mRenamedFile.equals((Object)file)) && fileName.startsWith(this.mOldName) && fileName.length() > this.mOldName.length() && fileName.charAt(this.mOldName.length()) == '.' && this.mFolderType != ResourceFolderType.VALUES && this.mFolderType == folderType) {
                                String newFile = String.valueOf(this.mNewName) + fileName.substring(this.mOldName.length());
                                IPath path = file.getFullPath();
                                change.add((Change)new RenameResourceChange(path, newFile));
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            RefactoringUtil.log(e);
        }
    }

    private void addJavaChanges(CompositeChange result, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Change fieldChanges;
        if (monitor.isCanceled()) {
            return;
        }
        RefactoringStatus status = this.mFieldRefactoring.checkAllConditions(monitor);
        if (status != null && !status.hasError() && (fieldChanges = this.mFieldRefactoring.createChange(monitor)) != null) {
            result.add(fieldChanges);
            RenameResourceParticipant.disableRClassChanges(fieldChanges);
        }
    }

    private boolean addResourceXmlChanges(IFile file, CompositeChange changes, ResourceFolderType folderType) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getExistingModelForRead(file);
            if (model == null) {
                model = modelManager.getModelForRead(file);
            }
            if (model != null) {
                IStructuredDocument document = model.getStructuredDocument();
                if (model instanceof IDOMModel) {
                    IDOMModel domModel = (IDOMModel)model;
                    Element root = domModel.getDocument().getDocumentElement();
                    if (root != null) {
                        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                        this.addReplacements(edits, root, document, folderType);
                        if (!edits.isEmpty()) {
                            MultiTextEdit rootEdit = new MultiTextEdit();
                            rootEdit.addChildren(edits.toArray(new TextEdit[edits.size()]));
                            TextFileChange change = new TextFileChange(file.getName(), file);
                            change.setTextType("xml");
                            change.setEdit((TextEdit)rootEdit);
                            changes.add((Change)change);
                        }
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }

    private void addReplacements(@NonNull List<TextEdit> edits, @NonNull Element element, @NonNull IStructuredDocument document, @Nullable ResourceFolderType folderType) {
        int start;
        Attr nameNode;
        String tag = element.getTagName();
        if (folderType == ResourceFolderType.VALUES && (tag.equals(this.mType.getName()) || tag.equals("item") && (this.mType == ResourceType.ID || this.mType.getName().equals(element.getAttribute("type")))) && (nameNode = element.getAttributeNode("name")) != null && nameNode.getValue().equals(this.mOldName) && (start = RefactoringUtil.getAttributeValueRangeStart(nameNode, (IDocument)document)) != -1) {
            int end = start + this.mOldName.length();
            edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewName));
        }
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        int n = attributes.getLength();
        while (i < n) {
            block22: {
                String matchedValue;
                String match;
                Attr attr;
                block24: {
                    String value;
                    block25: {
                        block23: {
                            block21: {
                                int start2;
                                attr = (Attr)attributes.item(i);
                                value = attr.getValue();
                                if (this.mUpdateReferences || "id".equals(attr.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) break block21;
                                if ("http://schemas.android.com/tools".equals(attr.getNamespaceURI()) && value.equals(this.mXmlMatch1) && (start2 = RefactoringUtil.getAttributeValueRangeStart(attr, (IDocument)document)) != -1) {
                                    int end = start2 + this.mXmlMatch1.length();
                                    edits.add((TextEdit)new ReplaceEdit(start2, end - start2, this.mXmlNewValue1));
                                }
                                break block22;
                            }
                            match = null;
                            matchedValue = null;
                            if (!value.equals(this.mXmlMatch1)) break block23;
                            match = this.mXmlMatch1;
                            matchedValue = this.mXmlNewValue1;
                            break block24;
                        }
                        if (!value.equals(this.mXmlMatch2)) break block25;
                        match = this.mXmlMatch2;
                        matchedValue = this.mXmlNewValue2;
                        break block24;
                    }
                    if (!value.equals(this.mXmlMatch3)) break block22;
                    match = this.mXmlMatch3;
                    matchedValue = this.mXmlNewValue3;
                }
                if (match != null) {
                    if (this.mNewName.isEmpty() && "id".equals(attr.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) {
                        IndexedRegion region = (IndexedRegion)attr;
                        int start3 = region.getStartOffset();
                        int end = region.getEndOffset();
                        edits.add((TextEdit)new ReplaceEdit(start3, end - start3, ""));
                    } else {
                        int start4 = RefactoringUtil.getAttributeValueRangeStart(attr, (IDocument)document);
                        if (start4 != -1) {
                            int end = start4 + match.length();
                            edits.add((TextEdit)new ReplaceEdit(start4, end - start4, matchedValue));
                        }
                    }
                }
            }
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        int n2 = children.getLength();
        while (i2 < n2) {
            String text;
            int index;
            Node child = children.item(i2);
            if (child.getNodeType() == 1) {
                this.addReplacements(edits, (Element)child, document, folderType);
            } else if (child.getNodeType() == 3 && this.mUpdateReferences && (index = this.getFirstNonBlankIndex(text = child.getNodeValue())) != -1) {
                String match = null;
                String matchedValue = null;
                if (this.mXmlMatch1 != null && text.startsWith(this.mXmlMatch1) && text.trim().equals(this.mXmlMatch1)) {
                    match = this.mXmlMatch1;
                    matchedValue = this.mXmlNewValue1;
                } else if (this.mXmlMatch2 != null && text.startsWith(this.mXmlMatch2) && text.trim().equals(this.mXmlMatch2)) {
                    match = this.mXmlMatch2;
                    matchedValue = this.mXmlNewValue2;
                } else if (this.mXmlMatch3 != null && text.startsWith(this.mXmlMatch3) && text.trim().equals(this.mXmlMatch3)) {
                    match = this.mXmlMatch3;
                    matchedValue = this.mXmlNewValue3;
                }
                if (match != null) {
                    IndexedRegion region = (IndexedRegion)child;
                    int start5 = region.getStartOffset() + index;
                    int end = start5 + match.length();
                    edits.add((TextEdit)new ReplaceEdit(start5, end - start5, matchedValue));
                }
            }
            ++i2;
        }
    }

    private int getFirstNonBlankIndex(String s) {
        int i = 0;
        int n = s.length();
        while (i < n) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Nullable
    private static IField getResourceField(@NonNull IProject project, @NonNull ResourceType type, @NonNull String name) {
        IType t;
        block5: {
            IJavaProject javaProject;
            block4: {
                try {
                    javaProject = BaseProjectHelper.getJavaProject(project);
                    if (javaProject != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                    return null;
                }
            }
            String pkg = ManifestInfo.get(project).getPackage();
            t = javaProject.findType(String.valueOf(pkg) + '.' + "R" + '.' + type.getName());
            if (t != null) break block5;
            return null;
        }
        return t.getField(name);
    }

    private void disableExistingResourceFileChange() {
        IFile rFile;
        TextChange change;
        ManifestInfo manifestInfo;
        String pkg;
        IFolder genFolder = this.mProject.getFolder("gen");
        if (genFolder != null && genFolder.exists() && (pkg = (manifestInfo = ManifestInfo.get(this.mProject)).getPackage()) != null && (change = this.getTextChange(rFile = genFolder.getFile(String.valueOf(pkg.replace('.', '/')) + '/' + "R.java"))) != null) {
            change.setEnabled(false);
        }
    }

    public static void disableRClassChanges(Change change) {
        if (change.getName().equals("R.java")) {
            change.setEnabled(false);
        }
        if (change instanceof CompositeChange) {
            Change[] changeArray = ((CompositeChange)change).getChildren();
            int n = changeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Change outer = changeArray[n2];
                RenameResourceParticipant.disableRClassChanges(outer);
                ++n2;
            }
        }
    }
}

