/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class RefactoringUtil {
    private static boolean sRefactorAppPackage = false;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fixModel(IStructuredModel model, IDocument document) {
        if (model != null) {
            model.releaseFromRead();
        }
        model = null;
        if (document == null) {
            return;
        }
        try {
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
                if (model == null) return;
                model.save();
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (model == null) return;
                model.releaseFromEdit();
                return;
            }
            catch (IOException iOException) {
                if (model == null) return;
                model.releaseFromEdit();
                return;
            }
            catch (CoreException coreException) {
                if (model == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                model.releaseFromEdit();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public static void logInfo(String message) {
        AdtPlugin.log(1, "com.android.ide.eclipse.adt", message);
    }

    public static void log(Throwable e) {
        AdtPlugin.log(e, e.getMessage(), new Object[0]);
    }

    public static boolean isRefactorAppPackage() {
        return sRefactorAppPackage;
    }

    public static void setRefactorAppPackage(boolean refactorAppPackage) {
        sRefactorAppPackage = refactorAppPackage;
    }

    public static int getAttributeValueRangeStart(@NonNull Attr attr, @NonNull IDocument document) {
        String text;
        IndexedRegion region = (IndexedRegion)attr;
        int potentialStart = attr.getName().length() + 2;
        try {
            text = document.get(region.getStartOffset(), region.getEndOffset() - region.getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        String value = attr.getValue();
        int index = text.indexOf(value, potentialStart);
        if (index != -1) {
            return region.getStartOffset() + index;
        }
        return -1;
    }

    public static int getTagNameRangeStart(@NonNull Element element, @NonNull IDocument document) {
        String text;
        IndexedRegion region = (IndexedRegion)element;
        int potentialStart = 1;
        try {
            text = document.get(region.getStartOffset(), region.getEndOffset() - region.getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        int index = text.indexOf(element.getTagName(), potentialStart);
        if (index != -1) {
            return region.getStartOffset() + index;
        }
        return -1;
    }

    public static boolean isManifestClassAttribute(@NonNull Attr attribute) {
        return RefactoringUtil.isManifestClassAttribute(attribute.getOwnerElement().getTagName(), attribute.getNamespaceURI(), attribute.getLocalName());
    }

    public static boolean isManifestClassAttribute(@Nullable String tag, @Nullable String uri, @Nullable String name) {
        if (name == null) {
            return false;
        }
        if (name.equals("name") && ("activity".equals(tag) || "application".equals(tag) || "instrumentation".equals(tag) || "provider".equals(tag) || "service".equals(tag) || "receiver".equals(tag)) || name.equals("targetActivity") || name.equals("manageSpaceActivity") || name.equals("backupAgent") || name.equals("parentActivityName")) {
            return "http://schemas.android.com/apk/res/android".equals(uri);
        }
        return false;
    }
}

