/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.core;

import com.android.annotations.NonNull;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestHelper;
import com.android.ide.eclipse.adt.internal.refactorings.core.FixImportsJob;
import com.android.ide.eclipse.adt.internal.refactorings.core.RefactoringUtil;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.resources.ResourceFolderType;
import com.android.utils.SdkUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidPackageRenameParticipant
extends RenameParticipant {
    private IProject mProject;
    private IFile mManifestFile;
    private IPackageFragment mPackageFragment;
    private String mOldPackage;
    private String mNewPackage;
    private String mAppPackage;
    private boolean mRefactoringAppPackage;

    public String getName() {
        return "Android Package Rename";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.mAppPackage.equals(this.mOldPackage) && !this.mRefactoringAppPackage) {
            Attr attribute;
            Region region = null;
            Document document = DomUtilities.getDocument(this.mManifestFile);
            if (document != null && document.getDocumentElement() != null && (attribute = document.getDocumentElement().getAttributeNode("package")) instanceof IndexedRegion) {
                IndexedRegion ir = (IndexedRegion)attribute;
                int start = ir.getStartOffset();
                region = new Region(start, ir.getEndOffset() - start);
            }
            if (region == null) {
                region = new Region(0, 0);
            }
            FileStatusContext ctx = new FileStatusContext(this.mManifestFile, (IRegion)region);
            RefactoringStatus status = RefactoringStatus.createInfoStatus((String)"You are refactoring the same package as your application's package (specified in the manifest).\n", (RefactoringStatusContext)ctx);
            status.addInfo("Note that this refactoring does NOT also update your application package.", (RefactoringStatusContext)ctx);
            status.addInfo("The application package defines your application's identity.", (RefactoringStatusContext)ctx);
            status.addInfo("If you change it, then it is considered to be a different application.", (RefactoringStatusContext)ctx);
            status.addInfo("(Users of the previous version cannot update to the new version.)", (RefactoringStatusContext)ctx);
            status.addInfo("The application package, and the package containing the code, can differ.", (RefactoringStatusContext)ctx);
            status.addInfo("To really change application package, choose \"Android Tools\" > \"Rename  Application Package.\" from the project context menu.", (RefactoringStatusContext)ctx);
            return status;
        }
        return new RefactoringStatus();
    }

    protected boolean initialize(Object element) {
        block9: {
            String packageName;
            block13: {
                ManifestData manifestData;
                block12: {
                    IResource manifestResource;
                    block11: {
                        block10: {
                            block8: {
                                this.mRefactoringAppPackage = false;
                                try {
                                    if (this.getArguments().getUpdateReferences()) break block8;
                                    return false;
                                }
                                catch (JavaModelException javaModelException) {}
                            }
                            if (!(element instanceof IPackageFragment)) break block9;
                            this.mPackageFragment = (IPackageFragment)element;
                            if (this.mPackageFragment.containsJavaResources()) break block10;
                            return false;
                        }
                        IJavaProject javaProject = (IJavaProject)this.mPackageFragment.getAncestor(2);
                        this.mProject = javaProject.getProject();
                        manifestResource = this.mProject.findMember("/AndroidManifest.xml");
                        if (manifestResource != null && manifestResource.exists() && manifestResource instanceof IFile) break block11;
                        RefactoringUtil.logInfo("Invalid or missing the AndroidManifest.xml in the " + this.mProject.getName() + " project.");
                        return false;
                    }
                    this.mManifestFile = (IFile)manifestResource;
                    packageName = this.mPackageFragment.getElementName();
                    manifestData = AndroidManifestHelper.parseForData(this.mManifestFile);
                    if (manifestData != null) break block12;
                    return false;
                }
                this.mAppPackage = manifestData.getPackage();
                this.mOldPackage = packageName;
                this.mNewPackage = this.getArguments().getNewName();
                if (this.mOldPackage != null && this.mNewPackage != null) break block13;
                return false;
            }
            if (RefactoringUtil.isRefactorAppPackage() && this.mAppPackage != null && this.mAppPackage.equals(packageName)) {
                this.mRefactoringAppPackage = true;
            }
            return true;
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RenameTypeProcessor rtp;
        if (pm.isCanceled()) {
            return null;
        }
        if (!this.getArguments().getUpdateReferences()) {
            return null;
        }
        RefactoringProcessor p = this.getProcessor();
        if (p instanceof RenameCompilationUnitProcessor && (rtp = ((RenameCompilationUnitProcessor)p).getRenameTypeProcessor()) != null) {
            String pattern = rtp.getFilePatterns();
            boolean updQualf = rtp.getUpdateQualifiedNames();
            if (updQualf && pattern != null && pattern.contains("xml")) {
                return null;
            }
        }
        IPath pkgPath = this.mPackageFragment.getPath();
        IPath genPath = this.mProject.getFullPath().append("gen");
        if (genPath.isPrefixOf(pkgPath)) {
            RefactoringUtil.logInfo(String.valueOf(this.getName()) + ": Cannot rename generated package.");
            return null;
        }
        CompositeChange result = new CompositeChange(this.getName());
        result.markAsSynthetic();
        this.addManifestFileChanges(result);
        this.addLayoutFileChanges(this.mProject, result);
        ProjectState projectState = Sdk.getProjectState(this.mProject);
        if (projectState != null) {
            Collection<ProjectState> parentProjects = projectState.getFullParentProjects();
            for (ProjectState parentProject : parentProjects) {
                IProject project = parentProject.getProject();
                this.addLayoutFileChanges(project, result);
            }
        }
        if (this.mRefactoringAppPackage) {
            Change genChange = this.getGenPackageChange(pm);
            if (genChange != null) {
                result.add(genChange);
            }
            return new NullChange("Update Imports"){

                public Change perform(IProgressMonitor monitor) throws CoreException {
                    FixImportsJob job = new FixImportsJob("Fix Rename Package", AndroidPackageRenameParticipant.this.mManifestFile, AndroidPackageRenameParticipant.this.mNewPackage);
                    job.schedule(500L);
                    return null;
                }
            };
        }
        return result.getChildren().length == 0 ? null : result;
    }

    public Change getGenPackageChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IPackageFragment genJavaPackageFragment;
        if (this.mRefactoringAppPackage && (genJavaPackageFragment = this.getGenPackageFragment()) != null && genJavaPackageFragment.exists()) {
            return new RenamePackageChange(genJavaPackageFragment, this.mNewPackage, true);
        }
        return null;
    }

    private IPackageFragment getGenPackageFragment() throws JavaModelException {
        IProject project;
        IFolder genFolder;
        IJavaProject javaProject = (IJavaProject)this.mPackageFragment.getAncestor(2);
        if (javaProject != null && javaProject.isOpen() && (genFolder = (project = javaProject.getProject()).getFolder("gen")).exists()) {
            String javaPackagePath = this.mAppPackage.replace('.', '/');
            IPath genJavaPackagePath = genFolder.getFullPath().append(javaPackagePath);
            IPackageFragment genPackageFragment = javaProject.findPackageFragment(genJavaPackagePath);
            return genPackageFragment;
        }
        return null;
    }

    private String getNewClassName(String fqcn) {
        assert (this.isInRenamedPackage(fqcn)) : fqcn;
        int lastDot = fqcn.lastIndexOf(46);
        if (lastDot < 0) {
            return this.mNewPackage;
        }
        String name = fqcn.substring(lastDot, fqcn.length());
        String newClassName = String.valueOf(this.mNewPackage) + name;
        return newClassName;
    }

    private void addManifestFileChanges(CompositeChange result) {
        this.addXmlFileChanges(this.mManifestFile, result, true);
    }

    private void addLayoutFileChanges(IProject project, CompositeChange result) {
        try {
            IResource[] folders;
            IFolder resFolder = project.getFolder("res");
            IResource[] iResourceArray = folders = resFolder.members();
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                IResource folder = iResourceArray[n2];
                String folderName = folder.getName();
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
                if (folderType == ResourceFolderType.LAYOUT && folder instanceof IFolder) {
                    IResource[] files = ((IFolder)folder).members();
                    int i = 0;
                    while (i < files.length) {
                        IResource member = files[i];
                        if (member instanceof IFile && member.exists()) {
                            IFile file = (IFile)member;
                            String fileName = member.getName();
                            if (SdkUtils.endsWith((CharSequence)fileName, (CharSequence)".xml")) {
                                this.addXmlFileChanges(file, result, false);
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            RefactoringUtil.log(e);
        }
    }

    private boolean addXmlFileChanges(IFile file, CompositeChange changes, boolean isManifest) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getExistingModelForRead(file);
            if (model == null) {
                model = modelManager.getModelForRead(file);
            }
            if (model != null) {
                IStructuredDocument document = model.getStructuredDocument();
                if (model instanceof IDOMModel) {
                    IDOMModel domModel = (IDOMModel)model;
                    Element root = domModel.getDocument().getDocumentElement();
                    if (root != null) {
                        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                        if (isManifest) {
                            this.addManifestReplacements(edits, root, document);
                        } else {
                            this.addLayoutReplacements(edits, root, document);
                        }
                        if (!edits.isEmpty()) {
                            MultiTextEdit rootEdit = new MultiTextEdit();
                            rootEdit.addChildren(edits.toArray(new TextEdit[edits.size()]));
                            TextFileChange change = new TextFileChange(file.getName(), file);
                            change.setTextType("xml");
                            change.setEdit((TextEdit)rootEdit);
                            changes.add((Change)change);
                        }
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }

    private boolean isInRenamedPackage(String fqcn) {
        return fqcn.startsWith(this.mOldPackage) && fqcn.length() > this.mOldPackage.length() && fqcn.indexOf(46, this.mOldPackage.length() + 1) == -1;
    }

    private void addLayoutReplacements(@NonNull List<TextEdit> edits, @NonNull Element element, @NonNull IStructuredDocument document) {
        String tag = element.getTagName();
        if (this.isInRenamedPackage(tag)) {
            int start = RefactoringUtil.getTagNameRangeStart(element, (IDocument)document);
            if (start != -1) {
                int end = start + tag.length();
                edits.add((TextEdit)new ReplaceEdit(start, end - start, this.getNewClassName(tag)));
            }
        } else {
            int start;
            String fqcn;
            Attr classNode = null;
            if (tag.equals("view")) {
                classNode = element.getAttributeNode("class");
            } else if (tag.equals("fragment")) {
                classNode = element.getAttributeNode("class");
                if (classNode == null) {
                    classNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                }
            } else if (element.hasAttributeNS("http://schemas.android.com/tools", "context") && (classNode = element.getAttributeNodeNS("http://schemas.android.com/tools", "context")) != null && classNode.getValue().startsWith(".")) {
                classNode = null;
            }
            if (classNode != null && this.isInRenamedPackage(fqcn = classNode.getValue()) && (start = RefactoringUtil.getAttributeValueRangeStart(classNode, (IDocument)document)) != -1) {
                int end = start + fqcn.length();
                edits.add((TextEdit)new ReplaceEdit(start, end - start, this.getNewClassName(fqcn)));
            }
        }
        NodeList children = element.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.addLayoutReplacements(edits, (Element)child, document);
            }
            ++i;
        }
    }

    private void addManifestReplacements(@NonNull List<TextEdit> edits, @NonNull Element element, @NonNull IStructuredDocument document) {
        int start;
        Attr pkg;
        if (this.mRefactoringAppPackage && element == element.getOwnerDocument().getDocumentElement() && (pkg = element.getAttributeNode("package")) != null && pkg.getValue().equals(this.mOldPackage) && (start = RefactoringUtil.getAttributeValueRangeStart(pkg, (IDocument)document)) != -1) {
            int end = start + this.mOldPackage.length();
            edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewPackage));
        }
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        int n = attributes.getLength();
        while (i < n) {
            Attr attr = (Attr)attributes.item(i);
            if (RefactoringUtil.isManifestClassAttribute(attr)) {
                int start2;
                String fqcn;
                String value = attr.getValue();
                if (this.isInRenamedPackage(value)) {
                    int start3 = RefactoringUtil.getAttributeValueRangeStart(attr, (IDocument)document);
                    if (start3 != -1) {
                        int end = start3 + value.length();
                        edits.add((TextEdit)new ReplaceEdit(start3, end - start3, this.getNewClassName(value)));
                    }
                } else if (value.startsWith(".") && this.isInRenamedPackage(fqcn = String.valueOf(this.mAppPackage) + value) && (start2 = RefactoringUtil.getAttributeValueRangeStart(attr, (IDocument)document)) != -1) {
                    int end = start2 + value.length();
                    String newClassName = this.getNewClassName(fqcn);
                    if (this.mRefactoringAppPackage) {
                        newClassName = newClassName.substring(this.mNewPackage.length());
                    } else if (newClassName.startsWith(this.mOldPackage) && newClassName.charAt(this.mOldPackage.length()) == '.') {
                        newClassName = newClassName.substring(this.mOldPackage.length());
                    }
                    if (!newClassName.equals(value)) {
                        edits.add((TextEdit)new ReplaceEdit(start2, end - start2, newClassName));
                    }
                }
            }
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        int n2 = children.getLength();
        while (i2 < n2) {
            Node child = children.item(i2);
            if (child.getNodeType() == 1) {
                this.addManifestReplacements(edits, (Element)child, document);
            }
            ++i2;
        }
    }
}

