/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AndroidPrintStream;
import com.android.ide.eclipse.adt.internal.build.BuildHelper;
import com.android.ide.eclipse.adt.internal.build.DexException;
import com.android.ide.eclipse.adt.internal.build.NativeLibInJarException;
import com.android.ide.eclipse.adt.internal.build.ProguardExecException;
import com.android.ide.eclipse.adt.internal.build.ProguardResultException;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.ProjectState;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.io.IFileWrapper;
import com.android.io.IAbstractFile;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.build.ApkCreationException;
import com.android.sdklib.build.DuplicateFileException;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.xml.AndroidManifest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public final class ExportHelper {
    private static final String HOME_PROPERTY = "user.home";
    private static final String HOME_PROPERTY_REF = "${user.home}";
    private static final String SDK_PROPERTY_REF = "${sdk.dir}";
    private static final String TEMP_PREFIX = "android_";

    public static void exportReleaseApk(IProject project, File outputFile, PrivateKey key, X509Certificate certificate, IProgressMonitor monitor) throws CoreException {
        ProjectHelper.compileInReleaseMode(project, monitor);
        if (key == null) {
            certificate = null;
        } else if (certificate == null) {
            key = null;
        }
        try {
            try {
                Collection<String> dxInput;
                IResource manifestResource = project.findMember("AndroidManifest.xml");
                if (manifestResource.getType() != 1) {
                    throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", String.format("%1$s missing.", "AndroidManifest.xml")));
                }
                IFileWrapper manifestFile = new IFileWrapper((IFile)manifestResource);
                boolean debugMode = AndroidManifest.getDebuggable((IAbstractFile)manifestFile);
                AndroidPrintStream fakeStream = new AndroidPrintStream(null, null, new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                    }
                });
                ProjectState projectState = Sdk.getProjectState(project);
                String forceJumboStr = projectState.getProperty("dex.force.jumbo");
                Boolean jumbo = Boolean.valueOf(forceJumboStr);
                String dexMergerStr = projectState.getProperty("dex.disable.merger");
                Boolean dexMerger = Boolean.valueOf(dexMergerStr);
                BuildToolInfo buildToolInfo = projectState.getBuildToolInfo();
                if (buildToolInfo == null) {
                    buildToolInfo = Sdk.getCurrent().getLatestBuildTool();
                }
                if (buildToolInfo == null) {
                    throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", "No Build Tools installed in the SDK."));
                }
                BuildHelper helper = new BuildHelper(projectState, buildToolInfo, fakeStream, fakeStream, jumbo, dexMerger, debugMode, false, null);
                List<IProject> libProjects = projectState.getFullLibraryProjects();
                File resourceFile = File.createTempFile(TEMP_PREFIX, ".ap_");
                resourceFile.deleteOnExit();
                helper.updateCrunchCache();
                IFolder androidOutputFolder = BaseProjectHelper.getAndroidOutputFolder(project);
                IFile mergedManifestFile = androidOutputFolder.getFile("AndroidManifest.xml");
                helper.packageResources(mergedManifestFile, libProjects, null, 0, resourceFile.getParent(), resourceFile.getName());
                File dexFile = File.createTempFile(TEMP_PREFIX, ".dex");
                dexFile.deleteOnExit();
                ProjectState state = Sdk.getProjectState(project);
                String proguardConfig = state.getProperties().getProperty("proguard.config");
                boolean runProguard = false;
                ArrayList<File> proguardConfigFiles = null;
                if (proguardConfig != null && proguardConfig.length() > 0) {
                    if (File.separatorChar != '/' && proguardConfig.indexOf(47) != -1) {
                        proguardConfig = proguardConfig.replace('/', File.separatorChar);
                    }
                    Iterable paths = LintUtils.splitPath((String)proguardConfig);
                    for (String path : paths) {
                        if (path.startsWith(SDK_PROPERTY_REF)) {
                            path = String.valueOf(AdtPrefs.getPrefs().getOsSdkFolder()) + path.substring(SDK_PROPERTY_REF.length());
                        } else if (path.startsWith(HOME_PROPERTY_REF)) {
                            path = String.valueOf(System.getProperty(HOME_PROPERTY)) + path.substring(HOME_PROPERTY_REF.length());
                        }
                        File proguardConfigFile = new File(path);
                        if (!proguardConfigFile.isAbsolute()) {
                            proguardConfigFile = new File(project.getLocation().toFile(), path);
                        }
                        if (proguardConfigFile.isFile()) {
                            if (proguardConfigFiles == null) {
                                proguardConfigFiles = new ArrayList<File>();
                            }
                            proguardConfigFiles.add(proguardConfigFile);
                            runProguard = true;
                            continue;
                        }
                        throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", "Invalid proguard configuration file path " + proguardConfigFile + " does not exist or is not a regular file", null));
                    }
                    if (proguardConfigFiles != null) {
                        IFile proguardFile = androidOutputFolder.getFile("proguard.txt");
                        proguardConfigFiles.add(proguardFile.getLocation().toFile());
                    }
                }
                if (runProguard) {
                    Collection<String> paths = helper.getCompiledCodePaths();
                    File inputJar = File.createTempFile(TEMP_PREFIX, ".jar");
                    inputJar.deleteOnExit();
                    JarOutputStream jos = new JarOutputStream(new FileOutputStream(inputJar));
                    ArrayList<String> jars = new ArrayList<String>();
                    for (String path : paths) {
                        File root = new File(path);
                        if (root.isDirectory()) {
                            ExportHelper.addFileToJar(jos, root, root);
                            continue;
                        }
                        if (!root.isFile()) continue;
                        jars.add(path);
                    }
                    jos.close();
                    File obfuscatedJar = File.createTempFile(TEMP_PREFIX, ".jar");
                    obfuscatedJar.deleteOnExit();
                    helper.runProguard(proguardConfigFiles, inputJar, jars, obfuscatedJar, new File(project.getLocation().toFile(), "proguard"));
                    helper.setProguardOutput(obfuscatedJar.getAbsolutePath());
                    dxInput = Collections.singletonList(obfuscatedJar.getAbsolutePath());
                } else {
                    dxInput = helper.getCompiledCodePaths();
                }
                IJavaProject javaProject = JavaCore.create((IProject)project);
                helper.executeDx(javaProject, dxInput, dexFile.getAbsolutePath());
                helper.finalPackage(resourceFile.getAbsolutePath(), dexFile.getAbsolutePath(), outputFile.getAbsolutePath(), libProjects, key, certificate, null);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (ProguardResultException e) {
                String msg = String.format("Proguard returned with error code %d. See console", e.getErrorCode());
                AdtPlugin.printErrorToConsole(project, new Object[]{msg});
                AdtPlugin.printErrorToConsole(project, (Object[])e.getOutput());
                throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", msg, (Throwable)e));
            }
            catch (ProguardExecException e) {
                String msg = String.format("Failed to run proguard: %s", e.getMessage());
                AdtPlugin.printErrorToConsole(project, new Object[]{msg});
                throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", msg, (Throwable)e));
            }
            catch (DuplicateFileException e) {
                String msg = String.format("Found duplicate file for APK: %1$s\nOrigin 1: %2$s\nOrigin 2: %3$s", e.getArchivePath(), e.getFile1(), e.getFile2());
                AdtPlugin.printErrorToConsole(project, new Object[]{msg});
                throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", e.getMessage(), (Throwable)e));
            }
            catch (NativeLibInJarException e) {
                String msg = e.getMessage();
                AdtPlugin.printErrorToConsole(project, new Object[]{msg});
                AdtPlugin.printErrorToConsole(project, (Object[])e.getAdditionalInfo());
                throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", e.getMessage(), (Throwable)e));
            }
            catch (DexException e) {
                throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", e.getMessage(), (Throwable)e));
            }
            catch (ApkCreationException e) {
                throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", e.getMessage(), (Throwable)e));
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.android.ide.eclipse.adt", "Failed to export application", (Throwable)e));
            }
        }
        finally {
            ProjectHelper.buildWithDeps(project, 6, monitor);
            project.refreshLocal(2, monitor);
        }
    }

    public static void exportUnsignedReleaseApk(final IProject project) {
        Shell shell = Display.getCurrent().getActiveShell();
        String fileName = String.valueOf(project.getName()) + ".apk";
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setText("Export Project");
        fileDialog.setFileName(fileName);
        final String saveLocation = fileDialog.open();
        if (saveLocation != null) {
            new Job("Android Release Export"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ExportHelper.exportReleaseApk(project, new File(saveLocation), null, null, monitor);
                        AdtPlugin.displayWarning("Android IDE Plug-in", String.format("An unsigned package of the application was saved at\n%1$s\n\nBefore publishing the application you will need to:\n- Sign the application with your release key,\n- run zipalign on the signed package. ZipAlign is located in <SDK>/tools/\n\nAligning applications allows Android to use application resources\nmore efficiently.", saveLocation));
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        AdtPlugin.displayError("Android IDE Plug-in", String.format("Error exporting application:\n\n%1$s", e.getMessage()));
                        return e.getStatus();
                    }
                }
            }.schedule();
        }
    }

    private static void addFileToJar(JarOutputStream jar, File file, File rootDirectory) throws IOException {
        if (file.isDirectory()) {
            if (!file.getName().equals("META-INF")) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    ExportHelper.addFileToJar(jar, child, rootDirectory);
                    ++n2;
                }
            }
        } else if (file.isFile()) {
            String rootPath = rootDirectory.getAbsolutePath();
            String path = file.getAbsolutePath();
            if ((path = path.substring(rootPath.length()).replace("\\", "/")).charAt(0) == '/') {
                path = path.substring(1);
            }
            JarEntry entry = new JarEntry(path);
            entry.setTime(file.lastModified());
            jar.putNextEntry(entry);
            byte[] buffer = new byte[1024];
            BufferedInputStream bis = null;
            try {
                int count;
                bis = new BufferedInputStream(new FileInputStream(file));
                while ((count = bis.read(buffer)) != -1) {
                    jar.write(buffer, 0, count);
                }
            }
            catch (Throwable throwable) {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            jar.closeEntry();
        }
    }
}

