/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.project;

import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.project.XmlErrorHandler;
import com.android.ide.eclipse.adt.io.IFileWrapper;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.xml.sax.SAXException;

public class AndroidManifestHelper {
    public static ManifestData parseUnchecked(IAbstractFile manifestFile, boolean gatherData, XmlErrorHandler.XmlErrorListener errorListener) throws SAXException, IOException, StreamException, ParserConfigurationException {
        if (manifestFile != null) {
            IFile eclipseFile = null;
            if (manifestFile instanceof IFileWrapper) {
                eclipseFile = ((IFileWrapper)manifestFile).getIFile();
            }
            XmlErrorHandler errorHandler = null;
            if (errorListener != null) {
                errorHandler = new XmlErrorHandler(eclipseFile, errorListener);
            }
            return AndroidManifestParser.parse((IAbstractFile)manifestFile, (boolean)gatherData, errorHandler);
        }
        return null;
    }

    public static ManifestData parse(IAbstractFile manifestFile, boolean gatherData, XmlErrorHandler.XmlErrorListener errorListener) {
        try {
            return AndroidManifestHelper.parseUnchecked(manifestFile, gatherData, errorListener);
        }
        catch (ParserConfigurationException e) {
            AdtPlugin.logAndPrintError(e, AndroidManifestHelper.class.getCanonicalName(), "Bad parser configuration for %s: %s", manifestFile.getOsLocation(), e.getMessage());
        }
        catch (SAXException e) {
            AdtPlugin.logAndPrintError(e, AndroidManifestHelper.class.getCanonicalName(), "Parser exception for %s: %s", manifestFile.getOsLocation(), e.getMessage());
        }
        catch (IOException e) {
            if (!(e instanceof FileNotFoundException)) {
                AdtPlugin.logAndPrintError(e, AndroidManifestHelper.class.getCanonicalName(), "I/O error for %s: %s", manifestFile.getOsLocation(), e.getMessage());
            }
        }
        catch (StreamException e) {
            AdtPlugin.logAndPrintError(e, AndroidManifestHelper.class.getCanonicalName(), "Unable to read %s: %s", manifestFile.getOsLocation(), e.getMessage());
        }
        return null;
    }

    public static ManifestData parse(IJavaProject javaProject, boolean gatherData, XmlErrorHandler.XmlErrorListener errorListener) {
        IFile manifestFile = ProjectHelper.getManifest(javaProject.getProject());
        if (manifestFile != null) {
            return AndroidManifestHelper.parse(new IFileWrapper(manifestFile), gatherData, errorListener);
        }
        return null;
    }

    public static void parseForError(IFile manifestFile, XmlErrorHandler.XmlErrorListener errorListener) {
        AndroidManifestHelper.parse(new IFileWrapper(manifestFile), false, errorListener);
    }

    public static ManifestData parseForData(IFile manifestFile) {
        return AndroidManifestHelper.parse(new IFileWrapper(manifestFile), true, null);
    }

    public static ManifestData parseForData(IProject project) {
        IFile manifestFile = ProjectHelper.getManifest(project);
        if (manifestFile != null) {
            return AndroidManifestHelper.parse(new IFileWrapper(manifestFile), true, null);
        }
        return null;
    }

    public static ManifestData parseForData(String osManifestFilePath) {
        return AndroidManifestHelper.parse((IAbstractFile)new FileWrapper(osManifestFilePath), true, null);
    }
}

