/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.lint.LintFix;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

class DosLineEndingsFix
extends LintFix {
    protected DosLineEndingsFix(String id, IMarker marker) {
        super(id, marker);
    }

    @Override
    public boolean needsFocus() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public String getDisplayString() {
        return "Fix line endings";
    }

    public void apply(IDocument document) {
        char next = '\u0000';
        int i = document.getLength() - 1;
        while (i >= 0) {
            try {
                char c = document.getChar(i);
                if (c == '\r' && next != '\n') {
                    document.replace(i, 1, "\n");
                }
                next = c;
            }
            catch (BadLocationException e) {
                AdtPlugin.log(e, null, new Object[0]);
                return;
            }
            --i;
        }
        this.deleteMarker();
    }
}

