/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.lint;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.lint.DocumentFix;
import com.android.ide.eclipse.adt.internal.lint.InputDensityDialog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class ConvertToDpFix
extends DocumentFix
implements IInputValidator {
    private ConvertToDpFix(String id, IMarker marker) {
        super(id, marker);
    }

    @Override
    public boolean needsFocus() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    @Override
    protected void apply(IDocument document, IStructuredModel model, Node node, int start, int end) {
        Shell shell = AdtPlugin.getShell();
        InputDensityDialog densityDialog = new InputDensityDialog(shell);
        if (densityDialog.open() == 0) {
            int dpi = densityDialog.getDensity();
            Element element = (Element)node;
            Pattern pattern = Pattern.compile("(\\d+)px");
            NamedNodeMap attributes = element.getAttributes();
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                Matcher matcher;
                Attr attribute = (Attr)attributes.item(i);
                String value = attribute.getValue();
                if (value.endsWith("px") && (matcher = pattern.matcher(value)).matches()) {
                    String numberString = matcher.group(1);
                    try {
                        int px = Integer.parseInt(numberString);
                        int dp = px * 160 / dpi;
                        String newValue = String.format("%ddp", dp);
                        attribute.setNodeValue(newValue);
                    }
                    catch (NumberFormatException nufe) {
                        AdtPlugin.log(nufe, null, new Object[0]);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public String getDisplayString() {
        return "Convert to \"dp\"...";
    }

    @Override
    public Image getImage() {
        return AdtPlugin.getAndroidLogo();
    }

    public String isValid(String input) {
        if (input == null || input.length() == 0) {
            return " ";
        }
        try {
            int i = Integer.parseInt(input);
            if (i <= 0 || i > 1000) {
                return "Invalid range";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Enter a valid number";
        }
        return null;
    }
}

