/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.ICommitXml;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.NewItemSelectionDialog;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiModelTreeLabelProvider;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class UiActions
implements ICommitXml {
    protected abstract UiElementNode getRootNode();

    @Override
    public abstract void commitPendingXmlChanges();

    protected abstract void selectUiNode(UiElementNode var1);

    public void doAdd(UiElementNode uiNode, Shell shell) {
        this.doAdd(uiNode, null, shell, new UiModelTreeLabelProvider());
    }

    public void doAdd(UiElementNode uiNode, ElementDescriptor[] descriptorFilters, Shell shell, ILabelProvider labelProvider) {
        UiElementNode rootNode = this.getRootNode();
        if (rootNode instanceof UiDocumentNode && rootNode.getUiChildren().size() > 0) {
            rootNode = rootNode.getUiChildren().get(0);
        }
        NewItemSelectionDialog dlg = new NewItemSelectionDialog(shell, labelProvider, descriptorFilters, uiNode, rootNode);
        dlg.open();
        Object[] results = dlg.getResult();
        if (results != null && results.length > 0) {
            this.addElement(dlg.getChosenRootNode(), null, (ElementDescriptor)results[0], true);
        }
    }

    public UiElementNode addElement(UiElementNode uiParent, UiElementNode uiSibling, ElementDescriptor descriptor, boolean updateLayout) {
        if (uiParent instanceof UiDocumentNode && uiParent.getUiChildren().size() > 0) {
            uiParent = uiParent.getUiChildren().get(0);
        }
        if (uiSibling != null && uiSibling.getUiParent() != uiParent) {
            uiSibling = null;
        }
        UiElementNode uiNew = this.addNewTreeElement(uiParent, uiSibling, descriptor, updateLayout);
        this.selectUiNode(uiNew);
        return uiNew;
    }

    public void doRemove(final List<UiElementNode> nodes, Shell shell) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        final int len = nodes.size();
        StringBuilder sb = new StringBuilder();
        for (UiElementNode node : nodes) {
            sb.append("\n- ");
            sb.append(node.getBreadcrumbTrailDescription(false));
        }
        if (MessageDialog.openQuestion((Shell)shell, (String)(len > 1 ? "Remove elements from Android XML" : "Remove element from Android XML"), (String)String.format("Do you really want to remove %1$s?", sb.toString()))) {
            this.commitPendingXmlChanges();
            this.getRootNode().getEditor().wrapEditXmlModel(new Runnable(){

                @Override
                public void run() {
                    UiElementNode previous = null;
                    UiElementNode parent = null;
                    int i = len - 1;
                    while (i >= 0) {
                        UiElementNode node = (UiElementNode)nodes.get(i);
                        previous = node.getUiPreviousSibling();
                        parent = node.getUiParent();
                        node.deleteXmlNode();
                        --i;
                    }
                    if (previous != null) {
                        UiActions.this.selectUiNode(previous);
                    } else if (parent != null) {
                        UiActions.this.selectUiNode(parent);
                    }
                }
            });
        }
    }

    public void doUp(final List<UiElementNode> uiNodes, final ElementDescriptor[] descriptorFilters) {
        if (uiNodes == null || uiNodes.size() < 1) {
            return;
        }
        final Node[] selectXmlNode = new Node[1];
        final UiElementNode[] uiLastNode = new UiElementNode[1];
        final UiElementNode[] uiSearchRoot = new UiElementNode[1];
        this.commitPendingXmlChanges();
        this.getRootNode().getEditor().wrapEditXmlModel(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < uiNodes.size()) {
                    UiElementNode uiNode = uiLastNode[0] = (UiElementNode)uiNodes.get(i);
                    UiActions.this.doUpInternal(uiNode, descriptorFilters, selectXmlNode, uiSearchRoot, false);
                    ++i;
                }
            }
        });
        assert (uiLastNode[0] != null);
        if (selectXmlNode[0] == null) {
            this.selectUiNode(uiLastNode[0]);
        } else {
            if (uiSearchRoot[0] == null) {
                uiSearchRoot[0] = uiLastNode[0].getUiRoot();
            }
            if (uiSearchRoot[0] != null) {
                this.selectUiNode(uiSearchRoot[0].findXmlNode(selectXmlNode[0]));
            }
        }
    }

    public boolean canDoUp(List<UiElementNode> uiNodes, ElementDescriptor[] descriptorFilters) {
        if (uiNodes == null || uiNodes.size() < 1) {
            return false;
        }
        Node[] selectXmlNode = new Node[1];
        UiElementNode[] uiSearchRoot = new UiElementNode[1];
        this.commitPendingXmlChanges();
        int i = 0;
        while (i < uiNodes.size()) {
            if (!this.doUpInternal(uiNodes.get(i), descriptorFilters, selectXmlNode, uiSearchRoot, true)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean doUpInternal(UiElementNode uiNode, ElementDescriptor[] descriptorFilters, Node[] outSelectXmlNode, UiElementNode[] outUiSearchRoot, boolean testOnly) {
        Node xmlParent;
        outUiSearchRoot[0] = uiNode.getUiParent();
        if (outUiSearchRoot[0] != null && outUiSearchRoot[0].getUiParent() != null) {
            outUiSearchRoot[0] = outUiSearchRoot[0].getUiParent();
        }
        Node xmlNode = uiNode.getXmlNode();
        ElementDescriptor nodeDesc = uiNode.getDescriptor();
        if (xmlNode == null || nodeDesc == null) {
            return false;
        }
        UiElementNode uiParentNode = uiNode.getUiParent();
        Node node = xmlParent = uiParentNode == null ? null : uiParentNode.getXmlNode();
        if (xmlParent == null) {
            return false;
        }
        UiElementNode uiPrev = uiNode.getUiPreviousSibling();
        while (!(uiPrev == null || uiPrev.getXmlNode() != null && this.matchDescFilter(descriptorFilters, uiPrev))) {
            uiPrev = uiPrev.getUiPreviousSibling();
        }
        if (uiPrev != null && uiPrev.getXmlNode() != null) {
            Node xmlPrev = uiPrev.getXmlNode();
            if (uiPrev.getDescriptor().acceptChild(nodeDesc)) {
                if (testOnly) {
                    return true;
                }
                xmlPrev.appendChild(xmlParent.removeChild(xmlNode));
                outSelectXmlNode[0] = xmlNode;
            } else {
                if (testOnly) {
                    return true;
                }
                xmlParent.insertBefore(xmlParent.removeChild(xmlNode), xmlPrev);
                outSelectXmlNode[0] = xmlNode;
            }
        } else if (uiParentNode != null && !(xmlParent instanceof Document)) {
            ElementDescriptor grandDesc;
            UiElementNode uiGrandParent = uiParentNode.getUiParent();
            Node xmlGrandParent = uiGrandParent == null ? null : uiGrandParent.getXmlNode();
            ElementDescriptor elementDescriptor = grandDesc = uiGrandParent == null ? null : uiGrandParent.getDescriptor();
            if (xmlGrandParent != null && !(xmlGrandParent instanceof Document) && grandDesc != null && grandDesc.acceptChild(nodeDesc)) {
                if (testOnly) {
                    return true;
                }
                xmlGrandParent.insertBefore(xmlParent.removeChild(xmlNode), xmlParent);
                outSelectXmlNode[0] = xmlNode;
            }
        }
        return false;
    }

    private boolean matchDescFilter(ElementDescriptor[] descriptorFilters, UiElementNode uiNode) {
        if (descriptorFilters == null || descriptorFilters.length < 1) {
            return true;
        }
        ElementDescriptor desc = uiNode.getDescriptor();
        ElementDescriptor[] elementDescriptorArray = descriptorFilters;
        int n = descriptorFilters.length;
        int n2 = 0;
        while (n2 < n) {
            ElementDescriptor filter = elementDescriptorArray[n2];
            if (filter.equals(desc)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void doDown(final List<UiElementNode> nodes, final ElementDescriptor[] descriptorFilters) {
        if (nodes == null || nodes.size() < 1) {
            return;
        }
        final Node[] selectXmlNode = new Node[1];
        final UiElementNode[] uiLastNode = new UiElementNode[1];
        final UiElementNode[] uiSearchRoot = new UiElementNode[1];
        this.commitPendingXmlChanges();
        this.getRootNode().getEditor().wrapEditXmlModel(new Runnable(){

            @Override
            public void run() {
                int i = nodes.size() - 1;
                while (i >= 0) {
                    UiElementNode node = uiLastNode[0] = (UiElementNode)nodes.get(i);
                    UiActions.this.doDownInternal(node, descriptorFilters, selectXmlNode, uiSearchRoot, false);
                    --i;
                }
            }
        });
        assert (uiLastNode[0] != null);
        if (selectXmlNode[0] == null) {
            this.selectUiNode(uiLastNode[0]);
        } else {
            if (uiSearchRoot[0] == null) {
                uiSearchRoot[0] = uiLastNode[0].getUiRoot();
            }
            if (uiSearchRoot[0] != null) {
                this.selectUiNode(uiSearchRoot[0].findXmlNode(selectXmlNode[0]));
            }
        }
    }

    public boolean canDoDown(List<UiElementNode> uiNodes, ElementDescriptor[] descriptorFilters) {
        if (uiNodes == null || uiNodes.size() < 1) {
            return false;
        }
        Node[] selectXmlNode = new Node[1];
        UiElementNode[] uiSearchRoot = new UiElementNode[1];
        this.commitPendingXmlChanges();
        int i = 0;
        while (i < uiNodes.size()) {
            if (!this.doDownInternal(uiNodes.get(i), descriptorFilters, selectXmlNode, uiSearchRoot, true)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean doDownInternal(UiElementNode uiNode, ElementDescriptor[] descriptorFilters, Node[] outSelectXmlNode, UiElementNode[] outUiSearchRoot, boolean testOnly) {
        Node xmlParent;
        outUiSearchRoot[0] = uiNode.getUiParent();
        if (outUiSearchRoot[0] != null && outUiSearchRoot[0].getUiParent() != null) {
            outUiSearchRoot[0] = outUiSearchRoot[0].getUiParent();
        }
        Node xmlNode = uiNode.getXmlNode();
        ElementDescriptor nodeDesc = uiNode.getDescriptor();
        if (xmlNode == null || nodeDesc == null) {
            return false;
        }
        UiElementNode uiParentNode = uiNode.getUiParent();
        Node node = xmlParent = uiParentNode == null ? null : uiParentNode.getXmlNode();
        if (xmlParent == null) {
            return false;
        }
        UiElementNode uiNext = uiNode.getUiNextSibling();
        while (!(uiNext == null || uiNext.getXmlNode() != null && this.matchDescFilter(descriptorFilters, uiNext))) {
            uiNext = uiNext.getUiNextSibling();
        }
        if (uiNext != null && uiNext.getXmlNode() != null) {
            Node xmlNext = uiNext.getXmlNode();
            if (uiNext.getDescriptor().acceptChild(nodeDesc)) {
                if (testOnly) {
                    return true;
                }
                xmlNext.insertBefore(xmlParent.removeChild(xmlNode), xmlNext.getFirstChild());
                outSelectXmlNode[0] = xmlNode;
            } else {
                if (testOnly) {
                    return true;
                }
                xmlParent.insertBefore(xmlParent.removeChild(xmlNode), xmlNext.getNextSibling());
                outSelectXmlNode[0] = xmlNode;
            }
        } else if (uiParentNode != null && !(xmlParent instanceof Document)) {
            ElementDescriptor grandDesc;
            UiElementNode uiGrandParent = uiParentNode.getUiParent();
            Node xmlGrandParent = uiGrandParent == null ? null : uiGrandParent.getXmlNode();
            ElementDescriptor elementDescriptor = grandDesc = uiGrandParent == null ? null : uiGrandParent.getDescriptor();
            if (xmlGrandParent != null && !(xmlGrandParent instanceof Document) && grandDesc != null && grandDesc.acceptChild(nodeDesc)) {
                if (testOnly) {
                    return true;
                }
                xmlGrandParent.insertBefore(xmlParent.removeChild(xmlNode), xmlParent.getNextSibling());
                outSelectXmlNode[0] = xmlNode;
            }
        }
        return false;
    }

    private UiElementNode addNewTreeElement(UiElementNode uiParent, UiElementNode uiSibling, ElementDescriptor descriptor, final boolean updateLayout) {
        int n;
        this.commitPendingXmlChanges();
        List<UiElementNode> uiChildren = uiParent.getUiChildren();
        int index = n = uiChildren.size();
        if (uiSibling != null && (index = uiChildren.indexOf(uiSibling)) < 0) {
            uiSibling = null;
            index = n;
        }
        if (uiSibling == null) {
            int i = 0;
            while (i < n) {
                UiElementNode uiChild = uiChildren.get(i);
                if (uiChild.getDescriptor().getMandatory() == ElementDescriptor.Mandatory.MANDATORY_LAST) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        final UiElementNode uiNew = uiParent.insertNewUiChild(index, descriptor);
        UiElementNode rootNode = this.getRootNode();
        rootNode.getEditor().wrapEditXmlModel(new Runnable(){

            @Override
            public void run() {
                DescriptorsUtils.setDefaultLayoutAttributes(uiNew, updateLayout);
                uiNew.createXmlNode();
            }
        });
        return uiNew;
    }
}

