/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.model;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextAttributeNode;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewPackageWizardAction;
import org.eclipse.jdt.ui.actions.ShowInPackageViewAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UiPackageAttributeNode
extends UiTextAttributeNode {
    public UiPackageAttributeNode(AttributeDescriptor attributeDescriptor, UiElementNode uiParent) {
        super(attributeDescriptor, uiParent);
    }

    @Override
    public void createUiControl(Composite parent, IManagedForm managedForm) {
        this.setManagedForm(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        TextAttributeDescriptor desc = (TextAttributeDescriptor)this.getDescriptor();
        StringBuilder label = new StringBuilder();
        label.append("<form><p><a href='unused'>");
        label.append(desc.getUiName());
        label.append("</a></p></form>");
        FormText formText = SectionHelper.createFormText(parent, toolkit, true, label.toString(), true);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                super.linkActivated(e);
                UiPackageAttributeNode.this.doLabelClick();
            }
        });
        formText.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)formText, desc.getTooltip());
        Composite composite = toolkit.createComposite(parent);
        composite.setLayoutData((Object)new TableWrapData(256, 32));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        toolkit.paintBordersFor(composite);
        Text text = toolkit.createText(composite, this.getCurrentValue());
        GridData gd = new GridData(768);
        gd.horizontalIndent = 1;
        text.setLayoutData((Object)gd);
        this.setTextWidget(text);
        Button browseButton = toolkit.createButton(composite, "Browse...", 8);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiPackageAttributeNode.this.doBrowseClick();
            }
        });
    }

    @Override
    protected void onAddValidators(final Text text) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String package_name = text.getText();
                if (package_name.indexOf(46) < 1) {
                    UiPackageAttributeNode.this.getManagedForm().getMessageManager().addMessage((Object)text, "Package name should contain at least two identifiers.", null, 3, (Control)text);
                } else {
                    UiPackageAttributeNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
                }
            }
        };
        text.addModifyListener(listener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UiPackageAttributeNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
            }
        });
        listener.modifyText(null);
    }

    private void doBrowseClick() {
        Text text = this.getTextWidget();
        IProject project = this.getProject();
        if (project != null) {
            try {
                Object[] results;
                SelectionDialog dlg = JavaUI.createPackageDialog((Shell)text.getShell(), (IJavaProject)JavaCore.create((IProject)project), (int)0);
                dlg.setTitle("Select Android Package");
                dlg.setMessage("Select the package for the Android project.");
                SelectionDialog.setDefaultImage((Image)AdtPlugin.getAndroidLogo());
                if (dlg.open() == 0 && (results = dlg.getResult()).length == 1) {
                    this.setPackageTextField((IPackageFragment)results[0]);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void doLabelClick() {
        String package_name = this.getTextWidget().getText().trim();
        if (package_name.length() == 0) {
            this.createNewPackage();
        } else {
            IProject project = this.getProject();
            if (project == null) {
                AdtPlugin.log(4, "Failed to get project for UiPackageAttribute", new Object[0]);
                return;
            }
            IWorkbenchPartSite site = this.getUiParent().getEditor().getSite();
            if (site == null) {
                AdtPlugin.log(4, "Failed to get editor site for UiPackageAttribute", new Object[0]);
                return;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots(project);
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IPackageFragment fragment = root.getPackageFragment(package_name);
                if (fragment != null && fragment.exists()) {
                    ShowInPackageViewAction action = new ShowInPackageViewAction((IWorkbenchSite)site);
                    action.run((IJavaElement)fragment);
                    return;
                }
                ++n2;
            }
        }
    }

    private IProject getProject() {
        UiElementNode uiNode = this.getUiParent();
        AndroidXmlEditor editor = uiNode.getEditor();
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            return file.getProject();
        }
        return null;
    }

    private IPackageFragmentRoot[] getPackageFragmentRoots(IProject project) {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IClasspathEntry entry = roots[i].getRawClasspathEntry();
                if (entry.getEntryKind() == 3) {
                    result.add(roots[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private void setPackageTextField(IPackageFragment type) {
        Text text = this.getTextWidget();
        String name = type.getElementName();
        text.setText(name);
    }

    private void createNewPackage() {
        OpenNewPackageWizardAction action = new OpenNewPackageWizardAction();
        IProject project = this.getProject();
        action.setSelection((IStructuredSelection)new StructuredSelection((Object)project));
        action.run();
        IJavaElement element = action.getCreatedElement();
        if (element != null && element.exists() && element.getElementType() == 4) {
            this.setPackageTextField((IPackageFragment)element);
        }
    }

    @Override
    public String[] getPossibleValues(String prefix) {
        return null;
    }
}

