/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.refactoring;

import com.android.ide.common.api.IViewMetadata;
import com.android.ide.common.layout.BaseLayoutRule;
import com.android.ide.common.layout.GravityHelper;
import com.android.ide.common.layout.GridLayoutRule;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.ViewMetadataRepository;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.ChangeLayoutRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoring;
import com.android.ide.eclipse.adt.internal.project.SupportLibraryHelper;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class GridLayoutConverter {
    private final MultiTextEdit mRootEdit;
    private final boolean mFlatten;
    private final Element mLayout;
    private final ChangeLayoutRefactoring mRefactoring;
    private final CanvasViewInfo mRootView;
    private List<View> mViews;
    private String mNamespace;
    private int mColumnCount;

    GridLayoutConverter(ChangeLayoutRefactoring refactoring, Element layout, boolean flatten, MultiTextEdit rootEdit, CanvasViewInfo rootView) {
        this.mRefactoring = refactoring;
        this.mLayout = layout;
        this.mFlatten = flatten;
        this.mRootEdit = rootEdit;
        this.mRootView = rootView;
    }

    public void convertToGridLayout() {
        if (this.mRootView == null) {
            return;
        }
        CanvasViewInfo layoutView = this.findViewForElement(this.mRootView, this.mLayout);
        if (layoutView == null || layoutView.getChildren().size() == 0) {
            return;
        }
        GridModel gridModel = new GridModel(layoutView, this.mLayout, this.mFlatten);
        this.mViews = gridModel.getViews();
        this.mColumnCount = gridModel.computeColumnCount();
        this.deleteRemovedElements(gridModel.getDeletedElements());
        this.mNamespace = this.mRefactoring.getAndroidNamespacePrefix();
        this.processGravities();
        this.insertStretchableSpans();
        this.assignGridAttributes();
        this.removeUndefinedAttrs();
        if (this.mColumnCount > 0) {
            this.mRefactoring.setAttribute(this.mRootEdit, this.mLayout, "http://schemas.android.com/apk/res/android", this.mNamespace, "columnCount", Integer.toString(this.mColumnCount));
        }
    }

    private void insertStretchableSpans() {
        boolean fixed;
        HashMap<Integer, Boolean> rowFixed = new HashMap<Integer, Boolean>();
        HashMap<Integer, Boolean> columnFixed = new HashMap<Integer, Boolean>();
        for (View view : this.mViews) {
            if (view.mElement == this.mLayout) continue;
            int gravity = GravityHelper.getGravity(view.mGravity, 0);
            if ((gravity & 0x30F) == 0) {
                columnFixed.put(view.mCol, true);
            } else if (!columnFixed.containsKey(view.mCol)) {
                columnFixed.put(view.mCol, false);
            }
            if ((gravity & 0xF0) == 0) {
                rowFixed.put(view.mRow, true);
                continue;
            }
            if (rowFixed.containsKey(view.mRow)) continue;
            rowFixed.put(view.mRow, false);
        }
        boolean hasStretchableRow = false;
        boolean hasStretchableColumn = false;
        Iterator iterator = rowFixed.values().iterator();
        while (iterator.hasNext()) {
            fixed = (Boolean)iterator.next();
            if (fixed) continue;
            hasStretchableRow = true;
        }
        iterator = columnFixed.values().iterator();
        while (iterator.hasNext()) {
            fixed = (Boolean)iterator.next();
            if (fixed) continue;
            hasStretchableColumn = true;
        }
        if (!hasStretchableRow || !hasStretchableColumn) {
            String gravity;
            int offset = 0;
            String gridLayout = this.mLayout.getTagName();
            if (this.mLayout instanceof IndexedRegion) {
                IndexedRegion region = (IndexedRegion)this.mLayout;
                int end = region.getEndOffset();
                offset = end -= gridLayout.length() + 3;
            }
            int row = rowFixed.size();
            int column = columnFixed.size();
            StringBuilder sb = new StringBuilder(64);
            String spaceTag = "Space";
            IFile file = this.mRefactoring.getFile();
            if (file != null && (spaceTag = SupportLibraryHelper.getTagFor(file.getProject(), "android.widget.Space")).equals("android.widget.Space")) {
                spaceTag = "Space";
            }
            sb.append('<').append(spaceTag).append(' ');
            if (!hasStretchableRow && !hasStretchableColumn) {
                gravity = "fill";
            } else if (!hasStretchableRow) {
                gravity = "fill_vertical";
            } else {
                assert (!hasStretchableColumn);
                gravity = "fill_horizontal";
            }
            sb.append(this.mNamespace).append(':');
            sb.append("layout_gravity").append('=').append('\"').append(gravity);
            sb.append('\"').append(' ');
            sb.append(this.mNamespace).append(':');
            sb.append("layout_row").append('=').append('\"').append(Integer.toString(row));
            sb.append('\"').append(' ');
            sb.append(this.mNamespace).append(':');
            sb.append("layout_column").append('=').append('\"').append(Integer.toString(column));
            sb.append('\"').append('/').append('>');
            String space = sb.toString();
            InsertEdit replace = new InsertEdit(offset, space);
            this.mRootEdit.addChild((TextEdit)replace);
            ++this.mColumnCount;
        }
    }

    private void removeUndefinedAttrs() {
        AttributeDescriptor[] layoutAttributes;
        ViewElementDescriptor descriptor = this.mRefactoring.getElementDescriptor("android.widget.GridLayout");
        if (descriptor == null) {
            return;
        }
        HashSet<String> defined = new HashSet<String>();
        AttributeDescriptor[] attributeDescriptorArray = layoutAttributes = descriptor.getLayoutAttributes();
        int n = layoutAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor attribute = attributeDescriptorArray[n2];
            defined.add(attribute.getXmlLocalName());
            ++n2;
        }
        for (View view : this.mViews) {
            Element child = view.mElement;
            List<Attr> attributes = this.mRefactoring.findLayoutAttributes(child);
            for (Attr attribute : attributes) {
                String name = attribute.getLocalName();
                if (defined.contains(name)) continue;
                try {
                    this.mRefactoring.removeAttribute(this.mRootEdit, child, attribute.getNamespaceURI(), name);
                }
                catch (MalformedTreeException malformedTreeException) {
                    AdtPlugin.log(2, "Could not remove unsupported attribute %1$s; already modified during refactoring?", attribute.getLocalName());
                }
            }
        }
    }

    private void deleteRemovedElements(List<Element> delete) {
        if (this.mFlatten && delete.size() > 0) {
            for (Element element : delete) {
                this.mRefactoring.removeElementTags(this.mRootEdit, element, delete, false);
            }
        }
    }

    private void assignGridAttributes() {
        this.mRefactoring.setAttribute(this.mRootEdit, this.mLayout, "http://schemas.android.com/apk/res/android", this.mNamespace, "orientation", "horizontal");
        this.assignCellAttributes();
    }

    private void assignCellAttributes() {
        int implicitRow = 0;
        int implicitColumn = 0;
        int nextRow = 0;
        for (View view : this.mViews) {
            Attr height;
            Element element = view.getElement();
            if (element == this.mLayout) continue;
            int row = view.getRow();
            int column = view.getColumn();
            if (column != implicitColumn && (implicitColumn > 0 || implicitRow > 0)) {
                this.mRefactoring.setAttribute(this.mRootEdit, element, "http://schemas.android.com/apk/res/android", this.mNamespace, "layout_column", Integer.toString(column));
                if (column < implicitColumn) {
                    ++implicitRow;
                }
                implicitColumn = column;
            }
            if (row != implicitRow) {
                this.mRefactoring.setAttribute(this.mRootEdit, element, "http://schemas.android.com/apk/res/android", this.mNamespace, "layout_row", Integer.toString(row));
                implicitRow = row;
            }
            int rowSpan = view.getRowSpan();
            int columnSpan = view.getColumnSpan();
            assert (columnSpan >= 1);
            if (rowSpan > 1) {
                this.mRefactoring.setAttribute(this.mRootEdit, element, "http://schemas.android.com/apk/res/android", this.mNamespace, "layout_rowSpan", Integer.toString(rowSpan));
            }
            if (columnSpan > 1) {
                this.mRefactoring.setAttribute(this.mRootEdit, element, "http://schemas.android.com/apk/res/android", this.mNamespace, "layout_columnSpan", Integer.toString(columnSpan));
            }
            nextRow = Math.max(nextRow, row + rowSpan);
            Attr width = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_width");
            if (width != null && "wrap_content".equals(width.getValue())) {
                this.mRefactoring.removeAttribute(this.mRootEdit, width);
            }
            if ((height = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_height")) != null && "wrap_content".equals(height.getValue())) {
                this.mRefactoring.removeAttribute(this.mRootEdit, height);
            }
            if ("LinearLayout".equals(element.getParentNode().getNodeName())) {
                this.convert0dipToWrapContent(element);
            }
            if ((implicitColumn += columnSpan) < this.mColumnCount) continue;
            implicitColumn = 0;
            assert (nextRow > implicitRow);
            implicitRow = nextRow;
        }
    }

    private void processGravities() {
        for (View view : this.mViews) {
            ElementDescriptor descriptor;
            Element element = view.getElement();
            if (element == this.mLayout) continue;
            Attr width = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_width");
            Attr height = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_height");
            String gravity = element.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity");
            String newGravity = null;
            if (width != null && ("match_parent".equals(width.getValue()) || "fill_parent".equals(width.getValue()))) {
                this.mRefactoring.removeAttribute(this.mRootEdit, width);
                gravity = "fill_horizontal";
                newGravity = "fill_horizontal";
            }
            if (height != null && ("match_parent".equals(height.getValue()) || "fill_parent".equals(height.getValue()))) {
                this.mRefactoring.removeAttribute(this.mRootEdit, height);
                newGravity = newGravity == "fill_horizontal" ? "fill" : "fill_vertical";
                gravity = newGravity;
            }
            if ((gravity == null || gravity.length() == 0) && (descriptor = view.mInfo.getUiViewNode().getDescriptor()) instanceof ViewElementDescriptor) {
                ViewElementDescriptor viewDescriptor = (ViewElementDescriptor)descriptor;
                String fqcn = viewDescriptor.getFullClassName();
                IViewMetadata.FillPreference fill = ViewMetadataRepository.get().getFillPreference(fqcn);
                gravity = GridLayoutRule.computeDefaultGravity(fill);
                if (gravity != null) {
                    newGravity = gravity;
                }
            }
            if (newGravity != null) {
                this.mRefactoring.setAttribute(this.mRootEdit, element, "http://schemas.android.com/apk/res/android", this.mNamespace, "layout_gravity", newGravity);
            }
            view.mGravity = newGravity != null ? newGravity : gravity;
        }
    }

    private void convert0dipToWrapContent(Element child) {
        Attr width;
        Attr height = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_height");
        if (height != null && height.getValue().startsWith("0")) {
            this.mRefactoring.removeAttribute(this.mRootEdit, height);
        }
        if ((width = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_width")) != null && width.getValue().startsWith("0")) {
            this.mRefactoring.removeAttribute(this.mRootEdit, width);
        }
    }

    private CanvasViewInfo findViewForElement(CanvasViewInfo info, Element element) {
        if (GridLayoutConverter.getElement(info) == element) {
            return info;
        }
        for (CanvasViewInfo child : info.getChildren()) {
            CanvasViewInfo result = this.findViewForElement(child, element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Element getElement(CanvasViewInfo info) {
        Node node = info.getUiViewNode().getXmlNode();
        if (node instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    private static class GridModel {
        private final List<View> mViews = new ArrayList<View>();
        private final List<Element> mDelete = new ArrayList<Element>();
        private final Map<Element, View> mElementToView = new HashMap<Element, View>();
        private Element mLayout;
        private boolean mFlatten;

        GridModel(CanvasViewInfo view, Element layout, boolean flatten) {
            this.mLayout = layout;
            this.mFlatten = flatten;
            this.scan(view, true);
            this.analyzeKnownLayouts();
            this.initializeColumns();
            this.initializeRows();
            this.mDelete.remove(GridLayoutConverter.getElement(view));
        }

        public List<View> getViews() {
            return this.mViews;
        }

        public List<Element> getDeletedElements() {
            return this.mDelete;
        }

        public int computeColumnCount() {
            int columnCount = 0;
            for (View view : this.mViews) {
                int columnSpan;
                int column;
                if (view.getElement() == this.mLayout || (column = view.getColumn()) + (columnSpan = view.getColumnSpan()) <= columnCount) continue;
                columnCount = column + columnSpan;
            }
            return columnCount;
        }

        private void initializeColumns() {
            HashMap<Integer, ArrayList<View>> mColumnViews = new HashMap<Integer, ArrayList<View>>();
            for (View view : this.mViews) {
                if (view.mElement == this.mLayout) continue;
                int x = view.getLeftEdge();
                ArrayList<View> list = (ArrayList<View>)mColumnViews.get(x);
                if (list == null) {
                    list = new ArrayList<View>();
                    mColumnViews.put(x, list);
                }
                list.add(view);
            }
            ArrayList columnOffsets = new ArrayList(mColumnViews.keySet());
            Collections.sort(columnOffsets);
            int columnIndex = 0;
            for (Integer column : columnOffsets) {
                List views = (List)mColumnViews.get(column);
                if (views != null) {
                    for (View view : views) {
                        view.mCol = columnIndex;
                    }
                }
                ++columnIndex;
            }
            for (View view : this.mViews) {
                if (view.mElement == this.mLayout) continue;
                int index = Collections.binarySearch(columnOffsets, view.getRightEdge());
                int column = index == -1 ? 0 : (index < 0 ? -(index + 2) : index);
                if (column < view.mCol) {
                    column = view.mCol;
                }
                view.mColSpan = column - view.mCol + 1;
            }
        }

        private void initializeRows() {
            HashMap<Integer, ArrayList<View>> mRowViews = new HashMap<Integer, ArrayList<View>>();
            for (View view : this.mViews) {
                if (view.mElement == this.mLayout) continue;
                int y = view.getTopEdge();
                ArrayList<View> list = (ArrayList<View>)mRowViews.get(y);
                if (list == null) {
                    list = new ArrayList<View>();
                    mRowViews.put(y, list);
                }
                list.add(view);
            }
            ArrayList rowOffsets = new ArrayList(mRowViews.keySet());
            Collections.sort(rowOffsets);
            int rowIndex = 0;
            for (Integer row : rowOffsets) {
                List views = (List)mRowViews.get(row);
                if (views != null) {
                    for (View view : views) {
                        view.mRow = rowIndex;
                    }
                }
                ++rowIndex;
            }
            for (View view : this.mViews) {
                if (view.mElement == this.mLayout) continue;
                int index = Collections.binarySearch(rowOffsets, view.getBottomEdge());
                int row = index == -1 ? 0 : (index < 0 ? -(index + 2) : index);
                if (row < view.mRow) {
                    row = view.mRow;
                }
                view.mRowSpan = row - view.mRow + 1;
            }
        }

        private View scan(CanvasViewInfo view, boolean isRoot) {
            View added = null;
            if (!this.mFlatten || !this.isRemovableLayout(view)) {
                added = this.add(view);
                if (!isRoot) {
                    return added;
                }
            } else {
                this.mDelete.add(GridLayoutConverter.getElement(view));
            }
            for (CanvasViewInfo child : view.getChildren()) {
                Element childElement = GridLayoutConverter.getElement(child);
                if (this.mFlatten && this.isRemovableLayout(child)) {
                    for (CanvasViewInfo childView : child.getChildren()) {
                        this.scan(childView, false);
                    }
                    this.mDelete.add(childElement);
                    continue;
                }
                this.scan(child, false);
            }
            return added;
        }

        private View add(CanvasViewInfo info) {
            Element element = GridLayoutConverter.getElement(info);
            View view = new View(info, element);
            this.mViews.add(view);
            this.mElementToView.put(element, view);
            return view;
        }

        private void analyzeKnownLayouts() {
            View view;
            Iterator<Element> iterator;
            HashSet<Element> parents = new HashSet<Element>();
            for (View view2 : this.mViews) {
                Node node = view2.getElement().getParentNode();
                if (!(node instanceof Element)) continue;
                parents.add((Element)node);
            }
            ArrayList<AbstractCollection> rowGroups = new ArrayList<AbstractCollection>();
            ArrayList<AbstractCollection> columnGroups = new ArrayList<AbstractCollection>();
            for (Element element : parents) {
                String tagName = element.getTagName();
                if (tagName.equals("LinearLayout") || tagName.equals("TableLayout") || tagName.equals("TableRow") || tagName.equals("RadioGroup")) {
                    HashSet<View> group = new HashSet<View>();
                    for (Element child : DomUtilities.getChildren(element)) {
                        View view3 = this.mElementToView.get(child);
                        if (view3 == null) continue;
                        group.add(view3);
                    }
                    if (group.size() <= 1) continue;
                    boolean isVertical = "vertical".equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation"));
                    if (tagName.equals("TableLayout")) {
                        isVertical = true;
                    } else if (tagName.equals("TableRow")) {
                        isVertical = false;
                    }
                    if (isVertical) {
                        columnGroups.add(group);
                        continue;
                    }
                    rowGroups.add(group);
                    continue;
                }
                if (!tagName.equals("RelativeLayout")) continue;
                List<Element> children = DomUtilities.getChildren(element);
                for (Element child : children) {
                    View view2 = this.mElementToView.get(child);
                    if (view2 == null) continue;
                    NamedNodeMap attributes = child.getAttributes();
                    int i = 0;
                    int n = attributes.getLength();
                    while (i < n) {
                        Attr attr = (Attr)attributes.item(i);
                        String name = attr.getLocalName();
                        if (name.startsWith("layout_")) {
                            String value;
                            boolean alignHorizontal;
                            boolean alignVertical = name.equals("layout_alignTop") || name.equals("layout_alignBottom") || name.equals("layout_alignBaseline");
                            boolean bl = alignHorizontal = name.equals("layout_alignLeft") || name.equals("layout_alignRight");
                            if ((alignVertical || alignHorizontal) && ((value = attr.getValue()).startsWith("@id/") || value.startsWith("@+id/"))) {
                                String targetName = BaseLayoutRule.stripIdPrefix(value);
                                Element target = null;
                                for (Element c : children) {
                                    String id = VisualRefactoring.getId(c);
                                    if (!targetName.equals(BaseLayoutRule.stripIdPrefix(id))) continue;
                                    target = c;
                                    break;
                                }
                                View targetView = this.mElementToView.get(target);
                                if (targetView != null) {
                                    ArrayList<View> group = new ArrayList<View>(2);
                                    group.add(view2);
                                    group.add(targetView);
                                    if (alignHorizontal) {
                                        columnGroups.add(group);
                                    } else {
                                        assert (alignVertical);
                                        rowGroups.add(group);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            for (Collection collection : rowGroups) {
                Iterator iterator2 = collection.iterator();
                int smallest = ((View)iterator2.next()).mY1;
                while (iterator2.hasNext()) {
                    smallest = Math.min(smallest, ((View)iterator2.next()).mY1);
                }
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    View view3 = view = (View)((Object)iterator.next());
                    view3.mY2 = view3.mY2 - (view.mY1 - smallest);
                    view.mY1 = smallest;
                }
            }
            for (Collection collection : columnGroups) {
                Iterator iterator2 = collection.iterator();
                int smallest = ((View)iterator2.next()).mX1;
                while (iterator2.hasNext()) {
                    smallest = Math.min(smallest, ((View)iterator2.next()).mX1);
                }
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    View view4 = view = (View)((Object)iterator.next());
                    view4.mX2 = view4.mX2 - (view.mX1 - smallest);
                    view.mX1 = smallest;
                }
            }
        }

        private boolean isRemovableLayout(CanvasViewInfo child) {
            Element element = GridLayoutConverter.getElement(child);
            if (element == this.mLayout) {
                return false;
            }
            ElementDescriptor descriptor = child.getUiViewNode().getDescriptor();
            String name = descriptor.getXmlLocalName();
            if (name.equals("LinearLayout") || name.equals("RelativeLayout") || name.equals("TableLayout") || name.equals("TableRow")) {
                if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background")) {
                    AdtPlugin.log(2, "Did not flatten layout %1$s because it defines a '%2$s' attribute", VisualRefactoring.getId(element), "background");
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class View {
        private final Element mElement;
        private int mRow = -1;
        private int mCol = -1;
        private int mRowSpan = -1;
        private int mColSpan = -1;
        private int mX1;
        private int mY1;
        private int mX2;
        private int mY2;
        private CanvasViewInfo mInfo;
        private String mGravity;

        public View(CanvasViewInfo view, Element element) {
            this.mInfo = view;
            this.mElement = element;
            Rectangle b = this.mInfo.getAbsRect();
            this.mX1 = b.x;
            this.mX2 = b.x + b.width;
            this.mY1 = b.y;
            this.mY2 = b.y + b.height;
        }

        public Element getElement() {
            return this.mElement;
        }

        public int getRow() {
            return this.mRow;
        }

        public int getColumn() {
            return this.mCol;
        }

        public int getRowSpan() {
            return this.mRowSpan;
        }

        public int getColumnSpan() {
            return this.mColSpan;
        }

        public int getLeftEdge() {
            return this.mX1;
        }

        public int getTopEdge() {
            return this.mY1;
        }

        public int getRightEdge() {
            return this.mX2;
        }

        public int getBottomEdge() {
            return this.mY2;
        }

        public String toString() {
            return "View(" + VisualRefactoring.getId(this.mElement) + ": " + this.mX1 + "," + this.mY1 + ")";
        }
    }
}

