/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.refactoring;

import com.android.annotations.NonNull;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.formatting.EclipseXmlFormatPreferences;
import com.android.ide.eclipse.adt.internal.editors.formatting.EclipseXmlPrettyPrinter;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.ExtractIncludeWizard;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoring;
import com.android.ide.eclipse.adt.internal.editors.layout.refactoring.VisualRefactoringWizard;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import com.android.ide.eclipse.adt.internal.resources.ResourceNameValidator;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ExtractIncludeRefactoring
extends VisualRefactoring {
    private static final String KEY_NAME = "name";
    private static final String KEY_OCCURRENCES = "all-occurrences";
    private String mLayoutName;
    private boolean mReplaceOccurrences;

    ExtractIncludeRefactoring(Map<String, String> arguments) {
        super(arguments);
        this.mLayoutName = arguments.get(KEY_NAME);
        this.mReplaceOccurrences = Boolean.parseBoolean(arguments.get(KEY_OCCURRENCES));
    }

    public ExtractIncludeRefactoring(IFile file, LayoutEditorDelegate delegate, ITextSelection selection, ITreeSelection treeSelection) {
        super(file, delegate, selection, treeSelection);
    }

    ExtractIncludeRefactoring(List<Element> selectedElements, LayoutEditorDelegate editor) {
        super(selectedElements, editor);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            pm.beginTask("Checking preconditions...", 6);
            if (this.mSelectionStart == -1 || this.mSelectionEnd == -1) {
                status.addFatalError("No selection to extract");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mTreeSelection != null) {
                Node xmlNode;
                UiViewElementNode uiNode;
                List<CanvasViewInfo> infos = this.getSelectedViewInfos();
                if (!this.validateNotEmpty(infos, status)) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
                if (!this.validateNotRoot(infos, status)) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
                if (infos.size() == 1 && (uiNode = infos.get(0).getUiViewNode()) != null && (xmlNode = uiNode.getXmlNode()).getLocalName().equals("include")) {
                    status.addWarning("No point in refactoring a single include tag");
                }
                if (!this.validateContiguous(infos, status)) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
            }
            if (this.mElements.size() == 0) {
                status.addFatalError("Nothing to extract");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    @Override
    protected VisualRefactoring.VisualRefactoringDescriptor createDescriptor() {
        String comment = this.getName();
        return new Descriptor(this.mProject.getName(), comment, comment, this.createArgumentMap());
    }

    @Override
    protected Map<String, String> createArgumentMap() {
        Map<String, String> args = super.createArgumentMap();
        args.put(KEY_NAME, this.mLayoutName);
        args.put(KEY_OCCURRENCES, Boolean.toString(this.mReplaceOccurrences));
        return args;
    }

    public String getName() {
        return "Extract as Include";
    }

    void setLayoutName(String layoutName) {
        this.mLayoutName = layoutName;
    }

    void setReplaceOccurrences(boolean selection) {
        this.mReplaceOccurrences = selection;
    }

    @Override
    @NonNull
    protected List<Change> computeChanges(IProgressMonitor monitor) {
        String extractedText = this.getExtractedText();
        String namespaceDeclarations = this.computeNamespaceDeclarations();
        extractedText = this.insertNamespace(extractedText, namespaceDeclarations);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append(extractedText);
        sb.append('\n');
        ArrayList<Change> changes = new ArrayList<Change>();
        String newFileName = String.valueOf(this.mLayoutName) + ".xml";
        IProject project = this.mDelegate.getEditor().getProject();
        IFile sourceFile = this.mDelegate.getEditor().getInputFile();
        if (sourceFile == null) {
            return changes;
        }
        this.handleIncludingFile(changes, sourceFile, this.mSelectionStart, this.mSelectionEnd, this.getDomDocument(), this.getPrimaryElement());
        boolean haveVariations = false;
        if (this.mReplaceOccurrences) {
            List<IFile> layouts = this.getOtherLayouts(sourceFile);
            for (IFile file : layouts) {
                IModelManager modelManager = StructuredModelManager.getModelManager();
                IStructuredModel model = null;
                monitor.subTask(String.format("Looking for duplicates in %1$s", file.getProjectRelativePath()));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    model = modelManager.getModelForRead(file);
                    if (model instanceof IDOMModel) {
                        IDOMModel domModel = (IDOMModel)model;
                        IDOMDocument otherDocument = domModel.getDocument();
                        ArrayList<Element> otherElements = new ArrayList<Element>();
                        Element otherPrimary = null;
                        for (Element element : this.getElements()) {
                            Element other = DomUtilities.findCorresponding(element, (Document)otherDocument);
                            if (other == null || !DomUtilities.isEquivalent(element, other)) continue;
                            otherElements.add(other);
                            if (element != this.getPrimaryElement()) continue;
                            otherPrimary = other;
                        }
                        if (otherElements.size() == this.getElements().size() && DomUtilities.isContiguous(otherElements)) {
                            int begin = Integer.MAX_VALUE;
                            int end = Integer.MIN_VALUE;
                            for (Element element : otherElements) {
                                IndexedRegion region = ExtractIncludeRefactoring.getRegion(element);
                                end = Math.max(end, region.getEndOffset());
                                begin = Math.min(begin, region.getStartOffset());
                            }
                            this.handleIncludingFile(changes, file, begin, end, (Document)otherDocument, otherPrimary);
                            haveVariations = true;
                        }
                    }
                }
                catch (IOException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                    if (model == null) continue;
                    model.releaseFromRead();
                    continue;
                }
                catch (CoreException e) {
                    try {
                        AdtPlugin.log(e, null, new Object[0]);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                    }
                }
                if (model == null) continue;
                model.releaseFromRead();
            }
        }
        IContainer parent = sourceFile.getParent();
        if (haveVariations) {
            parent = this.mProject.getFolder("res").getFolder("layout");
        }
        IPath parentPath = parent.getProjectRelativePath();
        IFile file = project.getFile((IPath)new Path(parentPath + "/" + newFileName));
        TextFileChange addFile = new TextFileChange("Create new separate layout", file);
        addFile.setTextType("xml");
        changes.add((Change)addFile);
        String newFile = sb.toString();
        if (AdtPrefs.getPrefs().getFormatGuiXml()) {
            newFile = EclipseXmlPrettyPrinter.prettyPrint(newFile, EclipseXmlFormatPreferences.create(), XmlFormatStyle.LAYOUT, null);
        }
        addFile.setEdit((TextEdit)new InsertEdit(0, newFile));
        Change finishHook = this.createFinishHook(file);
        changes.add(finishHook);
        return changes;
    }

    private void handleIncludingFile(List<Change> changes, IFile sourceFile, int begin, int end, Document document, Element primary) {
        MultiTextEdit rootEdit;
        TextFileChange change;
        block13: {
            change = new TextFileChange(sourceFile.getName(), sourceFile);
            rootEdit = new MultiTextEdit();
            change.setTextType("xml");
            changes.add((Change)change);
            String referenceId = this.getReferenceId();
            String androidNsPrefix = ExtractIncludeRefactoring.getAndroidNamespacePrefix(document);
            String include = ExtractIncludeRefactoring.computeIncludeString(primary, this.mLayoutName, androidNsPrefix, referenceId);
            int length = end - begin;
            ReplaceEdit replace = new ReplaceEdit(begin, length, include);
            rootEdit.addChild((TextEdit)replace);
            if (referenceId != null && primary != null) {
                String rootId = ExtractIncludeRefactoring.getId(primary);
                IStructuredModel model = null;
                try {
                    model = StructuredModelManager.getModelManager().getModelForRead(sourceFile);
                    IStructuredDocument doc = model.getStructuredDocument();
                    if (doc != null && rootId != null) {
                        MultiTextEdit formatted;
                        List<TextEdit> replaceIds = ExtractIncludeRefactoring.replaceIds(androidNsPrefix, doc, begin, end, rootId, referenceId);
                        for (TextEdit edit : replaceIds) {
                            rootEdit.addChild(edit);
                        }
                        if (AdtPrefs.getPrefs().getFormatGuiXml() && (formatted = ExtractIncludeRefactoring.reformat(doc.get(), rootEdit, XmlFormatStyle.LAYOUT)) != null) {
                            rootEdit = formatted;
                        }
                    }
                }
                catch (IOException e) {
                    AdtPlugin.log(e, null, new Object[0]);
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    break block13;
                }
                catch (CoreException e) {
                    try {
                        AdtPlugin.log(e, null, new Object[0]);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                    }
                }
                if (model == null) break block13;
                model.releaseFromRead();
            }
        }
        change.setEdit((TextEdit)rootEdit);
    }

    private List<IFile> getOtherLayouts(IFile sourceFile) {
        ArrayList<IFile> layouts = new ArrayList<IFile>(100);
        IPath sourcePath = sourceFile.getProjectRelativePath();
        IFolder resources = this.mProject.getFolder("res");
        try {
            IResource[] iResourceArray = resources.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource folder = iResourceArray[n2];
                if (folder.getName().startsWith("layout") && folder instanceof IFolder) {
                    IFolder layoutFolder = (IFolder)folder;
                    IResource[] iResourceArray2 = layoutFolder.members();
                    int n3 = iResourceArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource file = iResourceArray2[n4];
                        if (file.getName().endsWith("xml") && file instanceof IFile && !file.getProjectRelativePath().equals((Object)sourcePath)) {
                            layouts.add((IFile)file);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            AdtPlugin.log(e, null, new Object[0]);
        }
        return layouts;
    }

    String getInitialName() {
        String id;
        String defaultName = "";
        Element primary = this.getPrimaryElement();
        if (primary != null && (id = primary.getAttributeNS("http://schemas.android.com/apk/res/android", "id")) != null && (id.startsWith("@id/") || id.startsWith("@+id/"))) {
            defaultName = id.substring(id.indexOf(47) + 1).toLowerCase(Locale.US);
            ResourceNameValidator validator = ResourceNameValidator.create(true, this.mProject, ResourceType.LAYOUT);
            if (validator.isValid(defaultName) != null) {
                defaultName = "";
            }
        }
        return defaultName;
    }

    IFile getSourceFile() {
        return this.mFile;
    }

    private Change createFinishHook(final IFile file) {
        return new NullChange("Open extracted layout and refresh resources"){

            public Change perform(IProgressMonitor pm) throws CoreException {
                Display display = AdtPlugin.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExtractIncludeRefactoring.this.openFile(file);
                        (this).ExtractIncludeRefactoring.this.mDelegate.getGraphicalEditor().refreshProjectResources();
                        IWorkbenchPage page = (this).ExtractIncludeRefactoring.this.mDelegate.getEditor().getEditorSite().getPage();
                        page.saveEditor((IEditorPart)(this).ExtractIncludeRefactoring.this.mDelegate.getEditor(), false);
                    }
                });
                return null;
            }
        };
    }

    private String computeNamespaceDeclarations() {
        String androidNsPrefix = null;
        String namespaceDeclarations = null;
        StringBuilder sb = new StringBuilder();
        List<Attr> attributeNodes = this.findNamespaceAttributes();
        for (Node node : attributeNodes) {
            String prefix = node.getPrefix();
            if (!"xmlns".equals(prefix)) continue;
            sb.append(' ');
            String name = node.getNodeName();
            sb.append(name);
            sb.append('=').append('\"');
            String value = node.getNodeValue();
            if (value.equals("http://schemas.android.com/apk/res/android") && (androidNsPrefix = name).startsWith("xmlns:")) {
                androidNsPrefix = androidNsPrefix.substring("xmlns:".length());
            }
            sb.append(XmlUtils.toXmlAttributeValue((String)value));
            sb.append('\"');
        }
        namespaceDeclarations = sb.toString();
        if (androidNsPrefix == null) {
            androidNsPrefix = "android";
        }
        if (namespaceDeclarations.length() == 0) {
            sb.setLength(0);
            sb.append(' ');
            sb.append("xmlns:");
            sb.append(androidNsPrefix);
            sb.append('=').append('\"');
            sb.append("http://schemas.android.com/apk/res/android");
            sb.append('\"');
            namespaceDeclarations = sb.toString();
        }
        return namespaceDeclarations;
    }

    private String getReferenceId() {
        String rootId = this.getRootId();
        if (rootId != null) {
            return String.valueOf(rootId) + "_ref";
        }
        return null;
    }

    private static String computeIncludeString(Element primaryNode, String newName, String androidNsPrefix, String referenceId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<include layout=\"@layout/");
        sb.append(newName);
        sb.append('\"');
        sb.append(' ');
        if (referenceId != null) {
            sb.append(androidNsPrefix);
            sb.append(':');
            sb.append("id");
            sb.append('=').append('\"');
            sb.append(referenceId);
            sb.append('\"').append(' ');
        }
        String width = null;
        String height = null;
        if (primaryNode == null) {
            height = "wrap_content";
            width = "wrap_content";
        } else {
            width = !primaryNode.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_width") ? "wrap_content" : primaryNode.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_width");
            height = !primaryNode.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_height") ? "wrap_content" : primaryNode.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_height");
        }
        if (width != null) {
            sb.append(' ');
            sb.append(androidNsPrefix);
            sb.append(':');
            sb.append("layout_width");
            sb.append('=').append('\"');
            sb.append(XmlUtils.toXmlAttributeValue((String)width));
            sb.append('\"');
        }
        if (height != null) {
            sb.append(' ');
            sb.append(androidNsPrefix);
            sb.append(':');
            sb.append("layout_height");
            sb.append('=').append('\"');
            sb.append(XmlUtils.toXmlAttributeValue((String)height));
            sb.append('\"');
        }
        if (primaryNode != null) {
            NamedNodeMap attributes = primaryNode.getAttributes();
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                Node attr = attributes.item(i);
                String name = attr.getLocalName();
                if (name.startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI()) && !name.equals("layout_width") && !name.equals("layout_height")) {
                    sb.append(' ');
                    sb.append(androidNsPrefix);
                    sb.append(':');
                    sb.append(name);
                    sb.append('=').append('\"');
                    sb.append(XmlUtils.toXmlAttributeValue((String)attr.getNodeValue()));
                    sb.append('\"');
                }
                ++i;
            }
        }
        sb.append("/>");
        return sb.toString();
    }

    private String getExtractedText() {
        String xml = this.getText(this.mSelectionStart, this.mSelectionEnd);
        Element primaryNode = this.getPrimaryElement();
        xml = this.stripTopLayoutAttributes(primaryNode, this.mSelectionStart, xml);
        xml = ExtractIncludeRefactoring.dedent(xml);
        if (primaryNode == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<merge>\n");
            String[] stringArray = xml.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                sb.append("    ");
                sb.append(line).append('\n');
                ++n2;
            }
            sb.append("</merge>\n");
            xml = sb.toString();
        }
        return xml;
    }

    @Override
    VisualRefactoringWizard createWizard() {
        return new ExtractIncludeWizard(this, this.mDelegate);
    }

    public static class Descriptor
    extends VisualRefactoring.VisualRefactoringDescriptor {
        public Descriptor(String project, String description, String comment, Map<String, String> arguments) {
            super("com.android.ide.eclipse.adt.refactoring.extract.include", project, description, comment, arguments);
        }

        @Override
        protected Refactoring createRefactoring(Map<String, String> args) {
            return new ExtractIncludeRefactoring(args);
        }
    }
}

