/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.properties;

import com.android.annotations.Nullable;
import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.SeparatorAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.descriptors.ViewElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.CanvasViewInfo;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gre.ViewMetadataRepository;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.BooleanXmlPropertyEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.PropertyMetadata;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.XmlProperty;
import com.android.ide.eclipse.adt.internal.editors.layout.properties.XmlPropertyEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.wb.internal.core.editor.structure.property.PropertyListIntersector;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;

public class PropertyFactory {
    private static final boolean CACHE_ENABLED = true;
    private static final Property[] NO_PROPERTIES;
    private static final int PRIO_FIRST = -100000;
    private static final int PRIO_SECOND = -99990;
    private static final int PRIO_LAST = 100000;
    private final GraphicalEditorPart mGraphicalEditorPart;
    private Map<UiViewElementNode, Property[]> mCache = new WeakHashMap<UiViewElementNode, Property[]>();
    private UiViewElementNode mCurrentViewCookie;
    public static final SortingMode DEFAULT_MODE;
    private SortingMode mSortMode = DEFAULT_MODE;
    private SortingMode mCacheSortMode;

    static {
        if (!CACHE_ENABLED) {
            System.err.println("WARNING: The property cache is disabled");
        }
        NO_PROPERTIES = new Property[0];
        DEFAULT_MODE = SortingMode.BY_ORIGIN;
    }

    public PropertyFactory(GraphicalEditorPart graphicalEditorPart) {
        this.mGraphicalEditorPart = graphicalEditorPart;
    }

    public Property[] getProperties(List<CanvasViewInfo> items) {
        this.mCurrentViewCookie = null;
        if (items == null || items.size() == 0) {
            return NO_PROPERTIES;
        }
        if (items.size() == 1) {
            CanvasViewInfo item = items.get(0);
            this.mCurrentViewCookie = item.getUiViewNode();
            return this.getProperties(item);
        }
        PropertyListIntersector intersector = new PropertyListIntersector();
        for (CanvasViewInfo node : items) {
            intersector.intersect(this.getProperties(node));
        }
        return intersector.getProperties();
    }

    private Property[] getProperties(CanvasViewInfo item) {
        UiViewElementNode node = item.getUiViewNode();
        if (node == null) {
            return NO_PROPERTIES;
        }
        if (this.mCacheSortMode != this.mSortMode) {
            this.mCacheSortMode = this.mSortMode;
            this.mCache.clear();
        }
        Property[] properties = this.mCache.get(node);
        if (!CACHE_ENABLED) {
            properties = null;
        }
        if (properties == null) {
            Collection<? extends Property> propertyList = this.getProperties(node);
            properties = propertyList == null ? new Property[]{} : propertyList.toArray(new Property[propertyList.size()]);
            this.mCache.put(node, properties);
        }
        return properties;
    }

    protected Collection<? extends Property> getProperties(UiViewElementNode node) {
        ViewMetadataRepository repository = ViewMetadataRepository.get();
        ViewElementDescriptor viewDescriptor = (ViewElementDescriptor)node.getDescriptor();
        String fqcn = viewDescriptor.getFullClassName();
        HashSet<String> top = new HashSet<String>(repository.getTopAttributes(fqcn));
        AttributeDescriptor[] attributeDescriptors = node.getAttributeDescriptors();
        ArrayList<XmlProperty> properties = new ArrayList<XmlProperty>(attributeDescriptors.length);
        int priority = 0;
        AttributeDescriptor[] attributeDescriptorArray = attributeDescriptors;
        int n = attributeDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor descriptor = attributeDescriptorArray[n2];
            assert (!(descriptor instanceof SeparatorAttributeDescriptor));
            if (!(descriptor instanceof XmlnsAttributeDescriptor)) {
                XmlPropertyEditor editor = XmlPropertyEditor.INSTANCE;
                IAttributeInfo info = descriptor.getAttributeInfo();
                if (info != null) {
                    EnumSet formats = info.getFormats();
                    if (formats.contains(IAttributeInfo.Format.BOOLEAN)) {
                        editor = BooleanXmlPropertyEditor.INSTANCE;
                    } else {
                        formats.contains(IAttributeInfo.Format.ENUM);
                    }
                }
                XmlProperty property = new XmlProperty((PropertyEditor)editor, this, node, descriptor);
                priority += 10;
                PropertyCategory category = PropertyCategory.NORMAL;
                String name = descriptor.getXmlLocalName();
                if (top.contains(name) || PropertyMetadata.isPreferred(name)) {
                    category = PropertyCategory.PREFERRED;
                    property.setPriority(-100000 + priority);
                } else {
                    property.setPriority(priority);
                    if (PropertyMetadata.isAdvanced(name)) {
                        category = PropertyCategory.ADVANCED;
                    }
                }
                if (category != null) {
                    property.setCategory(category);
                }
                properties.add(property);
            }
            ++n2;
        }
        switch (this.mSortMode) {
            case BY_ORIGIN: {
                return this.sortByOrigin(node, properties);
            }
            case ALPHABETICAL: {
                return this.sortAlphabetically(node, properties);
            }
        }
        return this.sortNatural(node, properties);
    }

    protected Collection<? extends Property> sortAlphabetically(UiViewElementNode node, List<XmlProperty> properties) {
        Collections.sort(properties, Property.ALPHABETICAL);
        return properties;
    }

    protected Collection<? extends Property> sortByOrigin(UiViewElementNode node, List<XmlProperty> properties) {
        ArrayList<Object> collapsed = new ArrayList<Object>(properties.size());
        ArrayList layoutProperties = Lists.newArrayListWithExpectedSize((int)20);
        List marginProperties = null;
        ArrayList deprecatedProperties = null;
        HashMap<String, ComplexProperty> categoryToProperty = new HashMap<String, ComplexProperty>();
        ArrayListMultimap categoryToProperties = ArrayListMultimap.create();
        if (properties.isEmpty()) {
            return properties;
        }
        ViewElementDescriptor parent = (ViewElementDescriptor)properties.get(0).getDescriptor().getParent();
        HashMap categoryPriorities = Maps.newHashMap();
        int nextCategoryPriority = 100;
        while (parent != null) {
            categoryPriorities.put(parent.getFullClassName(), nextCategoryPriority += 100);
            parent = parent.getSuperClassDesc();
        }
        int i = 0;
        int max = properties.size();
        while (i < max) {
            XmlProperty property = properties.get(i);
            AttributeDescriptor descriptor = property.getDescriptor();
            if (descriptor.isDeprecated()) {
                if (deprecatedProperties == null) {
                    deprecatedProperties = Lists.newArrayListWithExpectedSize((int)10);
                }
                deprecatedProperties.add(property);
            } else {
                String firstName = descriptor.getXmlLocalName();
                if (firstName.startsWith("layout_")) {
                    if (firstName.startsWith("layout_margin")) {
                        if (marginProperties == null) {
                            marginProperties = Lists.newArrayListWithExpectedSize((int)5);
                        }
                        marginProperties.add(property);
                    } else {
                        layoutProperties.add(property);
                    }
                } else if (firstName.equals("id")) {
                    property.setPriority(-100000);
                    collapsed.add((Object)property);
                } else {
                    IAttributeInfo attributeInfo;
                    if (property.getCategory() == PropertyCategory.PREFERRED) {
                        collapsed.add((Object)property);
                        XmlProperty oldProperty = property;
                        property = new XmlProperty(oldProperty.getEditor(), this, node, oldProperty.getDescriptor());
                        property.setPriority(oldProperty.getPriority());
                    }
                    if ((attributeInfo = descriptor.getAttributeInfo()) != null && attributeInfo.getDefinedBy() != null) {
                        String category = attributeInfo.getDefinedBy();
                        ComplexProperty complex = (ComplexProperty)categoryToProperty.get(category);
                        if (complex == null) {
                            complex = new ComplexProperty(category.substring(category.lastIndexOf(46) + 1), "[]", null);
                            categoryToProperty.put(category, complex);
                            Integer categoryPriority = (Integer)categoryPriorities.get(category);
                            if (categoryPriority != null) {
                                complex.setPriority(categoryPriority.intValue());
                            } else {
                                categoryPriorities.put(category, nextCategoryPriority += 100);
                                complex.setPriority(nextCategoryPriority);
                            }
                        }
                        categoryToProperties.put((Object)category, (Object)property);
                    } else {
                        collapsed.add((Object)property);
                    }
                }
            }
            ++i;
        }
        for (String category : categoryToProperties.keySet()) {
            Collection subProperties = categoryToProperties.get((Object)category);
            if (subProperties.size() > 1) {
                ComplexProperty complex = (ComplexProperty)categoryToProperty.get(category);
                assert (complex != null) : category;
                Property[] subArray = new Property[subProperties.size()];
                complex.setProperties(subProperties.toArray(subArray));
                collapsed.add(complex);
                boolean allAdvanced = true;
                boolean isPreferred = false;
                for (Property p : subProperties) {
                    PropertyCategory c = p.getCategory();
                    if (c != PropertyCategory.ADVANCED) {
                        allAdvanced = false;
                    }
                    if (c != PropertyCategory.PREFERRED) continue;
                    isPreferred = true;
                }
                if (isPreferred) {
                    complex.setCategory(PropertyCategory.PREFERRED);
                    continue;
                }
                if (!allAdvanced) continue;
                complex.setCategory(PropertyCategory.ADVANCED);
                continue;
            }
            if (subProperties.size() != 1) continue;
            collapsed.add((Property)subProperties.iterator().next());
        }
        if (layoutProperties.size() > 0 || marginProperties != null) {
            Property p;
            if (marginProperties != null) {
                Property[] m = marginProperties.toArray(new XmlProperty[marginProperties.size()]);
                ComplexProperty marginProperty = new ComplexProperty("Margins", "[]", m);
                layoutProperties.add(marginProperty);
                marginProperty.setPriority(100000);
                Property[] propertyArray = m;
                int n = m.length;
                int n2 = 0;
                while (n2 < n) {
                    p = propertyArray[n2];
                    p.setParent((Property)marginProperty);
                    ++n2;
                }
            }
            Property[] l = layoutProperties.toArray(new Property[layoutProperties.size()]);
            Arrays.sort(l, Property.PRIORITY);
            ComplexProperty property = new ComplexProperty("Layout Parameters", "[]", l);
            Property[] propertyArray = l;
            int n = l.length;
            int n3 = 0;
            while (n3 < n) {
                p = propertyArray[n3];
                if (p instanceof XmlProperty) {
                    ((XmlProperty)p).setParent((Property)property);
                }
                ++n3;
            }
            property.setCategory(PropertyCategory.PREFERRED);
            collapsed.add(property);
            property.setPriority(-99990);
        }
        if (deprecatedProperties != null && deprecatedProperties.size() > 0) {
            ComplexProperty property = new ComplexProperty("Deprecated", "(Deprecated Properties)", deprecatedProperties.toArray(new Property[deprecatedProperties.size()]));
            property.setPriority(100000);
            collapsed.add(property);
        }
        Collections.sort(collapsed, Property.PRIORITY);
        return collapsed;
    }

    protected Collection<? extends Property> sortNatural(UiViewElementNode node, List<XmlProperty> properties) {
        Collections.sort(properties, Property.ALPHABETICAL);
        ArrayList<Object> collapsed = new ArrayList<Object>(properties.size());
        ArrayList layoutProperties = Lists.newArrayListWithExpectedSize((int)20);
        List marginProperties = null;
        ArrayList deprecatedProperties = null;
        HashMap<String, ComplexProperty> categoryToProperty = new HashMap<String, ComplexProperty>();
        ArrayListMultimap categoryToProperties = ArrayListMultimap.create();
        int i = 0;
        int max = properties.size();
        while (i < max) {
            block33: {
                int j;
                block39: {
                    block37: {
                        boolean allAdvanced;
                        ComplexProperty complexProperty;
                        block38: {
                            String firstName;
                            XmlProperty property;
                            block36: {
                                block35: {
                                    block34: {
                                        AttributeDescriptor descriptor;
                                        block32: {
                                            property = properties.get(i);
                                            descriptor = property.getDescriptor();
                                            if (!descriptor.isDeprecated()) break block32;
                                            if (deprecatedProperties == null) {
                                                deprecatedProperties = Lists.newArrayListWithExpectedSize((int)10);
                                            }
                                            deprecatedProperties.add(property);
                                            break block33;
                                        }
                                        firstName = descriptor.getXmlLocalName();
                                        if (!firstName.startsWith("layout_")) break block34;
                                        if (firstName.startsWith("layout_margin")) {
                                            if (marginProperties == null) {
                                                marginProperties = Lists.newArrayListWithExpectedSize((int)5);
                                            }
                                            marginProperties.add(property);
                                        } else {
                                            layoutProperties.add(property);
                                        }
                                        break block33;
                                    }
                                    if (!firstName.equals("id")) break block35;
                                    property.setPriority(-100000);
                                    collapsed.add((Object)property);
                                    break block33;
                                }
                                String category = PropertyMetadata.getCategory(firstName);
                                if (category == null) break block36;
                                ComplexProperty complex = (ComplexProperty)categoryToProperty.get(category);
                                if (complex == null) {
                                    complex = new ComplexProperty(category, "[]", null);
                                    categoryToProperty.put(category, complex);
                                    complex.setPriority(property.getPriority());
                                }
                                categoryToProperties.put((Object)category, (Object)property);
                                break block33;
                            }
                            int firstNameIndex = firstName.length();
                            int k = 0;
                            int kn = firstName.length();
                            while (k < kn) {
                                if (Character.isUpperCase(firstName.charAt(k))) {
                                    firstNameIndex = k;
                                    break;
                                }
                                ++k;
                            }
                            j = i + 1;
                            if (property.getCategory() != PropertyCategory.PREFERRED && !property.getDescriptor().isDeprecated()) {
                                while (j < max) {
                                    XmlProperty next = properties.get(j);
                                    String nextName = next.getName();
                                    if (!nextName.regionMatches(0, firstName, 0, firstNameIndex) || nextName.length() <= firstNameIndex || !Character.isUpperCase(nextName.charAt(firstNameIndex)) || next.getCategory() == PropertyCategory.PREFERRED || next.getDescriptor().isDeprecated()) break;
                                    ++j;
                                }
                            }
                            if (j - i <= 1) break block37;
                            Property[] subprops = new XmlProperty[j - i];
                            int k2 = i;
                            int index = 0;
                            while (k2 < j) {
                                subprops[index] = properties.get(k2);
                                ++k2;
                                ++index;
                            }
                            Arrays.sort(subprops, Property.PRIORITY);
                            int common = firstNameIndex;
                            int k3 = firstNameIndex + 1;
                            int n = firstName.length();
                            while (k3 < n) {
                                if (Character.isUpperCase(firstName.charAt(k3))) {
                                    common = k3;
                                    break;
                                }
                                ++k3;
                            }
                            if (common > firstNameIndex) {
                                k3 = 0;
                                n = subprops.length;
                                while (k3 < n) {
                                    String nextName = subprops[k3].getName();
                                    if (!nextName.regionMatches(0, firstName, 0, common) || nextName.length() <= common || !Character.isUpperCase(nextName.charAt(common))) {
                                        common = firstNameIndex;
                                        break;
                                    }
                                    ++k3;
                                }
                                firstNameIndex = common;
                            }
                            String base = firstName.substring(0, firstNameIndex);
                            base = DescriptorsUtils.capitalize(base);
                            complexProperty = new ComplexProperty(base, "[]", subprops);
                            complexProperty.setPriority(subprops[0].getPriority());
                            collapsed.add(complexProperty);
                            allAdvanced = true;
                            boolean isPreferred = false;
                            Property[] propertyArray = subprops;
                            int n2 = subprops.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                Property p = propertyArray[n3];
                                p.setParent((Property)complexProperty);
                                PropertyCategory c = p.getCategory();
                                if (c != PropertyCategory.ADVANCED) {
                                    allAdvanced = false;
                                }
                                if (c == PropertyCategory.PREFERRED) {
                                    isPreferred = true;
                                }
                                ++n3;
                            }
                            if (!isPreferred) break block38;
                            complexProperty.setCategory(PropertyCategory.PREFERRED);
                            break block39;
                        }
                        if (!allAdvanced) break block39;
                        complexProperty.setCategory(PropertyCategory.PREFERRED);
                        break block39;
                    }
                    int k = i;
                    while (k < j) {
                        collapsed.add((Property)properties.get(k));
                        ++k;
                    }
                }
                i = j - 1;
            }
            ++i;
        }
        for (String category : categoryToProperties.keySet()) {
            Collection subProperties = categoryToProperties.get((Object)category);
            if (subProperties.size() > 1) {
                ComplexProperty complex = (ComplexProperty)categoryToProperty.get(category);
                assert (complex != null) : category;
                Property[] subArray = new Property[subProperties.size()];
                complex.setProperties(subProperties.toArray(subArray));
                complex.setPriority(subArray[0].getPriority());
                collapsed.add(complex);
                boolean allAdvanced = true;
                boolean isPreferred = false;
                for (Property p : subProperties) {
                    PropertyCategory c = p.getCategory();
                    if (c != PropertyCategory.ADVANCED) {
                        allAdvanced = false;
                    }
                    if (c != PropertyCategory.PREFERRED) continue;
                    isPreferred = true;
                }
                if (isPreferred) {
                    complex.setCategory(PropertyCategory.PREFERRED);
                    continue;
                }
                if (!allAdvanced) continue;
                complex.setCategory(PropertyCategory.ADVANCED);
                continue;
            }
            if (subProperties.size() != 1) continue;
            collapsed.add((Property)subProperties.iterator().next());
        }
        if (layoutProperties.size() > 0 || marginProperties != null) {
            Property p;
            Property[] propertyArray;
            if (marginProperties != null) {
                Property[] m = marginProperties.toArray(new XmlProperty[marginProperties.size()]);
                ComplexProperty marginProperty = new ComplexProperty("Margins", "[]", m);
                layoutProperties.add(marginProperty);
                marginProperty.setPriority(100000);
                propertyArray = m;
                int n = m.length;
                int n4 = 0;
                while (n4 < n) {
                    p = propertyArray[n4];
                    p.setParent((Property)marginProperty);
                    ++n4;
                }
            }
            Property[] l = layoutProperties.toArray(new Property[layoutProperties.size()]);
            Arrays.sort(l, Property.PRIORITY);
            ComplexProperty property = new ComplexProperty("Layout Parameters", "[]", l);
            propertyArray = l;
            int n = l.length;
            int n5 = 0;
            while (n5 < n) {
                p = propertyArray[n5];
                if (p instanceof XmlProperty) {
                    ((XmlProperty)p).setParent((Property)property);
                }
                ++n5;
            }
            property.setCategory(PropertyCategory.PREFERRED);
            collapsed.add(property);
            property.setPriority(-99990);
        }
        if (deprecatedProperties != null && deprecatedProperties.size() > 0) {
            ComplexProperty property = new ComplexProperty("Deprecated", "(Deprecated Properties)", deprecatedProperties.toArray(new Property[deprecatedProperties.size()]));
            property.setPriority(100000);
            collapsed.add(property);
        }
        Collections.sort(collapsed, Property.PRIORITY);
        return collapsed;
    }

    @Nullable
    GraphicalEditorPart getGraphicalEditor() {
        return this.mGraphicalEditorPart;
    }

    public Object getCurrentViewObject() {
        return this.mCurrentViewCookie;
    }

    public void setSortingMode(SortingMode sortingMode) {
        this.mSortMode = sortingMode;
    }

    public static Composite addWorkaround(Composite parent) {
        if (ButtonPropertyEditorPresentation.isInWorkaround) {
            Composite top = new Composite(parent, 0);
            top.setLayout((Layout)new GridLayout(1, false));
            Label label = new Label(top, 64);
            label.setText("This dialog is shown instead of an inline text editor as a\nworkaround for an Eclipse bug specific to OSX Mountain Lion.\nIt should be fixed in Eclipse 4.3.");
            label.setForeground(top.getDisplay().getSystemColor(3));
            GridData data = new GridData();
            data.grabExcessVerticalSpace = false;
            data.grabExcessHorizontalSpace = false;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            label.setLayoutData((Object)data);
            Link link = new Link(top, 524288);
            link.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            link.setText("<a>https://bugs.eclipse.org/bugs/show_bug.cgi?id=388574</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWebBrowser browser = workbench.getBrowserSupport().getExternalBrowser();
                        browser.openURL(new URL(event.text));
                    }
                    catch (Exception exception) {
                        String message = String.format("Could not open browser. Vist\n%1$s\ninstead.", event.text);
                        MessageDialog.openError((Shell)((Link)event.getSource()).getShell(), (String)"Browser Error", (String)message);
                    }
                }
            });
            return top;
        }
        return null;
    }

    public static enum SortingMode {
        NATURAL,
        BY_ORIGIN,
        ALPHABETICAL;

    }
}

