/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.Rect;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionItem;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SimpleAttribute;
import java.util.ArrayList;
import java.util.List;

public class SimpleElement
implements IDragElement {
    private static final String FORMAT_VERSION = "3";
    private final String mFqcn;
    private final String mParentFqcn;
    private final Rect mBounds;
    private final Rect mParentBounds;
    private final List<IDragElement.IDragAttribute> mAttributes = new ArrayList<IDragElement.IDragAttribute>();
    private final List<IDragElement> mElements = new ArrayList<IDragElement>();
    private IDragElement.IDragAttribute[] mCachedAttributes = null;
    private IDragElement[] mCachedElements = null;
    private SelectionItem mSelectionItem;

    public SimpleElement(String fqcn, String parentFqcn, Rect bounds, Rect parentBounds) {
        this.mFqcn = fqcn;
        this.mParentFqcn = parentFqcn;
        this.mBounds = bounds == null ? new Rect() : bounds.copy();
        this.mParentBounds = parentBounds == null ? new Rect() : parentBounds.copy();
    }

    @NonNull
    public String getFqcn() {
        return this.mFqcn;
    }

    @NonNull
    public Rect getBounds() {
        return this.mBounds;
    }

    public String getParentFqcn() {
        return this.mParentFqcn;
    }

    @NonNull
    public Rect getParentBounds() {
        return this.mParentBounds;
    }

    @NonNull
    public IDragElement.IDragAttribute[] getAttributes() {
        if (this.mCachedAttributes == null) {
            this.mCachedAttributes = this.mAttributes.toArray(new IDragElement.IDragAttribute[this.mAttributes.size()]);
        }
        return this.mCachedAttributes;
    }

    public IDragElement.IDragAttribute getAttribute(@Nullable String uri, @NonNull String localName) {
        for (IDragElement.IDragAttribute attr : this.mAttributes) {
            if (!attr.getUri().equals(uri) || !attr.getName().equals(localName)) continue;
            return attr;
        }
        return null;
    }

    @NonNull
    public IDragElement[] getInnerElements() {
        if (this.mCachedElements == null) {
            this.mCachedElements = this.mElements.toArray(new IDragElement[this.mElements.size()]);
        }
        return this.mCachedElements;
    }

    public void addAttribute(SimpleAttribute attr) {
        this.mCachedAttributes = null;
        this.mAttributes.add((IDragElement.IDragAttribute)attr);
    }

    public void addInnerElement(SimpleElement e) {
        this.mCachedElements = null;
        this.mElements.add(e);
    }

    public boolean isSame(@NonNull INode node) {
        if (this.mSelectionItem != null) {
            return node == this.mSelectionItem.getNode();
        }
        return node.getBounds().equals((Object)this.mBounds);
    }

    void setSelectionItem(@Nullable SelectionItem selectionItem) {
        this.mSelectionItem = selectionItem;
    }

    @Nullable
    SelectionItem getSelectionItem() {
        return this.mSelectionItem;
    }

    @Nullable
    static SimpleElement findPrimary(SimpleElement[] elements, SelectionItem primary) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        if (elements.length == 1 || primary == null) {
            return elements[0];
        }
        SimpleElement[] simpleElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleElement element = simpleElementArray[n2];
            if (element.getSelectionItem() == primary) {
                return element;
            }
            ++n2;
        }
        return elements[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{V=").append(FORMAT_VERSION);
        sb.append(",N=").append(this.mFqcn);
        if (this.mParentFqcn != null) {
            sb.append(",P=").append(this.mParentFqcn);
        }
        if (this.mBounds != null && this.mBounds.isValid()) {
            sb.append(String.format(",R=%d %d %d %d", this.mBounds.x, this.mBounds.y, this.mBounds.w, this.mBounds.h));
        }
        if (this.mParentBounds != null && this.mParentBounds.isValid()) {
            sb.append(String.format(",Q=%d %d %d %d", this.mParentBounds.x, this.mParentBounds.y, this.mParentBounds.w, this.mParentBounds.h));
        }
        sb.append('\n');
        for (IDragElement.IDragAttribute a : this.mAttributes) {
            sb.append(a.toString());
        }
        for (IDragElement e : this.mElements) {
            sb.append(e.toString());
        }
        sb.append("}\n");
        return sb.toString();
    }

    static SimpleElement[] parseString(String value) {
        ArrayList<SimpleElement> elements = new ArrayList<SimpleElement>();
        String[] lines = value.split("\n");
        int[] index = new int[1];
        SimpleElement element = null;
        while ((element = SimpleElement.parseLines(lines, index)) != null) {
            elements.add(element);
        }
        return elements.toArray(new SimpleElement[elements.size()]);
    }

    private static SimpleElement parseLines(String[] lines, int[] inOutIndex) {
        SimpleElement e = null;
        int index = inOutIndex[0];
        while (index < lines.length) {
            String line;
            String s;
            if ((s = (line = lines[index++]).trim()).startsWith("{")) {
                if (e == null) {
                    String version = null;
                    String fqcn = null;
                    String parent = null;
                    Rect bounds = null;
                    Rect pbounds = null;
                    String[] stringArray = s.substring(1).split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s2 = stringArray[n2];
                        int pos = s2.indexOf(61);
                        if (pos > 0 && pos != s2.length() - 1) {
                            String[] sb;
                            String key = s2.substring(0, pos).trim();
                            String value = s2.substring(pos + 1).trim();
                            if (key.equals("V")) {
                                version = value;
                                if (!value.equals(FORMAT_VERSION)) {
                                    inOutIndex[0] = index;
                                    return null;
                                }
                            } else if (key.equals("N")) {
                                fqcn = value;
                            } else if (key.equals("P")) {
                                parent = value;
                            } else if ((key.equals("R") || key.equals("Q")) && (sb = value.split(" +")) != null && sb.length == 4) {
                                Rect r = null;
                                try {
                                    r = new Rect();
                                    r.x = Integer.parseInt(sb[0]);
                                    r.y = Integer.parseInt(sb[1]);
                                    r.w = Integer.parseInt(sb[2]);
                                    r.h = Integer.parseInt(sb[3]);
                                    if (key.equals("R")) {
                                        bounds = r;
                                    } else {
                                        pbounds = r;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        }
                        ++n2;
                    }
                    if (version == null || fqcn == null || fqcn.length() <= 0) continue;
                    e = new SimpleElement(fqcn, parent, bounds, pbounds);
                    continue;
                }
                inOutIndex[0] = index - 1;
                SimpleElement e2 = SimpleElement.parseLines(lines, inOutIndex);
                if (e2 != null) {
                    e.addInnerElement(e2);
                }
                index = inOutIndex[0];
                continue;
            }
            if (e != null && s.startsWith("@")) {
                SimpleAttribute a = SimpleAttribute.parseString(line);
                if (a == null) continue;
                e.addAttribute(a);
                continue;
            }
            if (e == null || !s.startsWith("}")) continue;
            inOutIndex[0] = index;
            return e;
        }
        inOutIndex[0] = index;
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleElement) {
            SimpleElement se = (SimpleElement)obj;
            if (this.mBounds == null && se.mBounds != null || this.mBounds != null && !this.mBounds.equals((Object)se.mBounds)) {
                return false;
            }
            if (this.mParentFqcn == null && se.mParentFqcn != null || this.mParentFqcn != null && !this.mParentFqcn.equals(se.mParentFqcn)) {
                return false;
            }
            if (this.mParentBounds == null && se.mParentBounds != null || this.mParentBounds != null && !this.mParentBounds.equals((Object)se.mParentBounds)) {
                return false;
            }
            return this.mFqcn.equals(se.mFqcn) && this.mAttributes.size() == se.mAttributes.size() && this.mElements.size() == se.mElements.size() && this.mAttributes.equals(se.mAttributes) && this.mElements.equals(se.mElements);
        }
        return false;
    }

    public int hashCode() {
        long c = this.mFqcn.hashCode();
        c = 31L * c + (long)this.mAttributes.hashCode();
        c = 31L * c + (long)this.mElements.hashCode();
        if (this.mParentFqcn != null) {
            c = 31L * c + (long)this.mParentFqcn.hashCode();
        }
        if (this.mBounds != null && this.mBounds.isValid()) {
            c = 31L * c + (long)this.mBounds.hashCode();
        }
        if (this.mParentBounds != null && this.mParentBounds.isValid()) {
            c = 31L * c + (long)this.mParentBounds.hashCode();
        }
        if (c > 0xFFFFFFFFL) {
            c ^= c >> 32;
        }
        return (int)(c & 0xFFFFFFFFL);
    }
}

