/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.common.rendering.api.Capability;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.IncludeFinder;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SubmenuAction;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;

class ShowWithinMenu
extends SubmenuAction {
    private LayoutEditorDelegate mEditorDelegate;

    ShowWithinMenu(LayoutEditorDelegate editorDelegate) {
        super("Show Included In");
        this.mEditorDelegate = editorDelegate;
    }

    @Override
    protected void addMenuItems(Menu menu) {
        GraphicalEditorPart graphicalEditor = this.mEditorDelegate.getGraphicalEditor();
        IFile file = graphicalEditor.getEditedFile();
        if (graphicalEditor.renderingSupports(Capability.EMBEDDED_LAYOUT)) {
            IProject project = file.getProject();
            IncludeFinder finder = IncludeFinder.get(project);
            List<IncludeFinder.Reference> includedBy = finder.getIncludedBy((IResource)file);
            if (includedBy != null && includedBy.size() > 0) {
                for (IncludeFinder.Reference reference : includedBy) {
                    String title = reference.getDisplayName();
                    ShowWithinAction action = new ShowWithinAction(title, reference);
                    new ActionContributionItem((IAction)action).fill(menu, -1);
                }
                new Separator().fill(menu, -1);
            }
            ShowWithinAction action = new ShowWithinAction("Nothing", null);
            if (includedBy == null || includedBy.size() == 0) {
                action.setEnabled(false);
            }
            new ActionContributionItem((IAction)action).fill(menu, -1);
        } else {
            this.addDisabledMessageItem("Not supported on platform");
        }
    }

    private class ShowWithinAction
    extends Action {
        private IncludeFinder.Reference mReference;

        public ShowWithinAction(String title, IncludeFinder.Reference reference) {
            super(title, 8);
            this.mReference = reference;
        }

        public boolean isChecked() {
            IncludeFinder.Reference within = ShowWithinMenu.this.mEditorDelegate.getGraphicalEditor().getIncludedWithin();
            if (within == null) {
                return this.mReference == null;
            }
            return within.equals(this.mReference);
        }

        public void run() {
            if (!this.isChecked()) {
                ShowWithinMenu.this.mEditorDelegate.getGraphicalEditor().showIn(this.mReference);
            }
        }
    }
}

