/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.ide.common.api.Point;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.ControlPoint;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.MouseEvent;

public final class LayoutPoint {
    private final LayoutCanvas mCanvas;
    public final int x;
    public final int y;

    public static LayoutPoint create(LayoutCanvas canvas, MouseEvent event) {
        assert (event.widget == canvas) : event.widget;
        return ControlPoint.create(canvas, event).toLayout();
    }

    public static LayoutPoint create(LayoutCanvas canvas, DragSourceEvent event) {
        return ControlPoint.create(canvas, event).toLayout();
    }

    public static LayoutPoint create(LayoutCanvas canvas, int x, int y) {
        return new LayoutPoint(canvas, x, y);
    }

    private LayoutPoint(LayoutCanvas canvas, int x, int y) {
        this.mCanvas = canvas;
        this.x = x;
        this.y = y;
    }

    public ControlPoint toControl() {
        int cx = this.mCanvas.getHorizontalTransform().translate(this.x);
        int cy = this.mCanvas.getVerticalTransform().translate(this.y);
        return ControlPoint.create(this.mCanvas, cx, cy);
    }

    public Point toPoint() {
        return new Point(this.x, this.y);
    }

    public String toString() {
        return "LayoutPoint [x=" + this.x + ", y=" + this.y + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayoutPoint other = (LayoutPoint)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }
}

