/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.AdtUtils;
import com.android.ide.eclipse.adt.internal.editors.AndroidXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.ProjectCallback;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.DomUtilities;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.preferences.AdtPrefs;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.progress.WorkbenchJob;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;

public class LayoutMetadata {
    public static final String DEFAULT_EXPANDABLE_LIST_ITEM = "simple_expandable_list_item_2";
    public static final String DEFAULT_LIST_ITEM = "simple_list_item_2";
    public static final String DEFAULT_SPINNER_ITEM = "simple_spinner_item";
    private static final String COMMENT_PROLOGUE = " Preview: ";
    public static final String KEY_LV_ITEM = "listitem";
    public static final String KEY_LV_HEADER = "listheader";
    public static final String KEY_LV_FOOTER = "listfooter";
    public static final String KEY_FRAGMENT_LAYOUT = "layout";

    private LayoutMetadata() {
    }

    @Nullable
    public static String getProperty(@NonNull XmlPullParser parser, @NonNull String name) {
        String value = parser.getAttributeValue("http://schemas.android.com/tools", name);
        if (value != null && value.isEmpty()) {
            value = null;
        }
        return value;
    }

    @Deprecated
    public static void clearLegacyComment(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            String text;
            Node child = children.item(i);
            if (child.getNodeType() == 8 && (text = child.getNodeValue()).startsWith(COMMENT_PROLOGUE)) {
                Node commentNode = child;
                Node previous = commentNode.getPreviousSibling();
                if (previous != null && previous.getNodeType() == 3 && previous.getNodeValue().trim().length() == 0) {
                    node.removeChild(previous);
                }
                node.removeChild(commentNode);
                Node first = node.getFirstChild();
                if (first != null && first.getNextSibling() == null && first.getNodeType() == 3 && first.getNodeValue().trim().length() == 0) {
                    node.removeChild(first);
                }
            }
            ++i;
        }
    }

    @Nullable
    public static String getProperty(@NonNull Node node, @NonNull String name) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String value = element.getAttributeNS("http://schemas.android.com/tools", name);
            if (value != null && value.isEmpty()) {
                value = null;
            }
            return value;
        }
        return null;
    }

    public static void setProperty(final @NonNull AndroidXmlEditor editor, @NonNull Node node, final @NonNull String name, final @Nullable String value) {
        LayoutMetadata.clearLegacyComment(node);
        if (node.getNodeType() == 1) {
            final Element element = (Element)node;
            AdtUtils.setToolsAttribute(editor, element, "Bind View", name, value, false, false);
            final IFile file = editor.getInputFile();
            if (file != null) {
                final List<IFile> variations = AdtUtils.getResourceVariations(file, false);
                if (variations.isEmpty()) {
                    return;
                }
                Display display = AdtPlugin.getDisplay();
                WorkbenchJob job = new WorkbenchJob(display, "Update alternate views"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        for (IFile variation : variations) {
                            if (variation.equals((Object)file)) continue;
                            try {
                                if (!AdtPrefs.getPrefs().isSharedLayoutEditor() && LayoutMetadata.setPropertyInEditor("Bind View", variation, element, name, value)) {
                                    return Status.OK_STATUS;
                                }
                                boolean old = editor.getIgnoreXmlUpdate();
                                try {
                                    editor.setIgnoreXmlUpdate(true);
                                    LayoutMetadata.setPropertyInFile("Bind View", variation, element, name, value);
                                }
                                finally {
                                    editor.setIgnoreXmlUpdate(old);
                                }
                            }
                            catch (Exception e) {
                                AdtPlugin.log(e, variation.getFullPath().toOSString(), new Object[0]);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    private static boolean setPropertyInEditor(@NonNull String undoLabel, @NonNull IFile variation, @NonNull Element equivalentElement, @NonNull String name, @Nullable String value) {
        Collection<IEditorPart> editors = AdtUtils.findEditorsFor(variation, false);
        for (IEditorPart part : editors) {
            Element element;
            Document doc;
            AndroidXmlEditor editor = AdtUtils.getXmlEditor(part);
            if (editor == null || (doc = DomUtilities.getDocument(editor)) == null || (element = DomUtilities.findCorresponding(equivalentElement, doc)) == null) continue;
            AdtUtils.setToolsAttribute(editor, element, undoLabel, name, value, false, false);
            if (part instanceof GraphicalEditorPart) {
                GraphicalEditorPart g = (GraphicalEditorPart)part;
                g.recomputeLayout();
                g.getCanvasControl().redraw();
            }
            return true;
        }
        return false;
    }

    private static boolean setPropertyInFile(@NonNull String undoLabel, @NonNull IFile variation, @NonNull Element element, @NonNull String name, @Nullable String value) {
        Element other;
        Document doc = DomUtilities.getDocument(variation);
        if (doc != null && element.getOwnerDocument() != doc && (other = DomUtilities.findCorresponding(element, doc)) != null) {
            AdtUtils.setToolsAttribute(variation, other, undoLabel, name, value, false);
            return true;
        }
        return false;
    }

    private static String stripLayoutPrefix(String layout) {
        if (layout.startsWith("@android:layout/")) {
            layout = layout.substring("@android:layout/".length());
        } else if (layout.startsWith("@layout/")) {
            layout = layout.substring("@layout/".length());
        }
        return layout;
    }

    @Nullable
    public static AdapterBinding getNodeBinding(@Nullable Object viewObject, @NonNull Map<String, String> map) {
        String header = map.get(KEY_LV_HEADER);
        String footer = map.get(KEY_LV_FOOTER);
        String layout = map.get(KEY_LV_ITEM);
        if (layout != null || header != null || footer != null) {
            int count = 12;
            return LayoutMetadata.getNodeBinding(viewObject, header, footer, layout, count);
        }
        return null;
    }

    @Nullable
    public static AdapterBinding getNodeBinding(@Nullable Object viewObject, @NonNull UiViewElementNode uiNode) {
        Node xmlNode = uiNode.getXmlNode();
        String header = LayoutMetadata.getProperty(xmlNode, KEY_LV_HEADER);
        String footer = LayoutMetadata.getProperty(xmlNode, KEY_LV_FOOTER);
        String layout = LayoutMetadata.getProperty(xmlNode, KEY_LV_ITEM);
        if (layout != null || header != null || footer != null) {
            int count = 12;
            if (xmlNode instanceof Element && xmlNode.getNodeName().endsWith("GridView")) {
                Element element = (Element)xmlNode;
                String columns = element.getAttributeNS("http://schemas.android.com/apk/res/android", "numColumns");
                int multiplier = 2;
                if (columns != null && columns.length() > 0 && !columns.equals("auto_fit")) {
                    try {
                        int c = Integer.parseInt(columns);
                        if (c >= 1 && c <= 10) {
                            multiplier = c;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                count *= multiplier;
            }
            return LayoutMetadata.getNodeBinding(viewObject, header, footer, layout, count);
        }
        return null;
    }

    private static AdapterBinding getNodeBinding(Object viewObject, String header, String footer, String layout, int count) {
        if (layout != null || header != null || footer != null) {
            boolean isFramework;
            AdapterBinding binding = new AdapterBinding(count);
            if (header != null) {
                isFramework = header.startsWith("@android:layout/");
                binding.addHeader(new ResourceReference(LayoutMetadata.stripLayoutPrefix(header), isFramework));
            }
            if (footer != null) {
                isFramework = footer.startsWith("@android:layout/");
                binding.addFooter(new ResourceReference(LayoutMetadata.stripLayoutPrefix(footer), isFramework));
            }
            if (layout != null) {
                isFramework = layout.startsWith("@android:layout/");
                if (isFramework) {
                    layout = layout.substring("@android:layout/".length());
                } else if (layout.startsWith("@layout/")) {
                    layout = layout.substring("@layout/".length());
                }
                binding.addItem(new DataBindingItem(layout, isFramework, 1));
            } else if (viewObject != null) {
                String listFqcn = ProjectCallback.getListAdapterViewFqcn(viewObject.getClass());
                if (listFqcn != null) {
                    if (listFqcn.endsWith("ExpandableListView")) {
                        binding.addItem(new DataBindingItem(DEFAULT_EXPANDABLE_LIST_ITEM, true, 1));
                    } else {
                        binding.addItem(new DataBindingItem(DEFAULT_LIST_ITEM, true, 1));
                    }
                }
            } else {
                binding.addItem(new DataBindingItem(DEFAULT_LIST_ITEM, true, 1));
            }
            return binding;
        }
        return null;
    }
}

