/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ImageControl
extends Canvas
implements MouseTrackListener {
    private Image mImage;
    private int mLeftMargin;
    private int mTopMargin;
    private int mRightMargin;
    private int mBottomMargin;
    private boolean mDisposeImage = true;
    private boolean mMouseIn;
    private Color mHoverColor;
    private float mScale = 1.0f;

    public ImageControl(@NonNull Composite parent, int style, @Nullable Image image) {
        super(parent, style | 0x80000 | 0x20000000);
        this.mImage = image;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ImageControl.this.onPaint(event);
            }
        });
    }

    @Nullable
    public Image getImage() {
        return this.mImage;
    }

    public void setImage(@Nullable Image image) {
        if (this.mDisposeImage && this.mImage != null) {
            this.mImage.dispose();
        }
        this.mImage = image;
        this.redraw();
    }

    public void fitToWidth(int width) {
        if (this.mImage == null) {
            return;
        }
        Rectangle imageRect = this.mImage.getBounds();
        int imageWidth = imageRect.width;
        if (imageWidth <= width) {
            this.mScale = 1.0f;
            return;
        }
        this.mScale = (float)width / (float)imageWidth;
        this.redraw();
    }

    public void setScale(float scale) {
        this.mScale = scale;
    }

    public float getScale() {
        return this.mScale;
    }

    public void setHoverColor(@Nullable Color hoverColor) {
        if (this.mHoverColor != null) {
            this.removeMouseTrackListener(this);
        }
        this.mHoverColor = hoverColor;
        if (hoverColor != null) {
            this.addMouseTrackListener(this);
        }
    }

    @Nullable
    public Color getHoverColor() {
        return this.mHoverColor;
    }

    public void dispose() {
        super.dispose();
        if (this.mDisposeImage && this.mImage != null && !this.mImage.isDisposed()) {
            this.mImage.dispose();
        }
        this.mImage = null;
    }

    public void setDisposeImage(boolean disposeImage) {
        this.mDisposeImage = disposeImage;
    }

    public boolean getDisposeImage() {
        return this.mDisposeImage;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = new Point(0, 0);
        if (this.mImage != null) {
            Rectangle r = this.mImage.getBounds();
            if (this.mScale != 1.0f) {
                e.x = (int)((float)e.x + this.mScale * (float)r.width);
                e.y = (int)((float)e.y + this.mScale * (float)r.height);
            } else {
                e.x += r.width;
                e.y += r.height;
            }
        }
        e.x = wHint == -1 ? (e.x += this.mLeftMargin + this.mRightMargin) : wHint;
        e.y = hHint == -1 ? (e.y += this.mTopMargin + this.mBottomMargin) : hHint;
        return e;
    }

    private void onPaint(PaintEvent event) {
        int imageWidth;
        Rectangle rect = this.getClientArea();
        if (this.mImage == null || rect.width == 0 || rect.height == 0) {
            return;
        }
        GC gc = event.gc;
        Rectangle imageRect = this.mImage.getBounds();
        int imageHeight = imageRect.height;
        int destWidth = imageWidth = imageRect.width;
        int destHeight = imageHeight;
        int oldGcAlias = gc.getAntialias();
        int oldGcInterpolation = gc.getInterpolation();
        if (this.mScale != 1.0f) {
            destWidth = (int)(this.mScale * (float)destWidth);
            destHeight = (int)(this.mScale * (float)destHeight);
            gc.setAntialias(1);
            gc.setInterpolation(2);
        }
        gc.drawImage(this.mImage, 0, 0, imageWidth, imageHeight, rect.x + this.mLeftMargin, rect.y + this.mTopMargin, destWidth, destHeight);
        gc.setAntialias(oldGcAlias);
        gc.setInterpolation(oldGcInterpolation);
        if (this.mHoverColor != null && this.mMouseIn) {
            gc.setAlpha(60);
            gc.setBackground(this.mHoverColor);
            gc.setLineWidth(1);
            gc.fillRectangle(0, 0, destWidth, destHeight);
        }
    }

    public void setMargins(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        this.checkWidget();
        this.mLeftMargin = Math.max(0, leftMargin);
        this.mTopMargin = Math.max(0, topMargin);
        this.mRightMargin = Math.max(0, rightMargin);
        this.mBottomMargin = Math.max(0, bottomMargin);
        this.redraw();
    }

    public void mouseEnter(MouseEvent e) {
        this.mMouseIn = true;
        if (this.mHoverColor != null) {
            this.redraw();
        }
    }

    public void mouseExit(MouseEvent e) {
        this.mMouseIn = false;
        if (this.mHoverColor != null) {
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent e) {
    }
}

