/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.gle2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditorDelegate;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.GraphicalEditorPart;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutCanvas;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.LayoutMetadata;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionItem;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SelectionManager;
import com.android.ide.eclipse.adt.internal.editors.layout.gle2.SubmenuAction;
import com.android.ide.eclipse.adt.internal.editors.layout.uimodel.UiViewElementNode;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.resources.CyclicDependencyValidator;
import com.android.ide.eclipse.adt.internal.ui.ResourceChooser;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FragmentMenu
extends SubmenuAction {
    private static final String R_LAYOUT_RESOURCE_PREFIX = "R.layout.";
    private static final String ANDROID_R_PREFIX = "android.R.layout";
    private final LayoutCanvas mCanvas;

    public FragmentMenu(LayoutCanvas canvas) {
        super("Fragment Layout");
        this.mCanvas = canvas;
    }

    @Override
    protected void addMenuItems(Menu menu) {
        String fqcn;
        Action action = new PickLayoutAction("Choose Layout...");
        new ActionContributionItem((IAction)action).fill(menu, -1);
        SelectionManager selectionManager = this.mCanvas.getSelectionManager();
        List<SelectionItem> selections = selectionManager.getSelections();
        if (selections.size() == 0) {
            return;
        }
        SelectionItem first = selections.get(0);
        UiViewElementNode node = first.getViewInfo().getUiViewNode();
        if (node == null) {
            return;
        }
        Element element = (Element)node.getXmlNode();
        String selected = this.getSelectedLayout();
        if (selected != null && selected.startsWith("@android:layout/")) {
            selected = selected.substring("@android:layout/".length());
        }
        if ((fqcn = FragmentMenu.getFragmentClass(element)) != null) {
            IProject project = this.mCanvas.getEditorDelegate().getEditor().getProject();
            String source = null;
            try {
                IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
                IType type = javaProject.findType(fqcn);
                if (type != null) {
                    source = type.getSource();
                }
            }
            catch (CoreException e) {
                AdtPlugin.log(e, null, new Object[0]);
            }
            if (source != null) {
                String self = this.mCanvas.getLayoutResourceName();
                ArrayList<Pair> layouts = new ArrayList<Pair>();
                if (source.contains("extends ListFragment")) {
                    layouts.add(Pair.of((Object)"list_content", (Object)"@android:layout/list_content"));
                }
                int index = 0;
                while ((index = source.indexOf(R_LAYOUT_RESOURCE_PREFIX, index)) != -1) {
                    int end = index += R_LAYOUT_RESOURCE_PREFIX.length();
                    while (end < source.length()) {
                        char c = source.charAt(end);
                        if (!Character.isJavaIdentifierPart(c)) break;
                        ++end;
                    }
                    if (end > index) {
                        String title = source.substring(index, end);
                        int len = ANDROID_R_PREFIX.length() + 1;
                        String layout = index > len && source.startsWith(ANDROID_R_PREFIX, index - len) ? "@android:layout/" + title : "@layout/" + title;
                        if (!self.equals(title)) {
                            layouts.add(Pair.of((Object)title, (Object)layout));
                        }
                    }
                    ++index;
                }
                if (layouts.size() > 0) {
                    new Separator().fill(menu, -1);
                    for (Pair layout : layouts) {
                        action = new SetFragmentLayoutAction((String)layout.getFirst(), (String)layout.getSecond(), selected);
                        new ActionContributionItem((IAction)action).fill(menu, -1);
                    }
                }
            }
        }
        if (selected != null) {
            new Separator().fill(menu, -1);
            action = new SetFragmentLayoutAction("Clear", null, null);
            new ActionContributionItem((IAction)action).fill(menu, -1);
        }
    }

    @Nullable
    public static String getFragmentClass(@NonNull Element element) {
        String fqcn = element.getAttribute("class");
        if (fqcn == null || fqcn.length() == 0) {
            fqcn = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        }
        if (fqcn != null && fqcn.length() > 0) {
            return fqcn;
        }
        return null;
    }

    @Nullable
    public static String getFragmentLayout(@NonNull Node node) {
        String layout = LayoutMetadata.getProperty(node, "layout");
        if (layout != null) {
            return layout;
        }
        return null;
    }

    @Nullable
    private String getSelectedLayout() {
        SelectionManager selectionManager = this.mCanvas.getSelectionManager();
        for (SelectionItem item : selectionManager.getSelections()) {
            String layout;
            UiViewElementNode node = item.getViewInfo().getUiViewNode();
            if (node == null || (layout = FragmentMenu.getFragmentLayout(node.getXmlNode())) == null) continue;
            return layout;
        }
        return null;
    }

    public void setNewLayout(@Nullable String layout) {
        LayoutEditorDelegate delegate = this.mCanvas.getEditorDelegate();
        GraphicalEditorPart graphicalEditor = delegate.getGraphicalEditor();
        SelectionManager selectionManager = this.mCanvas.getSelectionManager();
        for (SelectionItem item : selectionManager.getSnapshot()) {
            UiViewElementNode node = item.getViewInfo().getUiViewNode();
            if (node == null) continue;
            Node xmlNode = node.getXmlNode();
            LayoutMetadata.setProperty(delegate.getEditor(), xmlNode, "layout", layout);
        }
        graphicalEditor.recomputeLayout();
        this.mCanvas.redraw();
    }

    private class PickLayoutAction
    extends Action {
        public PickLayoutAction(String title) {
            super(title, 1);
        }

        public void run() {
            LayoutEditorDelegate delegate = FragmentMenu.this.mCanvas.getEditorDelegate();
            IFile file = delegate.getEditor().getInputFile();
            GraphicalEditorPart editor = delegate.getGraphicalEditor();
            ResourceChooser dlg = ResourceChooser.create(editor, ResourceType.LAYOUT).setInputValidator(CyclicDependencyValidator.create(file)).setInitialSize(85, 10).setCurrentResource(FragmentMenu.this.getSelectedLayout());
            int result = dlg.open();
            if (result == -5) {
                FragmentMenu.this.setNewLayout(null);
            } else if (result == 0) {
                String newType = dlg.getCurrentResource();
                FragmentMenu.this.setNewLayout(newType);
            }
        }
    }

    private class SetFragmentLayoutAction
    extends Action {
        private final String mLayout;

        public SetFragmentLayoutAction(String title, String layout, String selected) {
            super(title, 8);
            this.mLayout = layout;
            if (layout != null && layout.equals(selected)) {
                this.setChecked(true);
            }
        }

        public void run() {
            if (this.isChecked()) {
                FragmentMenu.this.setNewLayout(this.mLayout);
            }
        }
    }
}

