/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.configuration;

import com.android.annotations.NonNull;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.android.ide.eclipse.adt.internal.editors.layout.configuration.FlagManager;
import com.google.common.base.Objects;
import org.eclipse.swt.graphics.Image;

public class Locale {
    public static final RegionQualifier ANY_REGION = new RegionQualifier("__");
    public static final LanguageQualifier ANY_LANGUAGE = new LanguageQualifier("__");
    public static final Locale ANY = new Locale(ANY_LANGUAGE, ANY_REGION);
    @NonNull
    public final LanguageQualifier language;
    @NonNull
    public final RegionQualifier region;

    private Locale(@NonNull LanguageQualifier language, @NonNull RegionQualifier region) {
        if (language.getValue().equals("__")) {
            language = ANY_LANGUAGE;
        }
        if (region.getValue().equals("__")) {
            region = ANY_REGION;
        }
        this.language = language;
        this.region = region;
    }

    @NonNull
    public static Locale create(@NonNull LanguageQualifier language, @NonNull RegionQualifier region) {
        return new Locale(language, region);
    }

    public static Locale create(@NonNull LanguageQualifier language) {
        return new Locale(language, ANY_REGION);
    }

    @NonNull
    public Image getFlagImage() {
        String regionCode;
        Image image = null;
        String languageCode = this.hasLanguage() ? this.language.getValue() : null;
        String string = regionCode = this.hasRegion() ? this.region.getValue() : null;
        if (languageCode == null && regionCode == null) {
            return FlagManager.getGlobeIcon();
        }
        FlagManager icons = FlagManager.get();
        image = icons.getFlag(languageCode, regionCode);
        if (image == null) {
            image = FlagManager.getEmptyIcon();
        }
        return image;
    }

    public boolean hasLanguage() {
        return this.language != ANY_LANGUAGE;
    }

    public boolean hasRegion() {
        return this.region != ANY_REGION;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Locale other = (Locale)obj;
        if (this.language == null ? other.language != null : !this.language.equals((Object)other.language)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals((Object)other.region));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().addValue((Object)this.language.getValue()).addValue((Object)this.region.getValue()).toString();
    }

    public String toLocaleId() {
        return this.hasLanguage() && this.hasRegion() ? String.valueOf(this.language.getValue()) + "-" + this.region.getValue() : (this.hasLanguage() ? this.language.getValue() : "");
    }
}

