/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.drawable;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlDelegate;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DocumentDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.drawable.DrawableContentAssist;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.resources.ResourceFolderType;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DrawableEditorDelegate
extends CommonXmlDelegate {
    public static final String LEGACY_EDITOR_ID = "com.android.ide.eclipse.editors.drawable.DrawableEditor";
    private String mRootTag;

    private DrawableEditorDelegate(CommonXmlEditor editor) {
        super(editor, new DrawableContentAssist());
        editor.addDefaultTargetListener();
    }

    @Override
    public void delegateCreateFormPages() {
    }

    @Override
    public void delegateXmlModelChanged(Document xmlDoc) {
        AndroidTargetData data;
        Element rootElement = xmlDoc.getDocumentElement();
        if (rootElement != null) {
            this.mRootTag = rootElement.getTagName();
        }
        this.delegateInitUiRootNode(false);
        if (this.mRootTag != null && !this.mRootTag.equals(this.getUiRootNode().getDescriptor().getXmlLocalName()) && (data = this.getEditor().getTargetData()) != null) {
            ElementDescriptor descriptor = data.getDrawableDescriptors().getElementDescriptor(this.mRootTag);
            this.getUiRootNode().setEditor(null);
            this.getUiRootNode().setXmlDocument(null);
            this.setUiRootNode(descriptor.createUiNode());
            this.getUiRootNode().setXmlDocument(xmlDoc);
            this.getUiRootNode().setEditor(this.getEditor());
        }
        if (this.getUiRootNode().getDescriptor() instanceof DocumentDescriptor) {
            this.getUiRootNode().loadFromXmlNode(xmlDoc);
        } else {
            this.getUiRootNode().loadFromXmlNode(rootElement);
        }
    }

    @Override
    public void delegateInitUiRootNode(boolean force) {
        if (this.getUiRootNode() == null || force) {
            ElementDescriptor descriptor;
            boolean reload = false;
            AndroidTargetData data = this.getEditor().getTargetData();
            if (data == null) {
                descriptor = new DocumentDescriptor("temp", null);
            } else {
                descriptor = data.getDrawableDescriptors().getElementDescriptor(this.mRootTag);
                reload = true;
            }
            this.setUiRootNode(descriptor.createUiNode());
            this.getUiRootNode().setEditor(this.getEditor());
            if (reload) {
                this.onDescriptorsChanged();
            }
        }
    }

    private void onDescriptorsChanged() {
        IStructuredModel model = this.getEditor().getModelForRead();
        if (model != null) {
            try {
                Element node = this.getEditor().getXmlDocument(model).getDocumentElement();
                this.getUiRootNode().reloadFromXmlNode(node);
            }
            finally {
                model.releaseFromRead();
            }
        }
    }

    /* synthetic */ DrawableEditorDelegate(CommonXmlEditor commonXmlEditor, DrawableEditorDelegate drawableEditorDelegate) {
        this(commonXmlEditor);
    }

    public static class Creator
    implements CommonXmlDelegate.IDelegateCreator {
        public DrawableEditorDelegate createForFile(@NonNull CommonXmlEditor delegator, @Nullable ResourceFolderType type) {
            if (ResourceFolderType.DRAWABLE == type) {
                return new DrawableEditorDelegate(delegator, null);
            }
            return null;
        }
    }
}

