/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.common;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.eclipse.adt.internal.editors.common.CommonXmlEditor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.resources.ResourceFolderType;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;

public abstract class CommonXmlDelegate {
    private final CommonXmlEditor mEditor;
    private UiElementNode mUiRootNode;
    private IContentAssistProcessor mContentAssist;

    protected CommonXmlDelegate(CommonXmlEditor editor, IContentAssistProcessor contentAssist) {
        this.mEditor = editor;
        this.mContentAssist = contentAssist;
    }

    public void dispose() {
    }

    @NonNull
    public CommonXmlEditor getEditor() {
        return this.mEditor;
    }

    public UiElementNode getUiRootNode() {
        return this.mUiRootNode;
    }

    protected void setUiRootNode(UiElementNode uiRootNode) {
        this.mUiRootNode = uiRootNode;
    }

    public abstract void delegateInitUiRootNode(boolean var1);

    public boolean isSaveAsAllowed() {
        return true;
    }

    public abstract void delegateCreateFormPages();

    public void delegatePostCreatePages() {
    }

    public void delegateSetInput(IEditorInput input) {
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            IFile file = fileInput.getFile();
            this.getEditor().setPartName(file.getName());
        } else if (input instanceof IURIEditorInput) {
            IURIEditorInput uriInput = (IURIEditorInput)input;
            String name = uriInput.getName();
            this.getEditor().setPartName(name);
        }
    }

    public abstract void delegateXmlModelChanged(Document var1);

    public void delegatePageChange(int newPageIndex) {
    }

    public void delegatePostPageChange(int newPageIndex) {
    }

    public void delegateDoSave(IProgressMonitor monitor) {
    }

    public Job delegateRunLint() {
        return this.getEditor().startLintJob();
    }

    public Object delegateGetAdapter(Class<?> adapter) {
        return null;
    }

    public IContentAssistProcessor getAndroidContentAssistProcessor() {
        return this.mContentAssist;
    }

    public boolean delegateSupportsFormatOnGuiEdit() {
        return false;
    }

    public IFormPage delegatePostSetActivePage(IFormPage superReturned, String pageIndex) {
        return superReturned;
    }

    public void delegateActivated() {
    }

    public void delegateDeactivated() {
    }

    public String delegateGetPartName() {
        return null;
    }

    public int delegateGetPersistenceCategory() {
        return 4;
    }

    public static interface IActionContributorDelegate {
        public void setActiveEditor(IEditorPart var1, IActionBars var2);
    }

    public static interface IDelegateCreator {
        @Nullable
        public <T extends CommonXmlDelegate> T createForFile(@NonNull CommonXmlEditor var1, @Nullable ResourceFolderType var2);
    }
}

