/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.binaryxml;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.binaryxml.FileStorage;
import com.android.ide.eclipse.adt.internal.editors.binaryxml.XmlStorageEditorInput;
import java.io.File;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;

public class BinaryXMLMultiPageEditorPart
extends XMLMultiPageEditorPart {
    protected void setInput(IEditorInput input) {
        JarEntryEditorInput jarInput;
        IStorage storage;
        if (input instanceof JarEntryEditorInput && (storage = (jarInput = (JarEntryEditorInput)input).getStorage()) instanceof JarEntryFile) {
            JarEntryFile jarEntryFile = (JarEntryFile)storage;
            IPackageFragmentRoot fragmentRoot = jarEntryFile.getPackageFragmentRoot();
            if (fragmentRoot == null) {
                super.setInput(input);
                return;
            }
            IPath path = fragmentRoot.getPath();
            if (path == null) {
                super.setInput(input);
                return;
            }
            IPath filePath = (path = path.removeLastSegments(1)).append("data").append(jarEntryFile.getFullPath().toPortableString());
            File file = new File(filePath.toOSString());
            if (!file.isFile()) {
                super.setInput(input);
                return;
            }
            try {
                XmlStorageEditorInput newInput = new XmlStorageEditorInput(new FileStorage(file));
                super.setInput((IEditorInput)newInput);
                return;
            }
            catch (Exception e) {
                AdtPlugin.log(e, e.getMessage(), null);
            }
        }
        super.setInput(input);
    }
}

