/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.binaryxml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;

public class BinaryXMLDescriber
implements IContentDescriber {
    private static final int RES_XML_HEADER_SIZE = 8;
    private static final short RES_XML_TYPE = 3;

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        int status = 0;
        int length = 8;
        byte[] bytes = new byte[length];
        if (contents.read(bytes, 0, length) == length) {
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            short type = buf.getShort();
            short headerSize = buf.getShort();
            buf.getInt();
            if (type == 3 && headerSize == 8) {
                status = 2;
            }
        }
        return status;
    }

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[0];
    }
}

