/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.animator;

import com.android.ide.common.resources.platform.DeclareStyleableInfo;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.IDescriptorProvider;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnimatorDescriptors
implements IDescriptorProvider {
    private ElementDescriptor mDescriptor;
    private ElementDescriptor[] mRootDescriptors;
    private Map<String, ElementDescriptor> nameToDescriptor;

    @Override
    public ElementDescriptor getDescriptor() {
        if (this.mDescriptor == null) {
            this.mDescriptor = new ElementDescriptor("", this.getRootElementDescriptors());
        }
        return this.mDescriptor;
    }

    @Override
    public ElementDescriptor[] getRootElementDescriptors() {
        return this.mRootDescriptors;
    }

    ElementDescriptor getElementDescriptor(String rootTag) {
        ElementDescriptor descriptor;
        if (this.nameToDescriptor == null) {
            this.nameToDescriptor = new HashMap<String, ElementDescriptor>();
            ElementDescriptor[] elementDescriptorArray = this.getRootElementDescriptors();
            int n = elementDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                descriptor = elementDescriptorArray[n2];
                this.nameToDescriptor.put(descriptor.getXmlName(), descriptor);
                ++n2;
            }
        }
        if ((descriptor = this.nameToDescriptor.get(rootTag)) == null) {
            descriptor = this.getDescriptor();
        }
        return descriptor;
    }

    public synchronized void updateDescriptors(Map<String, DeclareStyleableInfo> styleMap) {
        if (styleMap == null) {
            return;
        }
        XmlnsAttributeDescriptor xmlns = new XmlnsAttributeDescriptor("android", "http://schemas.android.com/apk/res/android");
        ArrayList<ElementDescriptor> descriptors = new ArrayList<ElementDescriptor>();
        String sdkUrl = "http://developer.android.com/guide/topics/graphics/animation.html";
        ElementDescriptor set = AnimatorDescriptors.addElement(descriptors, styleMap, "set", "Animator Set", "AnimatorSet", null, null, sdkUrl, xmlns, null, true);
        ElementDescriptor objectAnimator = AnimatorDescriptors.addElement(descriptors, styleMap, "objectAnimator", "Object Animator", "PropertyAnimator", "Animator", null, sdkUrl, xmlns, null, true);
        ElementDescriptor animator = AnimatorDescriptors.addElement(descriptors, styleMap, "animator", "Animator", "Animator", null, null, sdkUrl, xmlns, null, true);
        this.mRootDescriptors = descriptors.toArray(new ElementDescriptor[descriptors.size()]);
        if (objectAnimator != null) {
            objectAnimator.setChildren(this.mRootDescriptors);
        }
        if (animator != null) {
            animator.setChildren(this.mRootDescriptors);
        }
        if (set != null) {
            set.setChildren(this.mRootDescriptors);
        }
    }

    public static ElementDescriptor addElement(List<ElementDescriptor> descriptors, Map<String, DeclareStyleableInfo> styleMap, String xmlName, String uiName, String styleName, String extraStyle, String tooltip, String sdkUrl, AttributeDescriptor extraAttribute, ElementDescriptor[] childrenElements, boolean mandatory) {
        DeclareStyleableInfo style = styleMap.get(styleName);
        if (style == null) {
            return null;
        }
        ElementDescriptor element = new ElementDescriptor(xmlName, uiName, tooltip, sdkUrl, null, childrenElements, mandatory);
        ArrayList<AttributeDescriptor> descs = new ArrayList<AttributeDescriptor>();
        DescriptorsUtils.appendAttributes(descs, null, "http://schemas.android.com/apk/res/android", style.getAttributes(), null, null);
        element.setTooltip(style.getJavaDoc());
        if (extraStyle != null && (style = styleMap.get(extraStyle)) != null) {
            DescriptorsUtils.appendAttributes(descs, null, "http://schemas.android.com/apk/res/android", style.getAttributes(), null, null);
        }
        if (extraAttribute != null) {
            descs.add(extraAttribute);
        }
        element.setAttributes(descs.toArray(new AttributeDescriptor[descs.size()]));
        if (descriptors != null) {
            descriptors.add(element);
        }
        return element;
    }
}

