/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public final class AaptParser {
    private static final Pattern sPattern0Line1 = Pattern.compile("^\\s+\\(skipping hidden file\\s'(.*)'\\)$");
    private static final Pattern sPattern1Line1 = Pattern.compile("^ERROR\\s+at\\s+line\\s+(\\d+):\\s+(.*)$");
    private static final Pattern sPattern1Line2 = Pattern.compile("^\\s+\\(Occurred while parsing\\s+(.*)\\)$");
    private static final Pattern sPattern2Line1 = Pattern.compile("^ERROR:\\s+(.+)$");
    private static final Pattern sPattern2Line2 = Pattern.compile("Defined\\s+at\\s+file\\s+(.+)\\s+line\\s+(\\d+)");
    private static final Pattern sPattern3Line1 = Pattern.compile("^(.+)\\sline\\s(\\d+):\\s(.+)$");
    private static final Pattern sPattern4Line1 = Pattern.compile("^Error\\s+parsing\\s+XML\\s+file\\s(.+)$");
    private static final Pattern sPattern4Line2 = Pattern.compile("^(.+)\\s+at\\s+line\\s+(\\d+)$");
    private static final Pattern sPattern5Line1 = Pattern.compile("^(.+?):(\\d+):\\s+WARNING:(.+)$");
    private static final Pattern sPattern6Line1 = Pattern.compile("^(.+?):(\\d+):\\s+(.+)$");
    private static final Pattern sPattern7Line1 = Pattern.compile("^ERROR:\\s+9-patch\\s+image\\s+(.+)\\s+malformed\\.$");
    private static final Pattern sPattern8Line1 = Pattern.compile("^(invalid resource directory name): (.*)$");
    private static final Pattern sValueRangePattern = Pattern.compile("\\(at '(.+)' with value '(.*)'\\)");
    private static final Pattern sRepeatedRangePattern = Pattern.compile("Resource entry (.+) already has bag item (.+)\\.");
    private static final Pattern sSkippingPattern = Pattern.compile("    \\(skipping (.+) .+ '(.*)'\\)");
    private static final Pattern sNewSkippingPattern = Pattern.compile("    \\(skipping .+ '(.+)' due to ANDROID_AAPT_IGNORE pattern '.+'\\)");
    private static final String ORIGINALLY_DEFINED_MSG = "Originally defined here.";
    private static final Pattern sNoResourcePattern = Pattern.compile("No resource found that matches the given name: attr '(.+)'\\.");
    private static final Pattern sRequiredPattern = Pattern.compile("A '(.+)' attribute is required for <(.+)>");
    private static final Pattern sPattern9Line1 = Pattern.compile("^Invalid configuration: (.+)$");
    private static final Pattern sXmlBlockPattern = Pattern.compile("W/ResourceType\\(.*\\): Bad XML block: no root element node found");

    public static boolean parseOutput(List<String> results, IProject project) {
        int size = results.size();
        if (size > 0) {
            return AaptParser.parseOutput(results.toArray(new String[size]), project);
        }
        return false;
    }

    public static boolean parseOutput(String[] results, IProject project) {
        if (results.length == 0) {
            return false;
        }
        String osRoot = project.getLocation().toOSString();
        int i = 0;
        while (i < results.length) {
            String p = results[i];
            Matcher m = sPattern0Line1.matcher(p);
            if (!m.matches()) {
                String msg;
                m = sPattern1Line1.matcher(p);
                if (m.matches()) {
                    String lineStr = m.group(1);
                    msg = m.group(2);
                    if ((m = AaptParser.getNextLineMatcher(results, ++i, sPattern1Line2)) == null) {
                        return true;
                    }
                    String location = m.group(1);
                    if (!AaptParser.checkAndMark(location, lineStr, msg, osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                        return true;
                    }
                } else {
                    String location;
                    m = sPattern7Line1.matcher(p);
                    if (m.matches()) {
                        location = m.group(1);
                        msg = p;
                        if (++i < results.length) {
                            msg = results[i].trim();
                            if (++i < results.length) {
                                msg = String.valueOf(msg) + " - " + results[i].trim();
                                ++i;
                            }
                        }
                        if (!AaptParser.checkAndMark(location, null, msg, osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                            return true;
                        }
                    } else {
                        String lineStr;
                        m = sPattern2Line1.matcher(p);
                        if (m.matches()) {
                            String msg2 = m.group(1);
                            if ((m = AaptParser.getNextLineMatcher(results, ++i, sPattern2Line2)) == null) {
                                return true;
                            }
                            String location2 = m.group(1);
                            if (!AaptParser.checkAndMark(location2, lineStr = m.group(2), msg2, osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                return true;
                            }
                        } else {
                            String msg3;
                            String lineStr2;
                            m = sPattern3Line1.matcher(p);
                            if (m.matches()) {
                                location = m.group(1);
                                if (!AaptParser.checkAndMark(location, lineStr2 = m.group(2), msg3 = m.group(3), osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                    return true;
                                }
                            } else {
                                m = sPattern4Line1.matcher(p);
                                if (m.matches()) {
                                    location = m.group(1);
                                    if ((m = AaptParser.getNextLineMatcher(results, ++i, sPattern4Line2)) == null) {
                                        return true;
                                    }
                                    msg = m.group(1);
                                    lineStr = m.group(2);
                                    if (!AaptParser.checkAndMark(location, lineStr, msg, osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                        return true;
                                    }
                                } else {
                                    m = sPattern5Line1.matcher(p);
                                    if (m.matches()) {
                                        location = m.group(1);
                                        if (!AaptParser.checkAndMark(location, lineStr2 = m.group(2), msg3 = m.group(3), osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 1)) {
                                            return true;
                                        }
                                    } else {
                                        m = sPattern6Line1.matcher(p);
                                        if (m.matches()) {
                                            location = m.group(1);
                                            if (!AaptParser.checkAndMark(location, lineStr2 = m.group(2), msg3 = m.group(3), osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                                return true;
                                            }
                                        } else {
                                            m = sPattern8Line1.matcher(p);
                                            if (m.matches()) {
                                                location = m.group(2);
                                                if (!AaptParser.checkAndMark(location, null, msg = m.group(1), osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 2)) {
                                                    return true;
                                                }
                                            } else {
                                                m = sPattern9Line1.matcher(p);
                                                if (m.matches()) {
                                                    String badConfig = m.group(1);
                                                    msg = String.format("APK Configuration filter '%1$s' is invalid", badConfig);
                                                    ++i;
                                                    if (!AaptParser.checkAndMark(null, null, msg, osRoot, project, "com.android.ide.eclipse.common.aapt2Problem", 2)) {
                                                        return true;
                                                    }
                                                } else {
                                                    m = sNewSkippingPattern.matcher(p);
                                                    if (m.matches()) {
                                                        location = m.group(1);
                                                        if (!(location.startsWith(".") || location.endsWith("~") || AaptParser.checkAndMark(location, null, p.trim(), osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 1))) {
                                                            return true;
                                                        }
                                                    } else {
                                                        m = sSkippingPattern.matcher(p);
                                                        if (m.matches()) {
                                                            location = m.group(2);
                                                            String type = m.group(1);
                                                            if (!(type.equals("backup") || type.equals("hidden") || type.equals("index") || AaptParser.checkAndMark(location, null, p.trim(), osRoot, project, "com.android.ide.eclipse.common.aaptProblem", 1))) {
                                                                return true;
                                                            }
                                                        } else {
                                                            m = sXmlBlockPattern.matcher(p);
                                                            if (m.matches()) {
                                                                if (results.length == 1) {
                                                                    return true;
                                                                }
                                                            } else {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private static final boolean checkAndMark(String location, String lineStr, String message, String root, IProject project, String markerId, int severity) {
        IRegion region;
        File f;
        if (location != null && !(f = new File(location)).exists()) {
            return false;
        }
        int line = -1;
        if (lineStr != null) {
            try {
                line = Integer.parseInt(lineStr);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        IProject f2 = project;
        if (location != null && (f2 = AaptParser.getResourceFromFullPath(location, root, project)) == null) {
            return false;
        }
        int startOffset = -1;
        int endOffset = -1;
        if (f2 instanceof IFile && (region = AaptParser.findRange((IFile)f2, line, message)) != null) {
            startOffset = region.getOffset();
            endOffset = startOffset + region.getLength();
        }
        boolean markerAlreadyExists = false;
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = f2.findMarkers(markerId, true, 0);
            if (markers.length != 0) {
                String tmpMsg;
                int tmpSeverity;
                int tmpLine;
                int tmpEnd;
                int tmpBegin;
                IMarker marker = iMarkerArray[0];
                if ((startOffset == -1 || (tmpBegin = marker.getAttribute("charStart", -1)) == startOffset && (tmpEnd = marker.getAttribute("charEnd", -1)) == startOffset) && (tmpLine = marker.getAttribute("lineNumber", -1)) == line && (tmpSeverity = marker.getAttribute("severity", -1)) == severity && (tmpMsg = marker.getAttribute("message", null)) != null && tmpMsg.equals(message)) {
                    markerAlreadyExists = true;
                }
            }
        }
        catch (CoreException coreException) {}
        if (!markerAlreadyExists) {
            BaseProjectHelper.markResource((IResource)f2, markerId, message, line, startOffset, endOffset, severity);
        }
        return true;
    }

    private static IRegion findRange(IFile file, int line, String message) {
        Matcher matcher = sValueRangePattern.matcher(message);
        if (matcher.find()) {
            String property = matcher.group(1);
            String value = matcher.group(2);
            if (value.length() > 0) {
                return AaptParser.findRange(file, line, property, value);
            }
            IRegion region1 = AaptParser.findRange(file, line, property, "\"\"");
            IRegion region2 = AaptParser.findRange(file, line, property, "''");
            if (region1 == null) {
                if (region2 == null) {
                    return AaptParser.findRange(file, line, property, null);
                }
                return region2;
            }
            if (region2 == null) {
                return region1;
            }
            if (region1.getOffset() < region2.getOffset()) {
                return region1;
            }
            return region2;
        }
        matcher = sRepeatedRangePattern.matcher(message);
        if (matcher.find()) {
            String property = matcher.group(2);
            return AaptParser.findRange(file, line, property, null);
        }
        matcher = sNoResourcePattern.matcher(message);
        if (matcher.find()) {
            String property = matcher.group(1);
            return AaptParser.findRange(file, line, property, null);
        }
        matcher = sRequiredPattern.matcher(message);
        if (matcher.find()) {
            String elementName = matcher.group(2);
            IRegion region = AaptParser.findRange(file, line, String.valueOf('<') + elementName, null);
            if (region != null && region.getLength() > 1) {
                region = new Region(region.getOffset() + 1, region.getLength() - 1);
            }
            return region;
        }
        if (message.endsWith(ORIGINALLY_DEFINED_MSG)) {
            return AaptParser.findLineTextRange(file, line);
        }
        return null;
    }

    private static IRegion findRange(IFile file, int line, String first, String second) {
        IRegion region = null;
        TextFileDocumentProvider provider = new TextFileDocumentProvider();
        try {
            try {
                IRegion lineInfo;
                int lineStartOffset;
                FindReplaceDocumentAdapter adapter;
                provider.connect((Object)file);
                IDocument document = provider.getDocument((Object)file);
                if (document != null && (region = (adapter = new FindReplaceDocumentAdapter(document)).find(lineStartOffset = (lineInfo = document.getLineInformation(line - 1)).getOffset(), first, true, true, false, false)) != null && second != null) {
                    region = adapter.find(region.getOffset() + first.length(), second, true, true, false, false);
                }
            }
            catch (Exception e) {
                AdtPlugin.log(e, "Can't find range information for %1$s", file.getName());
                provider.disconnect((Object)file);
            }
        }
        finally {
            provider.disconnect((Object)file);
        }
        return region;
    }

    private static IRegion findLineTextRange(IFile file, int line) {
        TextFileDocumentProvider provider = new TextFileDocumentProvider();
        try {
            provider.connect((Object)file);
            IDocument document = provider.getDocument((Object)file);
            if (document != null) {
                char c;
                IRegion lineInfo = document.getLineInformation(line - 1);
                String lineContents = document.get(lineInfo.getOffset(), lineInfo.getLength());
                int lineBegin = 0;
                int lineEnd = lineContents.length() - 1;
                while (lineEnd >= 0) {
                    c = lineContents.charAt(lineEnd);
                    if (!Character.isWhitespace(c)) break;
                    --lineEnd;
                }
                ++lineEnd;
                while (lineBegin < lineEnd) {
                    c = lineContents.charAt(lineBegin);
                    if (!Character.isWhitespace(c)) break;
                    ++lineBegin;
                }
                if (lineBegin < lineEnd) {
                    Region region = new Region(lineInfo.getOffset() + lineBegin, lineEnd - lineBegin);
                    return region;
                }
            }
        }
        catch (Exception e) {
            AdtPlugin.log(e, "Can't find range information for %1$s", file.getName());
        }
        finally {
            provider.disconnect((Object)file);
        }
        return null;
    }

    private static final Matcher getNextLineMatcher(String[] lines, int nextIndex, Pattern pattern) {
        if (nextIndex == lines.length) {
            return null;
        }
        Matcher m = pattern.matcher(lines[nextIndex]);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    private static IResource getResourceFromFullPath(String filename, String root, IProject project) {
        String file;
        IResource r;
        if (filename.startsWith(root) && (r = project.findMember(file = filename.substring(root.length()))) != null && r.exists()) {
            return r;
        }
        return null;
    }
}

